/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces;

import com.sun.faces.util.FacesLogger;
import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.MetadataTarget;
import jakarta.faces.view.facelets.TagAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ComponentRule
extends MetaRule {
    private static final Logger log = FacesLogger.FACELETS_COMPONENT.getLogger();
    public static final ComponentRule Instance = new ComponentRule();

    @Override
    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(UIComponent.class)) {
            if (!attribute.isLiteral()) {
                Class<Object> type2 = meta.getPropertyType(name);
                if (type2 == null) {
                    type2 = Object.class;
                }
                return new ValueExpressionMetadata(name, type2, attribute);
            }
            if (meta.getWriteMethod(name) == null) {
                ComponentRule.warnAttr(attribute, meta.getTargetClass(), name);
                return new LiteralAttributeMetadata(name, attribute.getValue());
            }
        }
        return null;
    }

    private static void warnAttr(TagAttribute attr, Class<?> type2, String n) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(attr + " Property '" + n + "' is not on type: " + type2.getName());
        }
    }

    static final class ValueExpressionMetadata
    extends Metadata {
        private final String name;
        private final TagAttribute attr;
        private final Class<?> type;

        public ValueExpressionMetadata(String name, Class type2, TagAttribute attr) {
            this.name = name;
            this.attr = attr;
            this.type = type2;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueExpression(this.name, this.attr.getValueExpression(ctx, this.type));
        }
    }

    static final class LiteralAttributeMetadata
    extends Metadata {
        private final String name;
        private final String value;

        public LiteralAttributeMetadata(String name, String value) {
            this.value = value;
            this.name = name;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).getAttributes().put(this.name, this.value);
        }
    }
}

