/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.facelets.impl.DefaultFaceletFactory;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIImportConstants;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.ViewMetadata;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ViewMetadataImpl
extends ViewMetadata {
    private final String viewId;
    private DefaultFaceletFactory faceletFactory;

    public ViewMetadataImpl(String viewId) {
        this.viewId = viewId;
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }

    @Override
    public UIViewRoot createMetadataView(FacesContext context) {
        UIViewRoot metadataView = null;
        UIViewRoot currentViewRoot = context.getViewRoot();
        Map currentViewMapShallowCopy = Collections.emptyMap();
        try {
            Map<String, Object> currentViewMap;
            context.setProcessingEvents(false);
            if (this.faceletFactory == null) {
                this.faceletFactory = ApplicationAssociate.getInstance(context.getExternalContext()).getFaceletFactory();
            }
            metadataView = context.getApplication().getViewHandler().createView(context, this.viewId);
            context.getAttributes().put("com.sun.faces.viewId", this.viewId);
            if (currentViewRoot != null && !Util.isEmpty(currentViewMap = currentViewRoot.getViewMap(false))) {
                currentViewMapShallowCopy = new HashMap<String, Object>(currentViewMap);
                metadataView.getViewMap(true).putAll(currentViewMapShallowCopy);
            }
            if (currentViewRoot != null) {
                context.setViewRoot(metadataView);
            }
            this.faceletFactory.getMetadataFacelet(context, metadataView.getViewId()).applyMetadata(context, metadataView);
            ViewMetadataImpl.importConstantsIfNecessary(context, metadataView);
        }
        catch (FacesFileNotFoundException ffnfe) {
            try {
                context.getExternalContext().responseSendError(404, ffnfe.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            context.responseComplete();
        }
        catch (IOException ioe) {
            throw new FacesException(ioe);
        }
        finally {
            context.getAttributes().remove("com.sun.faces.viewId");
            if (currentViewRoot != null) {
                context.setViewRoot(currentViewRoot);
                if (!currentViewMapShallowCopy.isEmpty()) {
                    currentViewRoot.getViewMap(true).putAll(currentViewMapShallowCopy);
                    currentViewMapShallowCopy.clear();
                }
            }
            context.setProcessingEvents(true);
        }
        return metadataView;
    }

    private static void importConstantsIfNecessary(FacesContext context, UIViewRoot root) {
        for (UIImportConstants importConstants : ViewMetadataImpl.getImportConstants(root)) {
            Map<String, Object> applicationMap;
            String type2 = importConstants.getType();
            if (type2 == null) {
                throw new IllegalArgumentException("UIImportConstants type attribute is required.");
            }
            String var = importConstants.getVar();
            if (var == null) {
                int innerClass = type2.lastIndexOf(36);
                int outerClass = type2.lastIndexOf(46);
                var = type2.substring(Math.max(innerClass, outerClass) + 1);
            }
            if ((applicationMap = context.getExternalContext().getApplicationMap()).containsKey(type2)) continue;
            applicationMap.putIfAbsent(var, ViewMetadataImpl.collectConstants(type2));
        }
    }

    private static Map<String, Object> collectConstants(String type2) {
        LinkedHashMap<String, Object> constants = new LinkedHashMap<String, Object>();
        for (Field field : ViewMetadataImpl.toClass(type2).getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                constants.put(field.getName(), field.get(null));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("UIImportConstants cannot access constant field '%s' of type '%s'.", type2, field.getName()), e);
            }
        }
        return Collections.unmodifiableMap(new ConstantsMap(constants, type2));
    }

    private static Class<?> toClass(String type2) {
        try {
            return Class.forName(type2, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            int i = type2.lastIndexOf(46);
            if (i > 0) {
                try {
                    return ViewMetadataImpl.toClass(new StringBuilder(type2).replace(i, i + 1, "$").toString());
                }
                catch (Exception ignore) {
                    Object var3_4 = null;
                }
            }
            throw new IllegalArgumentException(String.format("UIImportConstants cannot find type '%s' in classpath.", type2), e);
        }
    }

    private static class ConstantsMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 7036447585721834948L;
        private String type;

        public ConstantsMap(Map<String, Object> map, String type2) {
            this.type = type2;
            this.putAll(map);
        }

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                throw new IllegalArgumentException(String.format("UIImportConstants type '%s' does not have the constant '%s'.", this.type, key));
            }
            return super.get(key);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && this.type.equals(((ConstantsMap)object).type);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.type.hashCode();
        }
    }
}

