/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.logger;

import com.sun.enterprise.web.logger.FileLoggerHandler;
import jakarta.inject.Inject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Formatter;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
public class FileLoggerHandlerFactory
implements PostConstruct {
    @Inject
    @Optional
    private Formatter logFormatter;
    private static ConcurrentMap<String, FileLoggerHandler> map = new ConcurrentHashMap<String, FileLoggerHandler>();

    @Override
    public void postConstruct() {
    }

    public synchronized FileLoggerHandler getHandler(String logFile) {
        FileLoggerHandler handler = (FileLoggerHandler)map.get(logFile);
        if (handler == null) {
            handler = new FileLoggerHandler(logFile);
            if (this.logFormatter != null) {
                handler.setFormatter(this.logFormatter);
            }
            map.put(logFile, handler);
        }
        return handler;
    }

    public synchronized void removeHandler(String logFile) {
        map.remove(logFile);
    }
}

