/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.services.impl.ContainerMapper;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class SnifferAdapter
extends HttpHandler {
    private static final Logger LOGGER = KernelLoggerInfo.getLogger();
    @Inject
    private ContainerRegistry containerRegistry;
    @Inject
    private ContainerStarter containerStarter;
    @Inject
    private ModulesRegistry modulesRegistry;
    private Sniffer sniffer;
    private ContainerMapper mapper;
    private HttpHandler adapter;

    public void initialize(Sniffer sniffer, ContainerMapper mapper) {
        this.sniffer = sniffer;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(Request req, Response resp) throws Exception {
        if (this.adapter != null) {
            this.adapter.service(req, resp);
            return;
        }
        ContainerRegistry containerRegistry = this.containerRegistry;
        synchronized (containerRegistry) {
            if (this.adapter != null) {
                this.adapter.service(req, resp);
                return;
            }
            if (this.containerRegistry.getContainer(this.sniffer.getContainersNames()[0]) != null) {
                LOGGER.fine("Container is claimed to be started...");
                this.containerRegistry.getContainer(this.sniffer.getContainersNames()[0]).getContainer();
            } else {
                long startTime = System.currentTimeMillis();
                LOGGER.log(Level.INFO, "NCLS-CORE-00061", this.sniffer.getModuleType());
                try {
                    Collection<EngineInfo<?, ?>> containersInfo = this.containerStarter.startContainer(this.sniffer);
                    if (containersInfo != null && !containersInfo.isEmpty()) {
                        for (EngineInfo<?, ?> info : containersInfo) {
                            LOGGER.log(Level.FINE, "Got container, deployer is {0}", info.getDeployer());
                            info.getContainer();
                            LOGGER.log(Level.INFO, "NCLS-CORE-00062", new Object[]{this.sniffer.getModuleType(), System.currentTimeMillis() - startTime});
                        }
                    } else {
                        LOGGER.severe("NCLS-CORE-00063");
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "NCLS-CORE-00064", new Object[]{this.sniffer.getContainersNames()[0], e});
                }
            }
            DataChunk decodedURI = req.getRequest().getRequestURIRef().getDecodedRequestURIBC();
            try {
                MappingData mappingData = ContainerMapper.getNote(req);
                mappingData.recycle();
                this.adapter = this.mapper.mapUriWithSemicolon(req, decodedURI, 0, null);
                if (this.adapter.equals(this)) {
                    this.adapter = null;
                    throw new RuntimeException("SnifferAdapter cannot map themself.");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NCLS-CORE-00065", e);
                throw e;
            }
            if (this.adapter == null) {
                throw new RuntimeException("No Adapter found.");
            }
            this.adapter.service(req, resp);
        }
    }
}

