/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ADBAwareHttpHandler;
import com.sun.enterprise.v3.services.impl.Endpoint;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.SnifferAdapter;
import java.io.CharConversionException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.grizzly.config.ContextRootInfo;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.http.Note;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MimeType;
import org.glassfish.internal.grizzly.ContextMapper;
import org.glassfish.kernel.KernelLoggerInfo;

public class ContainerMapper
extends ADBAwareHttpHandler {
    private static final Logger LOGGER = KernelLoggerInfo.getLogger();
    private static final String ROOT = "";
    private static final AfterServiceListener afterServiceListener = new AfterServiceListenerImpl();
    private static final Note<MappingData> MAPPING_DATA = Request.createNote("MappingData");
    private static final Note<DataChunk> DATA_CHUNK = Request.createNote("DataChunk");
    private final GrizzlyListener listener;
    private final GrizzlyService grizzlyService;
    private final ReentrantReadWriteLock mapperLock;
    private ContextMapper mapper;
    private String defaultHostName = "server";
    private boolean mapMultipleAdapter;

    public ContainerMapper(GrizzlyService service, GrizzlyListener grizzlyListener) {
        this.listener = grizzlyListener;
        this.grizzlyService = service;
        this.mapperLock = service.obtainMapperLock();
    }

    protected void setDefaultHost(String defaultHost) {
        this.mapperLock.writeLock().lock();
        try {
            this.defaultHostName = defaultHost;
        }
        finally {
            this.mapperLock.writeLock().unlock();
        }
    }

    protected void setMapper(ContextMapper mapper) {
        this.mapper = mapper;
    }

    protected void configureMapper() {
        this.mapperLock.writeLock().lock();
        try {
            this.mapper.setDefaultHostName(this.defaultHostName);
            this.mapper.addHost(this.defaultHostName, new String[0], null);
            this.mapper.addContext(this.defaultHostName, ROOT, new ContextRootInfo(this, null), new String[]{"index.html", "index.htm"}, null);
            Mapper.setAllowReplacement(true);
        }
        finally {
            this.mapperLock.writeLock().unlock();
        }
    }

    @Override
    public void service(Request request, Response response) throws Exception {
        try {
            request.addAfterServiceListener(afterServiceListener);
            this.lookupHandler(request, response).call();
        }
        catch (Exception ex) {
            this.logAndSendError(request, response, ex);
        }
    }

    private void logAndSendError(Request request, Response response, Exception ex) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LogHelper.log(LOGGER, Level.WARNING, "NCLS-CORE-00090", ex, this.toUrlForLogging(request));
        }
        if (response.getResponse() == null) {
            LOGGER.log(Level.WARNING, "Response is not set in {0}, there's nothing we can do now.", response);
            return;
        }
        try {
            response.sendError(500);
        }
        catch (Exception ex2) {
            LOGGER.log(Level.WARNING, "NCLS-CORE-00091", ex2);
        }
    }

    private Object toUrlForLogging(Request request) {
        try {
            return request.getRequest() == null ? null : request.getRequest().getRequestURIRef().getDecodedRequestURIBC();
        }
        catch (CharConversionException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Callable lookupHandler(Request request, Response response) throws CharConversionException, Exception {
        this.mapperLock.readLock().lock();
        try {
            Callable<Object> callable;
            HttpHandler httpHandler;
            if (!this.mapMultipleAdapter && (httpHandler = this.mapper.getHttpHandler()) != null) {
                request.setNote(MAPPING_DATA, null);
                HttpHandlerCallable httpHandlerCallable = new HttpHandlerCallable(httpHandler, request, response);
                return httpHandlerCallable;
            }
            DataChunk decodedURI = request.getRequest().getRequestURIRef().getDecodedRequestURIBC(this.isAllowEncodedSlash());
            MappingData mappingData = request.getNote(MAPPING_DATA);
            if (mappingData == null) {
                mappingData = new MappingData();
                request.setNote(MAPPING_DATA, mappingData);
            } else {
                mappingData.recycle();
            }
            CharChunk decodedURICC = decodedURI.getCharChunk();
            int semicolon = decodedURICC.indexOf(';', 0);
            HttpHandler httpHandler2 = this.mapUriWithSemicolon(request, decodedURI, semicolon, mappingData);
            if (httpHandler2 == null || httpHandler2 instanceof ContainerMapper) {
                Object ext = decodedURI.toString();
                String type2 = ROOT;
                if (((String)ext).lastIndexOf(".") > 0) {
                    ext = "*" + ((String)ext).substring(((String)ext).lastIndexOf("."));
                    type2 = ((String)ext).substring(((String)ext).lastIndexOf(".") + 1);
                }
                if (!MimeType.contains(type2) && !"/".equals(ext)) {
                    this.initializeFileURLPattern((String)ext);
                    mappingData.recycle();
                    httpHandler2 = this.mapUriWithSemicolon(request, decodedURI, semicolon, mappingData);
                } else {
                    SuperCallable superCallable = new SuperCallable(request, response);
                    return superCallable;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request: {0} was mapped to Adapter: {1}", new Object[]{decodedURI, httpHandler2});
            }
            if (httpHandler2 == null || httpHandler2 instanceof ContainerMapper) {
                callable = new SuperCallable(request, response);
                return callable;
            }
            callable = new HttpHandlerCallable(httpHandler2, request, response);
            return callable;
        }
        finally {
            this.mapperLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFileURLPattern(String ext) {
        for (Sniffer sniffer : this.grizzlyService.getServiceLocator().getAllServices(Sniffer.class, new Annotation[0])) {
            boolean match = false;
            if (sniffer.getURLPatterns() == null) continue;
            for (String pattern : sniffer.getURLPatterns()) {
                if (!pattern.equalsIgnoreCase(ext)) continue;
                match = true;
                break;
            }
            if (!match) continue;
            HttpHandler httpHandler = this.grizzlyService.getServiceLocator().getService(SnifferAdapter.class, new Annotation[0]);
            ((SnifferAdapter)httpHandler).initialize(sniffer, this);
            ContextRootInfo contextRootInfo = new ContextRootInfo(httpHandler, null);
            this.mapperLock.readLock().unlock();
            this.mapperLock.writeLock().lock();
            try {
                for (String pattern : sniffer.getURLPatterns()) {
                    for (String host : this.grizzlyService.hosts) {
                        this.mapper.addWrapper(host, ROOT, pattern, contextRootInfo, "*.jsp".equals(pattern) || "*.jspx".equals(pattern));
                    }
                }
            }
            finally {
                this.mapperLock.readLock().lock();
                this.mapperLock.writeLock().unlock();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final HttpHandler mapUriWithSemicolon(Request req, DataChunk decodedURI, int semicolonPos, MappingData mappingData) throws Exception {
        this.mapperLock.readLock().lock();
        try {
            CharChunk charChunk = decodedURI.getCharChunk();
            int oldStart = charChunk.getStart();
            int oldEnd = charChunk.getEnd();
            if (semicolonPos == 0) {
                semicolonPos = decodedURI.indexOf(';', 0);
            }
            DataChunk localDecodedURI = decodedURI;
            if (semicolonPos >= 0) {
                charChunk.setEnd(semicolonPos);
                localDecodedURI = req.getNote(DATA_CHUNK);
                if (localDecodedURI == null) {
                    localDecodedURI = DataChunk.newInstance();
                    req.setNote(DATA_CHUNK, localDecodedURI);
                }
                localDecodedURI.duplicate(decodedURI);
            }
            try {
                HttpHandler httpHandler = this.map(req, localDecodedURI, mappingData);
                charChunk.setStart(oldStart);
                charChunk.setEnd(oldEnd);
                return httpHandler;
            }
            catch (Throwable throwable) {
                charChunk.setStart(oldStart);
                charChunk.setEnd(oldEnd);
                throw throwable;
            }
        }
        finally {
            this.mapperLock.readLock().unlock();
        }
    }

    private HttpHandler map(Request req, DataChunk decodedURI, MappingData mappingData) throws Exception {
        if (mappingData == null) {
            mappingData = ContainerMapper.getNote(req);
        }
        this.mapper.map(req.getRequest().serverName(), decodedURI, mappingData);
        ContainerMapper.updatePaths(req, mappingData);
        if (mappingData.context != null && (mappingData.context instanceof ContextRootInfo || mappingData.wrapper instanceof ContextRootInfo)) {
            ContextRootInfo contextRootInfo = mappingData.wrapper != null ? (ContextRootInfo)mappingData.wrapper : (ContextRootInfo)mappingData.context;
            return contextRootInfo.getHttpHandler();
        }
        if (mappingData.context != null && "com.sun.enterprise.web.WebModule".equals(mappingData.context.getClass().getName())) {
            return this.mapper.getHttpHandler();
        }
        return null;
    }

    public void register(String contextRoot, Collection<String> hostNames, HttpHandler httpService, ApplicationContainer container) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "MAPPER({0}) REGISTER contextRoot: {1} adapter: {2} container: {3} port: {4}", new Object[]{this, contextRoot, httpService, container, String.valueOf(this.listener.getPort())});
        }
        this.mapMultipleAdapter = true;
        ContextRootInfo contextRootInfo = new ContextRootInfo(httpService, container);
        for (String hostName : hostNames) {
            this.mapper.addContext(hostName, contextRoot, contextRootInfo, new String[0], null);
        }
    }

    public void unregister(String contextRoot) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "MAPPER({0}) UNREGISTER contextRoot: {1}", new Object[]{this, contextRoot});
        }
        for (String host : this.grizzlyService.hosts) {
            this.mapper.removeContext(host, contextRoot);
        }
    }

    public void register(final Endpoint endpoint) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "MAPPER({0}) REGISTER endpoint: {1}", new Object[]{this, endpoint});
        }
        this.mapMultipleAdapter = true;
        String contextRoot = endpoint.getContextRoot();
        Collection<String> virtualServerNames = endpoint.getVirtualServers();
        ContextRootInfo contextRootInfo = new ContextRootInfo(new ContextRootInfo.Holder(){

            @Override
            public HttpHandler getHttpHandler() {
                return endpoint.getEndpointHandler();
            }

            @Override
            public Object getContainer() {
                return endpoint.getContainer();
            }
        });
        for (String hostName : virtualServerNames) {
            this.mapper.addContext(hostName, contextRoot, contextRootInfo, new String[0], null);
        }
    }

    public void unregister(Endpoint endpoint) {
        this.unregister(endpoint.getContextRoot());
    }

    protected static MappingData getNote(Request request) {
        return request.getNote(MAPPING_DATA);
    }

    private static final class HttpHandlerCallable
    implements Callable<Object> {
        private final HttpHandler httpHandler;
        private final Request request;
        private final Response response;

        private HttpHandlerCallable(HttpHandler httpHandler, Request request, Response response) {
            this.httpHandler = httpHandler;
            this.request = request;
            this.response = response;
        }

        @Override
        public Object call() throws Exception {
            this.httpHandler.service(this.request, this.response);
            return null;
        }
    }

    private final class SuperCallable
    implements Callable<Object> {
        private final Request req;
        private final Response res;

        private SuperCallable(Request req, Response res) {
            this.req = req;
            this.res = res;
        }

        @Override
        public Object call() throws Exception {
            ContainerMapper.super.service(this.req, this.res);
            return null;
        }
    }

    private static final class AfterServiceListenerImpl
    implements AfterServiceListener {
        private AfterServiceListenerImpl() {
        }

        @Override
        public void onAfterService(Request request) {
            MappingData mappingData = ContainerMapper.getNote(request);
            if (mappingData != null) {
                mappingData.recycle();
            }
        }
    }
}

