/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.listener;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

@Service
@RunLevel(mode=1, value=1)
public final class CombinedJavaConfigSystemPropertyListener
implements PostConstruct,
ConfigListener {
    @Inject
    ServiceLocator habitat;
    @Inject
    Transactions transactions;
    private Domain domain;
    private Cluster cluster;
    private Config config;
    private Server server;
    private JavaConfig jc;
    volatile List<String> oldProps;
    volatile Map<String, String> oldAttrs;
    static final Logger logger = KernelLoggerInfo.getLogger();
    private static final String SYS_PROP_REGEX = "=";
    static final String DPREFIX = "-D";

    @Override
    public void postConstruct() {
        this.domain = this.habitat.getService(Domain.class, new Annotation[0]);
        this.cluster = this.habitat.getService(Cluster.class, "default-instance-name", new Annotation[0]);
        this.config = this.habitat.getService(Config.class, "default-instance-name", new Annotation[0]);
        this.server = this.habitat.getService(Server.class, "default-instance-name", new Annotation[0]);
        this.jc = this.config.getJavaConfig();
        if (this.jc != null) {
            ((ObservableBean)((Object)ConfigSupport.getImpl(this.jc))).addListener(this);
        }
        if (this.jc != null && this.jc.getJvmOptions() != null) {
            this.oldProps = new ArrayList<String>(this.jc.getJvmOptions());
            this.oldAttrs = CombinedJavaConfigSystemPropertyListener.collectAttrs(this.jc);
        }
        this.transactions.addListenerForType(SystemProperty.class, this);
    }

    private static Map<String, String> collectAttrs(JavaConfig jc) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("JavaHome", jc.getJavaHome());
        values.put("DebugEnabled", jc.getDebugEnabled());
        values.put("DebugOptions", jc.getDebugOptions());
        values.put("RmicOptions", jc.getRmicOptions());
        values.put("JavacOptions", jc.getJavacOptions());
        values.put("ClasspathPrefix", jc.getClasspathPrefix());
        values.put("ClasspathSuffix", jc.getClasspathSuffix());
        values.put("ServerClasspath", jc.getServerClasspath());
        values.put("SystemClasspath", jc.getSystemClasspath());
        values.put("NativeLibraryPathPrefix", jc.getNativeLibraryPathPrefix());
        values.put("NativeLibraryPathSuffix", jc.getNativeLibraryPathSuffix());
        values.put("BytecodePreprocessors", jc.getBytecodePreprocessors());
        values.put("EnvClasspathIgnored", jc.getEnvClasspathIgnored());
        return values;
    }

    @Override
    public synchronized UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        UnprocessedChangeEvents unp = ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> tc, T t) {
                NotProcessed result = null;
                if (tc == Profiler.class) {
                    result = new NotProcessed("Creation or changes to a profiler require restart");
                } else if (tc == Property.class && t.getParent().getClass() == JavaConfig.class) {
                    result = new NotProcessed("Addition of properties to JavaConfig requires restart");
                } else if (tc == JavaConfig.class && t instanceof JavaConfig) {
                    JavaConfig njc = (JavaConfig)t;
                    CombinedJavaConfigSystemPropertyListener.this.logFine(type2, njc);
                    ArrayList<String> curProps = new ArrayList<String>(njc.getJvmOptions());
                    boolean jvmOptionsWereChanged = !CombinedJavaConfigSystemPropertyListener.this.oldProps.equals(curProps);
                    List<String> reasons = CombinedJavaConfigSystemPropertyListener.this.handle(CombinedJavaConfigSystemPropertyListener.this.oldProps, curProps);
                    CombinedJavaConfigSystemPropertyListener.this.oldProps = curProps;
                    Map<String, String> curAttrs = CombinedJavaConfigSystemPropertyListener.collectAttrs(njc);
                    reasons.addAll(CombinedJavaConfigSystemPropertyListener.this.handleAttrs(CombinedJavaConfigSystemPropertyListener.this.oldAttrs, curAttrs));
                    CombinedJavaConfigSystemPropertyListener.this.oldAttrs = curAttrs;
                    result = reasons.isEmpty() ? null : new NotProcessed(CombinedJavaConfigSystemPropertyListener.toString(reasons));
                } else if (tc == SystemProperty.class && t instanceof SystemProperty) {
                    String pname;
                    SystemProperty sp = (SystemProperty)t;
                    ConfigBeanProxy proxy = sp.getParent();
                    ConfigView p = ConfigSupport.getImpl(proxy);
                    if ((p == ConfigSupport.getImpl(CombinedJavaConfigSystemPropertyListener.this.server) || p == ConfigSupport.getImpl(CombinedJavaConfigSystemPropertyListener.this.config) || CombinedJavaConfigSystemPropertyListener.this.cluster != null && p == ConfigSupport.getImpl(CombinedJavaConfigSystemPropertyListener.this.cluster) || p == ConfigSupport.getImpl(CombinedJavaConfigSystemPropertyListener.this.domain)) && (CombinedJavaConfigSystemPropertyListener.referencesProperty(pname = sp.getName(), CombinedJavaConfigSystemPropertyListener.this.oldProps) || CombinedJavaConfigSystemPropertyListener.referencesProperty(pname, CombinedJavaConfigSystemPropertyListener.this.oldAttrs.values()))) {
                        result = new NotProcessed("The system-property, " + pname + ", that is referenced by the Java configuration, was modified");
                    }
                    if (type2 == Changed.TYPE.ADD || type2 == Changed.TYPE.CHANGE) {
                        if (proxy instanceof Domain) {
                            return CombinedJavaConfigSystemPropertyListener.this.addToDomain(sp);
                        }
                        if (proxy instanceof Config && p == ConfigSupport.getImpl(CombinedJavaConfigSystemPropertyListener.this.config)) {
                            return CombinedJavaConfigSystemPropertyListener.this.addToConfig(sp);
                        }
                        if (CombinedJavaConfigSystemPropertyListener.this.cluster != null && proxy instanceof Cluster && p == ConfigSupport.getImpl(CombinedJavaConfigSystemPropertyListener.this.cluster)) {
                            return CombinedJavaConfigSystemPropertyListener.this.addToCluster(sp);
                        }
                        if (proxy instanceof Server && p == ConfigSupport.getImpl(CombinedJavaConfigSystemPropertyListener.this.server)) {
                            return CombinedJavaConfigSystemPropertyListener.this.addToServer(sp);
                        }
                    } else if (type2 == Changed.TYPE.REMOVE) {
                        if (proxy instanceof Domain) {
                            return CombinedJavaConfigSystemPropertyListener.this.removeFromDomain(sp);
                        }
                        if (proxy instanceof Config && p == ConfigSupport.getImpl(CombinedJavaConfigSystemPropertyListener.this.config)) {
                            return CombinedJavaConfigSystemPropertyListener.this.removeFromConfig(sp);
                        }
                        if (CombinedJavaConfigSystemPropertyListener.this.cluster != null && proxy instanceof Cluster && p == ConfigSupport.getImpl(CombinedJavaConfigSystemPropertyListener.this.cluster)) {
                            return CombinedJavaConfigSystemPropertyListener.this.removeFromCluster(sp);
                        }
                        if (proxy instanceof Server && p == ConfigSupport.getImpl(CombinedJavaConfigSystemPropertyListener.this.server)) {
                            return CombinedJavaConfigSystemPropertyListener.this.removeFromServer(sp);
                        }
                    }
                }
                return result;
            }
        }, logger);
        return unp;
    }

    private void logFine(Changed.TYPE ct, JavaConfig njc) {
        Level level = Level.FINE;
        if (logger.isLoggable(level)) {
            logger.log(level, "<java-config> changed");
            int os = this.oldProps.size();
            int ns = njc.getJvmOptions().size();
            if (os > ns) {
                logger.log(level, "a system property or a JVM option was removed (old size = {0}), new size: ({1}), restart is required, based on the property", new Object[]{os, ns});
            } else if (os < ns) {
                logger.log(level, "a system property or a JVM option was added, (old size = {0}), new size: ({1}), restart is required, based on the property", new Object[]{os, ns});
            } else {
                logger.log(level, "an attribute was changed, restart required");
            }
        }
    }

    private List<String> handleAttrs(Map<String, String> old, Map<String, String> cur) {
        if (old.size() != cur.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> reasons = new ArrayList<String>();
        for (Map.Entry<String, String> olde : old.entrySet()) {
            String key = olde.getKey();
            String oldValue = olde.getValue();
            String curValue = cur.get(key);
            boolean changed = oldValue == null && curValue != null || oldValue != null && curValue == null || oldValue != null && !oldValue.equals(curValue);
            if (!changed) continue;
            reasons.add("JavaConfig attribute '" + key + "' was changed from '" + oldValue + "' to '" + curValue + "'");
        }
        return reasons;
    }

    private List<String> handle(List<String> old, List<String> cur) {
        Object np = null;
        HashSet<String> added = new HashSet<String>(cur);
        added.removeAll(old);
        HashSet<String> removed = new HashSet<String>(old);
        removed.removeAll(cur);
        return this.getNotProcessed(removed, added);
    }

    private String[] nvp(String s) {
        String[] nv = s.split(SYS_PROP_REGEX);
        String name = nv[0];
        String value = s.substring(name.length());
        if (value.startsWith(SYS_PROP_REGEX)) {
            value = value.substring(1);
        }
        value = TranslatedConfigView.getTranslatedValue(value).toString();
        return new String[]{name, value};
    }

    private static String stripPrefix(String s) {
        return s.startsWith(DPREFIX) ? s.substring(DPREFIX.length()) : s;
    }

    private List<String> getNotProcessed(Set<String> removals, Set<String> additions) {
        String name;
        String[] nv;
        ArrayList<String> reasons = new ArrayList<String>();
        for (String removed : removals) {
            nv = this.nvp(removed);
            name = nv[0];
            if (this.possiblyDynamicallyReconfigurable(removed)) {
                System.clearProperty(CombinedJavaConfigSystemPropertyListener.stripPrefix(name));
                continue;
            }
            String newItem = null;
            for (String added : additions) {
                if (!name.equals(this.nvp(added)[0])) continue;
                newItem = added;
                additions.remove(added);
                break;
            }
            String msg = null;
            msg = newItem != null ? "Change from '" + removed + "' to '" + newItem + "' cannot take effect without server restart" : "Removal of: " + removed + " cannot take effect without server restart";
            reasons.add(msg);
        }
        for (String added : additions) {
            nv = this.nvp(added);
            name = nv[0];
            String newValue = nv[1];
            if (this.possiblyDynamicallyReconfigurable(added)) {
                System.setProperty(CombinedJavaConfigSystemPropertyListener.stripPrefix(name), newValue);
                continue;
            }
            reasons.add("Addition of: '" + added + "' cannot take effect without server restart");
        }
        return reasons;
    }

    private static String toString(List<String> items) {
        StringBuffer buf = new StringBuffer();
        String delim = ", ";
        for (String s : items) {
            if (buf.length() != 0) {
                buf.append(", ");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private boolean possiblyDynamicallyReconfigurable(String s) {
        return s.startsWith(DPREFIX) && !s.startsWith("-Djava.") && !s.startsWith("-Djavax.");
    }

    private static boolean referencesProperty(String pname, Collection<String> values) {
        String ref = "${" + pname + "}";
        for (String v : values) {
            if (v == null || !v.contains(ref)) continue;
            return true;
        }
        return false;
    }

    private NotProcessed removeFromServer(SystemProperty sp) {
        SystemProperty sysProp = this.getServerSystemProperty(sp.getName());
        if (sysProp == null) {
            sysProp = this.getClusterSystemProperty(sp.getName());
        }
        if (sysProp == null) {
            sysProp = this.getConfigSystemProperty(sp.getName());
        }
        if (sysProp == null) {
            sysProp = this.getDomainSystemProperty(sp.getName());
        }
        if (sysProp == null) {
            System.clearProperty(sp.getName());
        } else {
            System.setProperty(sysProp.getName(), sysProp.getValue());
        }
        return null;
    }

    private NotProcessed removeFromCluster(SystemProperty sp) {
        SystemProperty sysProp = this.getConfigSystemProperty(sp.getName());
        if (sysProp == null) {
            sysProp = this.getDomainSystemProperty(sp.getName());
        }
        if (sysProp == null) {
            if (!this.serverHas(sp)) {
                System.clearProperty(sp.getName());
            }
        } else if (!this.serverHas(sp)) {
            System.setProperty(sysProp.getName(), sysProp.getValue());
        }
        return null;
    }

    private NotProcessed removeFromConfig(SystemProperty sp) {
        SystemProperty sysProp = this.getDomainSystemProperty(sp.getName());
        if (sysProp == null) {
            if (!this.serverHas(sp) && !this.clusterHas(sp)) {
                System.clearProperty(sp.getName());
            }
        } else if (!this.serverHas(sp) && !this.clusterHas(sp)) {
            System.setProperty(sysProp.getName(), sysProp.getValue());
        }
        return null;
    }

    private NotProcessed removeFromDomain(SystemProperty sp) {
        if (!(this.serverHas(sp) || this.clusterHas(sp) || this.configHas(sp))) {
            System.clearProperty(sp.getName());
        }
        return null;
    }

    private NotProcessed addToServer(SystemProperty sp) {
        System.setProperty(sp.getName(), sp.getValue());
        return null;
    }

    private NotProcessed addToCluster(SystemProperty sp) {
        if (!this.serverHas(sp)) {
            System.setProperty(sp.getName(), sp.getValue());
        }
        return null;
    }

    private NotProcessed addToConfig(SystemProperty sp) {
        if (!this.serverHas(sp) && !this.clusterHas(sp)) {
            System.setProperty(sp.getName(), sp.getValue());
        }
        return null;
    }

    private NotProcessed addToDomain(SystemProperty sp) {
        if (!(this.serverHas(sp) || this.clusterHas(sp) || this.configHas(sp))) {
            System.setProperty(sp.getName(), sp.getValue());
        }
        return null;
    }

    private boolean serverHas(SystemProperty sp) {
        List<SystemProperty> ssps = this.server.getSystemProperty();
        return this.hasSystemProperty(ssps, sp);
    }

    private boolean configHas(SystemProperty sp) {
        Config c = this.domain.getConfigNamed(this.server.getConfigRef());
        return c != null ? this.hasSystemProperty(c.getSystemProperty(), sp) : false;
    }

    private boolean clusterHas(SystemProperty sp) {
        Cluster c = this.domain.getClusterForInstance(this.server.getName());
        return c != null ? this.hasSystemProperty(c.getSystemProperty(), sp) : false;
    }

    private SystemProperty getServerSystemProperty(String spName) {
        return this.getSystemProperty(this.server.getSystemProperty(), spName);
    }

    private SystemProperty getClusterSystemProperty(String spName) {
        Cluster c = this.domain.getClusterForInstance(this.server.getName());
        return c != null ? this.getSystemProperty(c.getSystemProperty(), spName) : null;
    }

    private SystemProperty getConfigSystemProperty(String spName) {
        Config c = this.domain.getConfigNamed(this.server.getConfigRef());
        return c != null ? this.getSystemProperty(c.getSystemProperty(), spName) : null;
    }

    private SystemProperty getDomainSystemProperty(String spName) {
        return this.getSystemProperty(this.domain.getSystemProperty(), spName);
    }

    private boolean hasSystemProperty(List<SystemProperty> ssps, SystemProperty sp) {
        return this.getSystemProperty(ssps, sp.getName()) != null;
    }

    private SystemProperty getSystemProperty(List<SystemProperty> ssps, String spName) {
        if (ssps != null) {
            for (SystemProperty sp : ssps) {
                if (!sp.getName().equals(spName)) continue;
                return sp;
            }
        }
        return null;
    }
}

