/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.commands.StringBuilderNewLineAppender;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import javax.management.MBeanServerConnection;

class ThreadMonitor {
    private final MBeanServerConnection mbsc;
    private final StringManager sm = StringManager.getManager(ThreadMonitor.class);
    private static final BigInteger S2NANOS = new BigInteger("1000000000");
    public static final String NA = "NOT_AVAILABLE";

    public ThreadMonitor(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    public final String getThreadDump() {
        StringBuilder sb = new StringBuilder();
        StringBuilderNewLineAppender td = new StringBuilderNewLineAppender(sb);
        try {
            ThreadInfo[] tinfos;
            ThreadMXBean tmx = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Threading", ThreadMXBean.class);
            String title = this.getTitle();
            td.append(title);
            td.append(this.sm.getString("thread.no", tmx.getThreadCount()));
            td.append(this.sm.getString("daemon.thread.no", tmx.getDaemonThreadCount()));
            td.append(this.sm.getString("peak.thread.no", tmx.getPeakThreadCount()));
            boolean tc = tmx.isThreadContentionMonitoringSupported();
            td.append(this.sm.getString("thread.contention.monitoring.supported", tc));
            boolean tce = tmx.isThreadContentionMonitoringEnabled();
            td.append(this.sm.getString("thread.contention.monitoring.enabled", tce));
            boolean cputs = tmx.isThreadCpuTimeSupported();
            td.append(this.sm.getString("thread.cputime.supported", cputs));
            boolean cpute = tmx.isThreadCpuTimeEnabled();
            td.append(this.sm.getString("thread.cputime.enabled", cpute));
            long[] tids = tmx.getAllThreadIds();
            for (ThreadInfo ti : tinfos = tmx.getThreadInfo(tids, Integer.MAX_VALUE)) {
                td.append(this.dumpThread(tmx, ti));
            }
            sb.append(this.getDeadlockInfo(tmx));
            return td.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String dumpThread(ThreadMXBean tmx, ThreadInfo ti) {
        boolean tcput;
        String msg = "--------------------------------------------------------------------------------";
        StringBuilder sb = new StringBuilder(msg).append(StringBuilderNewLineAppender.SEP);
        sb.append(this.sm.getString("execution.info")).append(StringBuilderNewLineAppender.SEP);
        sb.append("-----------------------").append(StringBuilderNewLineAppender.SEP);
        long ids = ti.getThreadId();
        String ss = ti.getThreadState().toString();
        msg = this.sm.getString("thread.title", this.quote(ti.getThreadName()), ids, ss);
        sb.append(msg);
        if (ti.getLockName() != null) {
            msg = this.sm.getString("thread.waiting.on", ti.getLockName());
            sb.append(" " + msg);
        }
        if (ti.isSuspended()) {
            msg = this.sm.getString("thread.suspended");
            sb.append(" " + msg);
        }
        if (ti.isInNative()) {
            msg = this.sm.getString("thread.in.native");
            sb.append(" " + msg);
        }
        sb.append(StringBuilderNewLineAppender.SEP);
        for (StackTraceElement ste : ti.getStackTrace()) {
            msg = this.sm.getString("thread.stack.element", ste.toString());
            sb.append(msg);
            sb.append(StringBuilderNewLineAppender.SEP);
        }
        msg = this.sm.getString("sync.info");
        sb.append(msg).append(StringBuilderNewLineAppender.SEP);
        sb.append("-----------------------").append(StringBuilderNewLineAppender.SEP);
        if (ti.getLockOwnerName() != null) {
            msg = this.sm.getString("lock.owner.details", ti.getLockOwnerName(), ti.getLockOwnerId());
            sb.append(msg).append(StringBuilderNewLineAppender.SEP);
        }
        msg = this.sm.getString("thread.blocked.times", ti.getBlockedCount());
        sb.append(msg).append(StringBuilderNewLineAppender.SEP);
        long bt = ti.getBlockedTime();
        if (bt != -1L) {
            msg = this.sm.getString("thread.blocked.totaltime", bt);
            sb.append(msg).append(StringBuilderNewLineAppender.SEP);
        }
        long wt = ti.getWaitedCount();
        msg = this.sm.getString("wait.times", wt);
        sb.append(msg).append(StringBuilderNewLineAppender.SEP);
        boolean bl = tcput = tmx.isThreadCpuTimeEnabled();
        if (tcput) {
            long user;
            long cput = tmx.getThreadCpuTime(ti.getThreadId());
            if (cput != -1L) {
                BigInteger[] times = new BigInteger("" + cput).divideAndRemainder(S2NANOS);
                msg = this.sm.getString("thread.total.cpu.time", times[0], times[1]);
                sb.append(msg).append(StringBuilderNewLineAppender.SEP);
            }
            if ((user = tmx.getThreadUserTime(ti.getThreadId())) != -1L) {
                BigInteger[] times = new BigInteger("" + cput).divideAndRemainder(S2NANOS);
                msg = this.sm.getString("thread.cpu.user.time", times[0], times[1]);
                sb.append(msg).append(StringBuilderNewLineAppender.SEP);
            }
        }
        msg = this.sm.getString("lock.owner.details", ti.getLockOwnerName(), ti.getLockOwnerId());
        msg = this.getMoreThreadInfo(ti, "getLockedMonitors");
        sb.append(this.sm.getString("monitor.info", msg)).append(StringBuilderNewLineAppender.SEP);
        msg = this.getMoreThreadInfo(ti, "getLockedSynchronizers");
        sb.append(this.sm.getString("ownable.sync.info", msg));
        return sb.toString();
    }

    private String getTitle() throws Exception {
        RuntimeMXBean rt = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Runtime", RuntimeMXBean.class);
        String vmname = rt.getVmName();
        String vmversion = rt.getVmVersion();
        String vmvendor = rt.getVmVendor();
        String title = this.sm.getString("td.title", vmname, vmversion, vmvendor);
        return title;
    }

    private String quote(String uq) {
        StringBuilder sb = new StringBuilder("\"");
        sb.append(uq).append("\"");
        return sb.toString();
    }

    private String getDeadlockInfo(ThreadMXBean tmx) {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        long[] dts = tmx.findMonitorDeadlockedThreads();
        if (dts == null) {
            sb.append(this.sm.getString("no.deadlock"));
        } else {
            sb.append(this.sm.getString("deadlocks.found"));
            for (long dt : dts) {
                ThreadInfo ti = tmx.getThreadInfo(dt);
                sb.append(this.dumpThread(tmx, ti));
            }
        }
        return sb.toString();
    }

    private String getMoreThreadInfo(ThreadInfo ti, String mn) {
        String ms = "";
        try {
            Method glmm = ti.getClass().getDeclaredMethod(mn, null);
            Object monitors = glmm.invoke((Object)ti, (Object[])null);
            if (monitors instanceof Object[]) {
                return Arrays.toString((Object[])monitors);
            }
            return NA;
        }
        catch (Exception e) {
            return NA;
        }
    }
}

