/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.cluster.ClusterCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.Progress;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@I18n(value="start.cluster.command")
@Service(name="start-cluster")
@ExecuteOn(value={RuntimeType.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="start-cluster", description="Start Cluster", params={@RestParam(name="id", value="$parent")})})
@Progress
public class StartClusterCommand
implements AdminCommand {
    @Inject
    private ServerEnvironment env;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner runner;
    @Param(optional=false, primary=true)
    private String clusterName;
    @Param(optional=true, defaultValue="false")
    private boolean debug;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        logger2.info(Strings.get("start.cluster", this.clusterName));
        if (!this.env.isDas()) {
            String msg = Strings.get("cluster.command.notDas");
            logger2.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        ClusterCommandHelper clusterHelper = new ClusterCommandHelper(this.domain, this.runner);
        try {
            String commandName = "start-instance";
            clusterHelper.runCommand(commandName, null, this.clusterName, context, this.debug, this.verbose);
        }
        catch (CommandException e) {
            String msg = e.getLocalizedMessage();
            logger2.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
    }
}

