/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.v3.admin.adapter.AdapterState;
import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import com.sun.enterprise.v3.admin.adapter.ConsoleConfigCode;
import com.sun.enterprise.v3.server.ApplicationLoaderService;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.config.ConfigSupport;

final class InstallerThread
extends Thread {
    private final Logger logger = KernelLoggerInfo.getLogger();
    private final Domain domain;
    private final ServerEnvironmentImpl serverEnvironment;
    private final String contextRoot;
    private final AdminConsoleAdapter adapter;
    private final ServiceLocator serviceLocator;
    private final List<String> virtualServers;

    InstallerThread(AdminConsoleAdapter adapter, ServiceLocator serviceLocator, Domain domain, ServerEnvironmentImpl serverEnvironment, String contextRoot, List<String> virtualServers) {
        this.adapter = adapter;
        this.serviceLocator = serviceLocator;
        this.domain = domain;
        this.serverEnvironment = serverEnvironment;
        this.contextRoot = contextRoot;
        this.virtualServers = virtualServers;
    }

    @Override
    public void run() {
        try {
            this.install();
            this.load();
            this.adapter.setInstalling(false);
        }
        catch (Exception e) {
            this.adapter.setInstalling(false);
            this.adapter.setStateMsg(AdapterState.APPLICATION_NOT_INSTALLED);
            this.logger.log(Level.INFO, "NCLS-CORE-00093", e);
        }
    }

    private void install() throws Exception {
        if (this.domain.getSystemApplicationReferencedFrom(this.serverEnvironment.getInstanceName(), "__admingui") != null) {
            this.adapter.setStateMsg(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
            return;
        }
        this.adapter.setStateMsg(AdapterState.INSTALLING);
        this.logger.log(Level.FINE, "Installing the Admin Console Application...");
        ConsoleConfigCode code = new ConsoleConfigCode(this.virtualServers, this.contextRoot);
        Server instance = this.domain.getServerNamed(this.serverEnvironment.getInstanceName());
        ConfigSupport.apply(code, this.domain.getSystemApplications(), instance);
        this.adapter.setStateMsg(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
        this.logger.log(Level.FINE, "Admin Console Application Installed.");
    }

    private void load() {
        ApplicationRegistry applicationRegistry = this.serviceLocator.getService(ApplicationRegistry.class, new Annotation[0]);
        ApplicationInfo applicationInfo = applicationRegistry.get("__admingui");
        if (applicationInfo != null && applicationInfo.isLoaded()) {
            this.adapter.setStateMsg(AdapterState.APPLICATION_LOADED);
            return;
        }
        Application config = this.adapter.getConfig();
        if (config == null) {
            throw new IllegalStateException("Admin Console application has no system app entry!");
        }
        this.adapter.setStateMsg(AdapterState.APPLICATION_LOADING);
        String instance = this.serverEnvironment.getInstanceName();
        ApplicationRef applicationRef = this.domain.getApplicationRefInServer(instance, "__admingui");
        this.serviceLocator.getService(ApplicationLoaderService.class, new Annotation[0]).processApplication(config, applicationRef);
        this.adapter.setStateMsg(AdapterState.APPLICATION_LOADED);
    }
}

