/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

public class V2DottedNameSupport {
    public Map<Dom, String> getAllDottedNodes(ConfigBeanProxy proxy) {
        return this.getAllDottedNodes(Dom.unwrap(proxy));
    }

    public Map<Dom, String> getAllDottedNodes(Dom root) {
        HashMap<Dom, String> result = new HashMap<Dom, String>();
        this.getAllSubDottedNames(null, root, result);
        return result;
    }

    protected void getAllSubDottedNames(String prefix, Dom parent, Map<Dom, String> result) {
        Set<String> elementNames = parent.getElementNames();
        for (String childName : elementNames) {
            boolean collection = true;
            if (parent.model.findIgnoreCase(childName) != null) {
                if (parent.model.getElement(childName).isLeaf()) continue;
                collection = parent.model.getElement(childName).isCollection();
            }
            for (Dom child : parent.nodeElements(childName)) {
                StringBuffer newPrefix = new StringBuffer();
                if (prefix == null) {
                    newPrefix.append(childName);
                } else {
                    newPrefix.append(prefix).append(".").append(childName);
                }
                if (collection) {
                    String name = child.getKey();
                    if (name == null) {
                        name = child.attribute("name");
                    }
                    if (name != null) {
                        newPrefix.append(".").append(name);
                    }
                    this.getAllSubDottedNames(newPrefix.toString(), child, result);
                    continue;
                }
                this.getAllSubDottedNames(newPrefix.toString(), child, result);
            }
        }
        if (prefix != null) {
            result.put(parent, prefix);
        }
    }

    public Map<String, String> getNodeAttributes(Dom node, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String attrName : node.model.getAttributeNames()) {
            String value = (String)node.model.findIgnoreCase(attrName).get(node, (Type)((Object)String.class));
            if (value == null) continue;
            result.put(attrName, value);
        }
        for (String leafName : node.model.getLeafElementNames()) {
            List<String> values = node.leafElements(leafName);
            Iterator<String> i = values.iterator();
            StringBuffer value = new StringBuffer();
            while (i.hasNext()) {
                String nextValue = i.next();
                if (nextValue == null) continue;
                value.append(nextValue);
                if (!i.hasNext()) continue;
                value.append(",");
            }
            result.put(leafName, value.toString());
        }
        return result;
    }

    public Map<Dom, String> getMatchingNodes(Map<Dom, String> nodes, String pattern) {
        HashMap<Dom, String> result = new HashMap<Dom, String>();
        for (Map.Entry<Dom, String> entry : nodes.entrySet()) {
            String dottedName = entry.getValue();
            if (!this.matches(dottedName, pattern)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public boolean matches(String dottedName, String pattern) {
        StringTokenizer patternToken = new StringTokenizer(pattern, ".");
        if (patternToken.hasMoreElements()) {
            String token = (String)patternToken.nextElement();
            if (token.startsWith("*")) {
                if (token.length() > 1) {
                    String delim = token.substring(1);
                    if (dottedName.indexOf(delim) != -1) {
                        String remaining = dottedName.substring(dottedName.indexOf(delim) + delim.length());
                        if (remaining.length() == 0) {
                            return !patternToken.hasMoreElements();
                        }
                        remaining = remaining.substring(1);
                        if (patternToken.hasMoreElements()) {
                            return this.matches(remaining, pattern.substring(token.length() + 1));
                        }
                        return true;
                    }
                    return false;
                }
                if (patternToken.hasMoreElements()) {
                    String delim = (String)patternToken.nextElement();
                    if (dottedName.lastIndexOf(46) == -1) {
                        return delim.equals("*");
                    }
                    if (dottedName.contains("." + delim)) {
                        String remaining = dottedName.substring(dottedName.indexOf("." + delim) + 1);
                        return this.matches(remaining, pattern.substring(token.length() + 1));
                    }
                    return false;
                }
                return true;
            }
            String delim = token.lastIndexOf("*") != -1 ? token.substring(0, token.lastIndexOf("*")) : token;
            if (this.matchName(dottedName, delim)) {
                if (patternToken.hasMoreElements()) {
                    if (dottedName.length() <= delim.length() + 1) {
                        return pattern.substring(token.length() + 1).equals("*");
                    }
                    String remaining = dottedName.substring(delim.length() + 1);
                    return this.matches(remaining, pattern.substring(token.length() + 1));
                }
                if (dottedName.length() > delim.length()) {
                    String remaining = dottedName.substring(delim.length() + 1);
                    return remaining.indexOf(46) == -1;
                }
                return true;
            }
            return false;
        }
        return dottedName.indexOf(".") == -1;
    }

    protected boolean matchName(String a, String b) {
        String nextTokenName = a;
        if (a.indexOf(46) != -1) {
            nextTokenName = a.substring(0, a.indexOf(46));
        }
        return nextTokenName.equals(b) || nextTokenName.replace('_', '-').equals(b.replace('_', '-'));
    }

    public TreeNode[] getAliasedParent(Domain domain, String prefix) {
        String newPrefix;
        Object name;
        if (prefix.indexOf(46) != -1) {
            name = prefix.substring(0, prefix.indexOf(46));
            newPrefix = prefix.substring(((String)name).length() + 1);
        } else {
            name = prefix;
            newPrefix = "";
        }
        if (newPrefix.startsWith("resources")) {
            String relativeName = newPrefix;
            if (newPrefix.indexOf(46) != -1) {
                String str = newPrefix.substring(0, newPrefix.indexOf(46));
                relativeName = newPrefix.substring(str.length() + 1);
                name = (String)name + "." + str;
            }
            TreeNode[] result = new TreeNode[]{new TreeNode(Dom.unwrap(domain.getResources()), (String)name, relativeName)};
            return result;
        }
        for (Config config : domain.getConfigs().getConfig()) {
            if (!config.getName().equals(name)) continue;
            return new TreeNode[]{new TreeNode(Dom.unwrap(config), (String)name, newPrefix)};
        }
        Named[] nodes = this.getNamedNodes(domain.getServers().getServer(), domain.getConfigs().getConfig(), (String)name);
        if (nodes == null && domain.getClusters() != null) {
            nodes = this.getNamedNodes(domain.getClusters().getCluster(), domain.getConfigs().getConfig(), (String)name);
        }
        if (nodes != null) {
            TreeNode[] result = new TreeNode[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                result[i] = new TreeNode(Dom.unwrap(nodes[i]), (String)name, newPrefix);
            }
            return result;
        }
        return new TreeNode[]{new TreeNode(Dom.unwrap(domain), "", prefix)};
    }

    public Named[] getNamedNodes(List<? extends Named> target, List<? extends Named> references, String name) {
        for (Named named : target) {
            if (!named.getName().equals(name)) continue;
            if (named instanceof ReferenceContainer) {
                for (Named named2 : references) {
                    if (!named2.getName().equals(((ReferenceContainer)((Object)named)).getReference())) continue;
                    return new Named[]{named, named2};
                }
                continue;
            }
            return new Named[]{named};
        }
        return null;
    }

    public List<Map.Entry<Dom, String>> applyOverrideRules(List<Map.Entry<Dom, String>> nodes) {
        HashMap<String, Map.Entry<Dom, String>> store = new HashMap<String, Map.Entry<Dom, String>>();
        for (Map.Entry<Dom, String> currentNode : nodes) {
            int currNodePrecedenceLevel;
            Map.Entry storedNode = (Map.Entry)store.get(currentNode.getValue());
            if (storedNode == null) {
                store.put(currentNode.getValue(), currentNode);
                continue;
            }
            int storedNodePrecedenceLevel = this.getPrecedenceLevel((Dom)storedNode.getKey());
            if (storedNodePrecedenceLevel >= (currNodePrecedenceLevel = this.getPrecedenceLevel(currentNode.getKey()))) continue;
            store.put(currentNode.getValue(), currentNode);
        }
        ArrayList<Map.Entry<Dom, String>> finalList = new ArrayList<Map.Entry<Dom, String>>();
        finalList.addAll(store.values());
        store.clear();
        return finalList;
    }

    private int getPrecedenceLevel(Dom entry) {
        String parent = entry.parent().getImplementation();
        int level = 4;
        if (Config.class.getCanonicalName().equals(parent)) {
            level = 1;
        }
        if (Cluster.class.getCanonicalName().equals(parent)) {
            level = 2;
        }
        if (Server.class.getCanonicalName().equals(parent)) {
            level = 3;
        }
        return level;
    }

    public List<Map.Entry<Dom, String>> sortNodesByDottedName(Map<Dom, String> nodes) {
        ArrayList<Map.Entry<Dom, String>> mapEntries = new ArrayList<Map.Entry<Dom, String>>(nodes.entrySet());
        Collections.sort(mapEntries, new Comparator<Map.Entry<Dom, String>>(){

            @Override
            public int compare(Map.Entry<Dom, String> o1, Map.Entry<Dom, String> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        return mapEntries;
    }

    public List<org.glassfish.flashlight.datatree.TreeNode> sortTreeNodesByCompletePathName(List<org.glassfish.flashlight.datatree.TreeNode> nodes) {
        Collections.sort(nodes, new Comparator<org.glassfish.flashlight.datatree.TreeNode>(){

            @Override
            public int compare(org.glassfish.flashlight.datatree.TreeNode o1, org.glassfish.flashlight.datatree.TreeNode o2) {
                return o1.getCompletePathName().compareTo(o2.getCompletePathName());
            }
        });
        return nodes;
    }

    static final class TreeNode {
        final Dom node;
        final String name;
        final String relativeName;

        public TreeNode(Dom node, String name, String relativeName) {
            this.node = node;
            this.name = name;
            this.relativeName = relativeName;
        }
    }
}

