/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.event.AdminCommandEventBrokerImpl;
import com.sun.enterprise.admin.remote.RestPayloadImpl;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ManagedJobConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.AdminCommandInstanceImpl;
import com.sun.enterprise.v3.admin.CheckpointHelper;
import com.sun.enterprise.v3.admin.CommandRunnerImpl;
import com.sun.enterprise.v3.admin.CompletedJob;
import com.sun.enterprise.v3.admin.JobFileScanner;
import com.sun.enterprise.v3.server.ExecutorServiceFactory;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobInfos;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="job-manager")
@Singleton
public class JobManagerService
implements JobManager,
PostConstruct,
EventListener {
    private static final Logger logger = KernelLoggerInfo.getLogger();
    protected static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(JobManagerService.class);
    private static final String CHECKPOINT_MAINDATA = "MAINCMD";
    private static final int MAX_SIZE = 65535;
    private ManagedJobConfig managedJobConfig;
    private final ConcurrentHashMap<String, Job> jobRegistry = new ConcurrentHashMap();
    private final AtomicInteger lastId = new AtomicInteger(0);
    private final ConcurrentHashMap<String, CompletedJob> completedJobsInfo = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CheckpointHelper.CheckpointFilename> retryableJobsInfo = new ConcurrentHashMap();
    private final String JOBS_FILE = "jobs.xml";
    private ExecutorService pool;
    protected JAXBContext jaxbContext;
    protected File jobsFile;
    @Inject
    private Domain domain;
    @Inject
    private ExecutorServiceFactory executorFactory;
    @Inject
    private ServerEnvironment serverEnvironment;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private JobFileScanner jobFileScanner;
    @Inject
    Events events;
    @Inject
    CheckpointHelper checkpointHelper;
    @Inject
    CommandRunnerImpl commandRunner;

    @Override
    public synchronized String getNewId() {
        String nextIdToUse;
        int nextId = this.lastId.incrementAndGet();
        if (nextId > 65535) {
            this.reset();
        }
        return !this.idInUse(nextIdToUse = String.valueOf(nextId)) ? String.valueOf(nextId) : this.getNewId();
    }

    public JobInfo getCompletedJobForId(String id, File file) {
        for (JobInfo jobInfo : this.getCompletedJobs(file).getJobInfoList()) {
            if (!jobInfo.jobId.equals(id)) continue;
            return jobInfo;
        }
        return null;
    }

    @Override
    public JobInfo getCompletedJobForId(String id) {
        return this.getCompletedJobForId(id, this.getJobsFile());
    }

    private void reset() {
        this.lastId.set(0);
    }

    private boolean idInUse(String id) {
        return this.jobRegistry.containsKey(id) || this.completedJobsInfo.containsKey(id) || this.retryableJobsInfo.containsKey(id);
    }

    @Override
    public synchronized void registerJob(Job job) throws IllegalArgumentException {
        if (job == null) {
            throw new IllegalArgumentException(adminStrings.getLocalString("job.cannot.be.null", "Job cannot be null"));
        }
        if (this.jobRegistry.containsKey(job.getId())) {
            throw new IllegalArgumentException(adminStrings.getLocalString("job.id.in.use", "Job id is already in use."));
        }
        this.retryableJobsInfo.remove(job.getId());
        this.jobRegistry.put(job.getId(), job);
        if (job.getState() == AdminCommandState.State.PREPARED && job instanceof AdminCommandInstanceImpl) {
            ((AdminCommandInstanceImpl)job).setState(AdminCommandState.State.RUNNING);
        }
    }

    @Override
    public Iterator<Job> getJobs() {
        return this.jobRegistry.values().iterator();
    }

    @Override
    public Job get(String id) {
        return this.jobRegistry.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<JobInfo> getExpiredJobs(File file) {
        ArrayList<JobInfo> expiredJobs = new ArrayList<JobInfo>();
        File file2 = file;
        synchronized (file2) {
            JobInfos jobInfos = this.getCompletedJobs(file);
            for (JobInfo job : jobInfos.getJobInfoList()) {
                long executedTime = job.commandExecutionDate;
                long currentTime = System.currentTimeMillis();
                long jobsRetentionPeriod = 86400000L;
                this.managedJobConfig = this.domain.getExtensionByType(ManagedJobConfig.class);
                jobsRetentionPeriod = this.convert(this.managedJobConfig.getJobRetentionPeriod());
                if (currentTime - executedTime <= jobsRetentionPeriod || !job.state.equals(AdminCommandState.State.COMPLETED.name()) && !job.state.equals(AdminCommandState.State.REVERTED.name())) continue;
                expiredJobs.add(job);
            }
        }
        return expiredJobs;
    }

    public long convert(String input) {
        String period = input.substring(0, input.length() - 1);
        long timeInterval = Long.parseLong(period);
        String s = input.toLowerCase(Locale.US);
        long milliseconds = 86400000L;
        if (s.indexOf("s") > 0) {
            milliseconds = timeInterval * 1000L;
        } else if (s.indexOf("h") > 0) {
            milliseconds = timeInterval * 3600L * 1000L;
        } else if (s.indexOf("m") > 0) {
            milliseconds = timeInterval * 60L * 1000L;
        }
        return milliseconds;
    }

    @Override
    public synchronized void purgeJob(String id) {
        Job job = this.jobRegistry.remove(id);
        logger.fine(adminStrings.getLocalString("removed.expired.job", "Removed expired job ", job));
    }

    public void deleteCheckpoint(File parentDir, final String jobId) {
        File[] toDelete;
        for (File td : toDelete = parentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(jobId + ".") || name.startsWith(jobId + "-");
            }
        })) {
            td.delete();
        }
    }

    public ExecutorService getThreadPool() {
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobInfos getCompletedJobs(File jobsFile) {
        File file = jobsFile;
        synchronized (file) {
            try {
                if (this.jaxbContext == null) {
                    this.jaxbContext = JAXBContext.newInstance(JobInfos.class);
                }
                Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
                if (jobsFile.exists()) {
                    JobInfos jobInfos = (JobInfos)unmarshaller.unmarshal(jobsFile);
                    return jobInfos;
                }
            }
            catch (JAXBException e) {
                throw new RuntimeException(adminStrings.getLocalString("error.reading.completed.jobs", "Error reading completed jobs ", e.getLocalizedMessage()), e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfos purgeCompletedJobForId(String jobId, File file) {
        JobInfos completedJobInfos = this.getCompletedJobs(file);
        File file2 = file;
        synchronized (file2) {
            CopyOnWriteArrayList<JobInfo> jobList = new CopyOnWriteArrayList<JobInfo>();
            if (completedJobInfos != null) {
                jobList.addAll(completedJobInfos.getJobInfoList());
                for (JobInfo jobInfo : jobList) {
                    if (!jobInfo.jobId.equals(jobId)) continue;
                    jobList.remove(jobInfo);
                }
            }
            JobInfos jobInfos = new JobInfos();
            try {
                if (this.jaxbContext == null) {
                    this.jaxbContext = JAXBContext.newInstance(JobInfos.class);
                }
                jobInfos.setJobInfoList(jobList);
                Marshaller jaxbMarshaller = this.jaxbContext.createMarshaller();
                jaxbMarshaller.marshal((Object)jobInfos, file);
            }
            catch (JAXBException e) {
                throw new RuntimeException(adminStrings.getLocalString("error.purging.completed.job", "Error purging completed job ", jobId, e.getLocalizedMessage()), e);
            }
            return jobInfos;
        }
    }

    @Override
    public JobInfos purgeCompletedJobForId(String id) {
        return this.purgeCompletedJobForId(id, this.getJobsFile());
    }

    @Override
    public void postConstruct() {
        this.jobsFile = new File(this.serverEnvironment.getConfigDirPath(), "jobs.xml");
        this.pool = this.executorFactory.provide();
        Set<File> persistedJobFiles = this.jobFileScanner.getJobFiles();
        persistedJobFiles.add(this.jobsFile);
        for (File jobfile : persistedJobFiles) {
            if (jobfile == null) continue;
            this.reapCompletedJobs(jobfile);
            boolean dropInterruptedCommands = Boolean.valueOf(System.getProperty("org.glassfish.job-manager.drop-interrupted-commands"));
            Collection<CheckpointHelper.CheckpointFilename> listed = this.checkpointHelper.listCheckpoints(jobfile.getParentFile());
            for (CheckpointHelper.CheckpointFilename cf : listed) {
                if (dropInterruptedCommands) {
                    logger.info("Dropping checkpoint: " + String.valueOf(cf.getFile()));
                    this.deleteCheckpoint(cf.getParentDir(), cf.getJobId());
                    continue;
                }
                this.retryableJobsInfo.put(cf.getJobId(), cf);
            }
        }
        this.events.register(this);
    }

    @Override
    public File getJobsFile() {
        return this.jobsFile;
    }

    public void addToCompletedJobs(CompletedJob job) {
        this.completedJobsInfo.put(job.getId(), job);
    }

    public void removeFromCompletedJobs(String id) {
        this.completedJobsInfo.remove(id);
    }

    public ConcurrentHashMap<String, CompletedJob> getCompletedJobsInfo() {
        return this.completedJobsInfo;
    }

    public ConcurrentHashMap<String, CheckpointHelper.CheckpointFilename> getRetryableJobsInfo() {
        return this.retryableJobsInfo;
    }

    @Override
    public void checkpoint(AdminCommandContext context, Serializable data) throws IOException {
        this.checkpoint((AdminCommand)null, context);
        if (data != null) {
            this.checkpointAttachement(context.getJobId(), CHECKPOINT_MAINDATA, data);
        }
    }

    @Override
    public void checkpoint(AdminCommand command, AdminCommandContext context) throws IOException {
        if (!StringUtils.ok(context.getJobId())) {
            throw new IllegalArgumentException("Command is not managed");
        }
        Job job = this.get(context.getJobId());
        if (job.getJobsFile() == null) {
            job.setJobsFile(this.getJobsFile());
        }
        JobManager.Checkpoint chkp = new JobManager.Checkpoint(job, command, context);
        this.checkpointHelper.save(chkp);
        if (job instanceof AdminCommandInstanceImpl) {
            ((AdminCommandInstanceImpl)job).setState(AdminCommandState.State.RUNNING_RETRYABLE);
        }
    }

    public void checkpointAttachement(String jobId, String attachId, Serializable data) throws IOException {
        Job job = this.get(jobId);
        if (job.getJobsFile() == null) {
            job.setJobsFile(this.getJobsFile());
        }
        this.checkpointHelper.saveAttachment(data, job, attachId);
    }

    public <T extends Serializable> T loadCheckpointAttachement(String jobId, String attachId) throws IOException, ClassNotFoundException {
        Job job = this.get(jobId);
        if (job.getJobsFile() == null) {
            job.setJobsFile(this.getJobsFile());
        }
        return this.checkpointHelper.loadAttachment(job, attachId);
    }

    public Serializable loadCheckpointData(String jobId) throws IOException, ClassNotFoundException {
        return this.loadCheckpointAttachement(jobId, CHECKPOINT_MAINDATA);
    }

    public JobManager.Checkpoint loadCheckpoint(String jobId, Payload.Outbound outbound) throws IOException, ClassNotFoundException {
        Job job = this.get(jobId);
        CheckpointHelper.CheckpointFilename cf = null;
        if (job == null) {
            cf = this.getRetryableJobsInfo().get(jobId);
            if (cf == null) {
                cf = CheckpointHelper.CheckpointFilename.createBasic(jobId, this.getJobsFile());
            }
        } else {
            cf = CheckpointHelper.CheckpointFilename.createBasic(job);
        }
        return this.loadCheckpoint(cf, outbound);
    }

    private JobManager.Checkpoint loadCheckpoint(CheckpointHelper.CheckpointFilename cf, Payload.Outbound outbound) throws IOException, ClassNotFoundException {
        JobManager.Checkpoint result = this.checkpointHelper.load(cf, outbound);
        if (result != null) {
            this.serviceLocator.inject(result.getJob());
            this.serviceLocator.postConstruct(result.getJob());
            if (result.getCommand() != null) {
                this.serviceLocator.inject(result.getCommand());
                this.serviceLocator.postConstruct(result.getCommand());
            }
        }
        return result;
    }

    protected void reapCompletedJobs(File file) {
        JobInfos jobInfos;
        if (file != null && file.exists() && (jobInfos = this.getCompletedJobs(file)) != null) {
            for (JobInfo jobInfo : jobInfos.getJobInfoList()) {
                this.addToCompletedJobs(new CompletedJob(jobInfo.jobId, jobInfo.commandCompletionDate, jobInfo.getJobsFile()));
            }
        }
    }

    @Override
    public void event(@RestrictTo(value="server_ready") EventListener.Event<?> event) {
        if (event.is(EventTypes.SERVER_READY)) {
            if (!this.retryableJobsInfo.isEmpty()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        logger.fine("Restarting retryable jobs");
                        for (CheckpointHelper.CheckpointFilename cf : JobManagerService.this.retryableJobsInfo.values()) {
                            JobManagerService.this.reexecuteJobFromCheckpoint(cf);
                        }
                    }
                };
                new Thread(runnable).start();
            } else {
                logger.fine("No retryable job found");
            }
        }
    }

    private void reexecuteJobFromCheckpoint(CheckpointHelper.CheckpointFilename cf) {
        JobManager.Checkpoint checkpoint = null;
        try {
            RestPayloadImpl.Outbound outbound = new RestPayloadImpl.Outbound(true);
            checkpoint = this.loadCheckpoint(cf, (Payload.Outbound)outbound);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "NCLS-CORE-00094", ex);
        }
        if (checkpoint != null) {
            logger.log(Level.INFO, "NCLS-CORE-00095", new Object[]{checkpoint.getJob().getName()});
            this.commandRunner.executeFromCheckpoint(checkpoint, false, new AdminCommandEventBrokerImpl());
            ActionReport report = checkpoint.getContext().getActionReport();
            logger.log(Level.INFO, "NCLS-CORE-00096", new Object[]{checkpoint.getJob().getName(), report.getActionExitCode(), report.getTopMessagePart()});
        }
    }
}

