/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.glassfish.api.admin.ManagedJob;

public class AnnotationUtil {
    public static boolean presentTransitive(Class<? extends Annotation> annotationClass, Class<?> type2) {
        if (type2 == null) {
            return false;
        }
        if (type2.isAnnotationPresent(annotationClass)) {
            return true;
        }
        for (Annotation anno : type2.getAnnotations()) {
            if (!anno.annotationType().isAnnotationPresent(ManagedJob.class)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static Annotation[] createAnnotationInstances(Class<?> ... types) {
        Annotation[] instances = (Annotation[])Array.newInstance(Annotation.class, types.length);
        for (int i = 0; i < types.length; ++i) {
            instances[i] = AnnotationUtil.createAnnotationInstance(types[i]);
        }
        return instances;
    }

    public static Annotation createAnnotationInstance(Class<?> type2) {
        return (Annotation)Proxy.newProxyInstance(type2.getClassLoader(), new Class[]{type2}, (InvocationHandler)new AnnotationInvocationHandler(type2));
    }

    static class AnnotationInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<?> type;

        AnnotationInvocationHandler(Class<?> type2) {
            this.type = type2;
        }

        public boolean equals(Object other) {
            return this.type.isInstance(other);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return "@" + this.type.getName();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "annotationType": {
                    return this.type;
                }
                case "equals": {
                    return args.length > 0 && this.equals(args[0]);
                }
                case "hashCode": {
                    return this.hashCode();
                }
                case "toString": {
                    return this.toString();
                }
            }
            return null;
        }
    }
}

