/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.web.integration;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.runtime.common.wls.SecurityRoleAssignment;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.ee.authorization.AuthorizationUtil;
import com.sun.enterprise.security.ee.authorization.GlassFishAuthorizationService;
import com.sun.enterprise.security.ee.web.integration.LogUtils;
import com.sun.enterprise.security.ee.web.integration.WebSecurityManagerFactory;
import jakarta.security.jacc.PolicyContextException;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.UserNameAndPassword;

public class WebSecurityManager {
    private static final Logger logger = LogUtils.getLogger();
    private final GlassFishAuthorizationService authorizationService;
    private final WebSecurityManagerFactory webSecurityManagerFactory;
    private final String contextId;

    WebSecurityManager(WebBundleDescriptor webBundleDescriptor, ServerContext serverContext, WebSecurityManagerFactory webSecurityManagerFactory, boolean register) throws PolicyContextException {
        this.authorizationService = new GlassFishAuthorizationService(webBundleDescriptor, register);
        this.webSecurityManagerFactory = webSecurityManagerFactory;
        this.contextId = AuthorizationUtil.getContextID(webBundleDescriptor);
        if ("__asadmin".equals(this.getVirtualServers(webBundleDescriptor, serverContext))) {
            this.handleAdminVirtualServer(webBundleDescriptor, webSecurityManagerFactory);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Context id (id under which  WEB component in application will be created) = {0}", this.contextId);
            logger.log(Level.FINE, "[Web-Security] Codebase (module id for web component) {0}", WebSecurityManager.removeSpaces(this.contextId));
        }
    }

    public GlassFishAuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public void onLogin(HttpServletRequest httpServletRequest) {
        this.authorizationService.setSecurityInfo(httpServletRequest);
    }

    public void onLogout() {
        this.authorizationService.resetSecurityInfo();
    }

    public void release() throws PolicyContextException {
        this.authorizationService.release();
        this.webSecurityManagerFactory.getManager(this.contextId, true);
    }

    public void destroy() throws PolicyContextException {
        this.authorizationService.destroy();
        this.webSecurityManagerFactory.getManager(this.contextId, true);
    }

    private void handleAdminVirtualServer(WebBundleDescriptor webBundleDescriptor, WebSecurityManagerFactory webSecurityManagerFactory) {
        SecurityRoleAssignment[] sunRoleAssignments;
        LoginConfiguration loginConfiguration = webBundleDescriptor.getLoginConfiguration();
        if (loginConfiguration == null) {
            return;
        }
        String realmName = loginConfiguration.getRealmName();
        SunWebApp sunDescriptor = webBundleDescriptor.getSunDescriptor();
        if (sunDescriptor == null) {
            return;
        }
        SecurityRoleMapping[] sunRoleMappings = sunDescriptor.getSecurityRoleMapping();
        if (sunRoleMappings != null) {
            for (SecurityRoleMapping roleMapping : sunRoleMappings) {
                for (PrincipalNameDescriptor principal : roleMapping.getPrincipalNames()) {
                    webSecurityManagerFactory.putAdminPrincipal(realmName, new UserNameAndPassword(principal.getName()));
                }
                for (String group : roleMapping.getGroupNames()) {
                    webSecurityManagerFactory.putAdminGroup(group, realmName, new Group(group));
                }
            }
        }
        if ((sunRoleAssignments = sunDescriptor.getSecurityRoleAssignments()) != null) {
            for (SecurityRoleAssignment roleAssignment : sunRoleAssignments) {
                List<String> principals = roleAssignment.getPrincipalNames();
                if (roleAssignment.isExternallyDefined()) {
                    webSecurityManagerFactory.putAdminGroup(roleAssignment.getRoleName(), realmName, new Group(roleAssignment.getRoleName()));
                    continue;
                }
                for (String principal : principals) {
                    webSecurityManagerFactory.putAdminPrincipal(realmName, new UserNameAndPassword(principal));
                }
            }
        }
    }

    private String getVirtualServers(WebBundleDescriptor webBundleDescriptor, ServerContext serverContext) {
        String applicationName = webBundleDescriptor.getApplication().getRegistrationName();
        Server server = serverContext.getDefaultServices().getService(Server.class, new Annotation[0]);
        for (ApplicationRef appplicationRef : server.getApplicationRef()) {
            if (!appplicationRef.getRef().equals(applicationName)) continue;
            return appplicationRef.getVirtualServers();
        }
        return null;
    }

    private static String removeSpaces(String withSpaces) {
        return withSpaces.replace(' ', '_');
    }
}

