/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.authorization;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.ee.authorization.AuthorizationUtil;
import com.sun.enterprise.security.ee.authorization.GlassFishPrincipalMapper;
import com.sun.enterprise.security.ee.authorization.GlassFishToExousiaConverter;
import com.sun.enterprise.security.ee.authorization.cache.CachedPermission;
import com.sun.enterprise.security.ee.authorization.cache.CachedPermissionImpl;
import com.sun.enterprise.security.ee.authorization.cache.PermissionCache;
import com.sun.enterprise.security.ee.authorization.cache.PermissionCacheFactory;
import com.sun.enterprise.security.ee.web.integration.LogUtils;
import com.sun.enterprise.security.ee.web.integration.SecurityRoleMapperFactoryGen;
import com.sun.enterprise.security.ee.web.integration.WebPrincipal;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Permission;
import java.security.Principal;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.glassfish.exousia.AuthorizationService;

public class GlassFishAuthorizationService {
    private static final Logger logger = LogUtils.getLogger();
    public static final String CONSTRAINT_URI = "org.apache.catalina.CONSTRAINT_URI";
    private static final String RESOURCE = "hasResourcePermission";
    private static final String USERDATA = "hasUserDataPermission";
    private static final String EMPTY_STRING = "";
    private final String contextId;
    private static final WebResourcePermission allResources = new WebResourcePermission("/*", (String)null);
    private static final WebUserDataPermission allConnections = new WebUserDataPermission("/*", null);
    private static Permission[] protoPerms = new Permission[]{allResources, allConnections};
    private CachedPermission allResourcesCachedPermission;
    private CachedPermission allConnectionsCachedPermission;
    private PermissionCache uncheckedPermissionCache;
    private static Set<Principal> defaultPrincipalSet = SecurityContext.getDefaultSecurityContext().getPrincipalSet();
    private final boolean register;
    private final ThreadLocal<HttpServletRequest> currentRequest = new ThreadLocal();
    private final AuthorizationService exousiaAuthorizationService;

    public GlassFishAuthorizationService(WebBundleDescriptor webBundleDescriptor, boolean register) throws PolicyContextException {
        this.register = register;
        this.contextId = AuthorizationUtil.getContextID(webBundleDescriptor);
        String appName = webBundleDescriptor.getApplication().getRegistrationName();
        SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory().setAppNameForContext(appName, this.contextId);
        this.initPermissionCache();
        webBundleDescriptor.getContextParameters().stream().filter(param -> param.getName().equals("jakarta.security.jacc.PolicyConfigurationFactory.provider")).findAny().map(param -> this.loadFactory(webBundleDescriptor, param.getValue())).ifPresent(clazz -> this.installPolicyConfigurationFactory(webBundleDescriptor, (Class<?>)clazz));
        webBundleDescriptor.getContextParameters().stream().filter(param -> param.getName().equals("jakarta.security.jacc.PolicyFactory.provider")).findAny().map(param -> this.loadFactory(webBundleDescriptor, param.getValue())).ifPresent(clazz -> this.installPolicyFactory(webBundleDescriptor, (Class<?>)clazz));
        this.exousiaAuthorizationService = new AuthorizationService(this.contextId, () -> SecurityContext.getCurrent().getSubject(), () -> new GlassFishPrincipalMapper(this.contextId));
        this.exousiaAuthorizationService.setConstrainedUriRequestAttribute(CONSTRAINT_URI);
        this.exousiaAuthorizationService.setRequestSupplier(this.contextId, () -> this.currentRequest.get());
        this.exousiaAuthorizationService.addConstraintsToPolicy(GlassFishToExousiaConverter.getConstraintsFromBundle(webBundleDescriptor), webBundleDescriptor.getRoles().stream().map(e -> e.getName()).collect(Collectors.toSet()), webBundleDescriptor.isDenyUncoveredHttpMethods(), GlassFishToExousiaConverter.getSecurityRoleRefsFromBundle(webBundleDescriptor));
    }

    public boolean hasNoConstrainedResources() {
        boolean result = false;
        if (this.allResourcesCachedPermission != null && this.allConnectionsCachedPermission != null) {
            boolean x = this.allResourcesCachedPermission.checkPermission();
            boolean y = this.allConnectionsCachedPermission.checkPermission();
            boolean bl = result = x && y;
            if (result) {
                try {
                    AuthorizationService.setThreadContextId(this.contextId);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
        return result;
    }

    public boolean permitAll(HttpServletRequest httpServletRequest) {
        this.setSecurityInfo(httpServletRequest);
        return this.exousiaAuthorizationService.checkWebResourcePermission(httpServletRequest, (Subject)null);
    }

    public int hasUserDataPermission(HttpServletRequest httpServletRequest, String uri, String httpMethod) {
        this.setSecurityInfo(httpServletRequest);
        boolean isGranted = false;
        isGranted = uri == null ? this.exousiaAuthorizationService.checkWebUserDataPermission(httpServletRequest) : this.exousiaAuthorizationService.checkWebUserDataPermission(uri, httpMethod, httpServletRequest.isSecure());
        int result = 0;
        if (isGranted) {
            result = 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasUserDataPermission isGranted: {0}", isGranted);
        }
        this.recordWebInvocation(httpServletRequest, USERDATA, isGranted);
        if (!isGranted && !httpServletRequest.isSecure()) {
            if (uri == null) {
                uri = GlassFishAuthorizationService.getUriMinusContextPath(httpServletRequest);
                httpMethod = httpServletRequest.getMethod();
            }
            if (isGranted = this.exousiaAuthorizationService.checkWebUserDataPermission(uri, httpMethod, true, defaultPrincipalSet)) {
                result = -1;
            }
        }
        return result;
    }

    public boolean hasResourcePermission(HttpServletRequest httpServletRequest) {
        this.setSecurityInfo(httpServletRequest);
        SecurityContext.setCurrent(this.getSecurityContext(httpServletRequest.getUserPrincipal()));
        boolean isGranted = this.exousiaAuthorizationService.checkWebResourcePermission(httpServletRequest);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasResource isGranted: {0}", isGranted);
            logger.log(Level.FINE, "[Web-Security] hasResource perm: {0}", GlassFishAuthorizationService.getUriMinusContextPath(httpServletRequest));
        }
        this.recordWebInvocation(httpServletRequest, RESOURCE, isGranted);
        return isGranted;
    }

    public boolean hasRoleRefPermission(String servletName, String role, Principal callerPrincipal) {
        boolean isGranted = this.exousiaAuthorizationService.checkWebRoleRefPermission(servletName, role, this.getSecurityContext(callerPrincipal).getSubject());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasRoleRef perm: {0}", servletName + " " + role);
            logger.log(Level.FINE, "[Web-Security] hasRoleRef isGranted: {0}", isGranted);
        }
        return isGranted;
    }

    public boolean linkPolicy(String linkedContextId, boolean lastInService) {
        return this.exousiaAuthorizationService.linkPolicy(linkedContextId, lastInService);
    }

    public static boolean linkPolicy(String contextId, String linkedContextId, boolean lastInService) {
        return AuthorizationService.linkPolicy(contextId, linkedContextId, lastInService);
    }

    public void commitPolicy() {
        this.exousiaAuthorizationService.commitPolicy();
    }

    public static void commitPolicy(String contextId) {
        AuthorizationService.commitPolicy(contextId);
    }

    public void refresh() {
        this.exousiaAuthorizationService.refresh();
    }

    public void deletePolicy() {
        this.exousiaAuthorizationService.deletePolicy();
    }

    public static void deletePolicy(String contextId) {
        AuthorizationService.deletePolicy(contextId);
    }

    public void setSecurityInfo(HttpServletRequest httpRequest) {
        if (httpRequest != null) {
            this.currentRequest.set(httpRequest);
        }
        AuthorizationService.setThreadContextId(this.contextId);
    }

    public void resetSecurityInfo() {
        this.currentRequest.remove();
        PolicyContext.setContextID(null);
    }

    public void release() throws PolicyContextException {
        this.exousiaAuthorizationService.removeStatementsFromPolicy(null);
        PermissionCacheFactory.removePermissionCache(this.uncheckedPermissionCache);
        this.uncheckedPermissionCache = null;
    }

    public void destroy() throws PolicyContextException {
        this.exousiaAuthorizationService.refresh();
        this.exousiaAuthorizationService.destroy();
        PermissionCacheFactory.removePermissionCache(this.uncheckedPermissionCache);
        this.uncheckedPermissionCache = null;
        SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory().removeAppNameForContext(this.contextId);
    }

    private Class<?> loadFactory(WebBundleDescriptor webBundleDescriptor, String factoryClassName) {
        try {
            return webBundleDescriptor.getApplicationClassLoader().loadClass(factoryClassName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPolicyConfigurationFactory(WebBundleDescriptor webBundleDescriptor, Class<?> factoryClass) {
        ClassLoader existing = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(webBundleDescriptor.getApplicationClassLoader());
            AuthorizationService.installPolicyConfigurationFactory(factoryClass);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPolicyFactory(WebBundleDescriptor webBundleDescriptor, Class<?> factoryClass) {
        ClassLoader existing = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(webBundleDescriptor.getApplicationClassLoader());
            AuthorizationService.installPolicyFactory(factoryClass);
        }
        finally {
            Thread.currentThread().setContextClassLoader(existing);
        }
    }

    private void initPermissionCache() {
        if (this.uncheckedPermissionCache == null) {
            if (this.register) {
                this.uncheckedPermissionCache = PermissionCacheFactory.createPermissionCache(this.contextId, protoPerms, null);
                this.allResourcesCachedPermission = new CachedPermissionImpl(this.uncheckedPermissionCache, allResources);
                this.allConnectionsCachedPermission = new CachedPermissionImpl(this.uncheckedPermissionCache, allConnections);
            }
        } else {
            this.uncheckedPermissionCache.reset();
        }
    }

    private SecurityContext getSecurityContext(Principal principal) {
        SecurityContext securityContext = null;
        if (principal != null) {
            if (principal instanceof WebPrincipal) {
                WebPrincipal webPrincipal = (WebPrincipal)principal;
                securityContext = webPrincipal.getSecurityContext();
            } else {
                securityContext = new SecurityContext(principal.getName(), null);
            }
        }
        if (securityContext == null) {
            securityContext = SecurityContext.getDefaultSecurityContext();
        }
        return securityContext;
    }

    private void recordWebInvocation(HttpServletRequest httpServletRequest, String type2, boolean isGranted) {
        AuditManager auditManager = SecurityServicesUtil.getInstance().getAuditManager();
        if (auditManager != null && auditManager.isAuditOn() && auditManager instanceof AppServerAuditManager) {
            AppServerAuditManager appServerAuditManager = (AppServerAuditManager)auditManager;
            Principal callerPrincipal = httpServletRequest.getUserPrincipal();
            String caller = callerPrincipal != null ? callerPrincipal.getName() : null;
            appServerAuditManager.webInvocation(caller, httpServletRequest, type2, isGranted);
        }
    }

    private static String getUriMinusContextPath(HttpServletRequest request) {
        int contextLength;
        String uri = request.getRequestURI();
        if (uri == null) {
            return EMPTY_STRING;
        }
        String contextPath = request.getContextPath();
        int n = contextLength = contextPath == null ? 0 : contextPath.length();
        if (contextLength > 0) {
            uri = uri.substring(contextLength);
        }
        if (uri.equals("/")) {
            return EMPTY_STRING;
        }
        return uri.replaceAll(":", "%3A");
    }
}

