/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.audit;

import com.sun.appserv.security.AuditModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.SecurityRole;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.logging.LogDomains;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.security.common.Role;

public class Audit
extends AuditModule {
    private static Logger logger = LogDomains.getLogger(Audit.class, "jakarta.enterprise.system.core.security");
    private static final String AUDIT_ON = "auditOn";
    private static boolean auditFlag;

    public static boolean isActive() {
        return auditFlag;
    }

    @Override
    public void init(Properties props) {
        super.init(props);
        String audit = props.getProperty(AUDIT_ON);
        auditFlag = audit == null ? false : Boolean.valueOf(audit);
    }

    @Override
    public void authentication(String user, String realm, boolean success) {
        if (auditFlag) {
            StringBuffer sbuf = new StringBuffer("Audit: Authentication for user = (");
            sbuf.append(user);
            sbuf.append(") under realm = (");
            sbuf.append(realm).append(") returned = ").append(success);
            logger.log(Level.INFO, sbuf.toString());
        }
    }

    @Override
    public void webInvocation(String user, HttpServletRequest req, String type2, boolean success) {
        if (auditFlag) {
            StringBuilder sbuf = new StringBuilder("Audit: [Web] Authorization for user = (");
            sbuf.append(user).append(") and permission type = (").append(type2).append(") for request ");
            sbuf.append(req.getMethod()).append(" ").append(req.getRequestURI()).append(" returned =").append(success);
            logger.log(Level.INFO, sbuf.toString());
        }
    }

    @Override
    public void ejbInvocation(String user, String ejb, String method, boolean success) {
        if (auditFlag) {
            StringBuilder sbuf = new StringBuilder("Audit: [EJB] Authorization for user =");
            sbuf.append(user).append(" for ejb = (");
            sbuf.append(ejb).append(") method = (").append(method).append(") returned =").append(success);
            logger.log(Level.INFO, sbuf.toString());
        }
    }

    @Override
    public void webServiceInvocation(String uri, String endpoint, boolean success) {
        if (auditFlag) {
            StringBuilder sbuf = new StringBuilder("Audit: [WebService] ");
            sbuf.append("uri: ").append(uri);
            sbuf.append("endpoint: ").append(endpoint);
            sbuf.append(", valid request =").append(success);
            logger.log(Level.INFO, sbuf.toString());
        }
    }

    @Override
    public void ejbAsWebServiceInvocation(String endpoint, boolean success) {
        if (auditFlag) {
            StringBuilder sbuf = new StringBuilder("Audit: [EjbAsWebService] ");
            sbuf.append("endpoint : ").append(endpoint).append(", valid request =").append(success);
            logger.log(Level.INFO, sbuf.toString());
        }
    }

    @Override
    public void serverStarted() {
        if (auditFlag) {
            logger.log(Level.INFO, "Audit: Application server startup complete");
        }
    }

    @Override
    public void serverShutdown() {
        if (auditFlag) {
            logger.log(Level.INFO, "Audit: Application server shutdown complete");
        }
    }

    public static void showACL(Application app) {
        if (!Audit.isActive() || !logger.isLoggable(Level.FINEST)) {
            return;
        }
        try {
            Audit.dumpDiagnostics(app);
        }
        catch (Throwable e) {
            logger.fine("Error while showing ACL diagnostics: " + e.toString());
        }
    }

    private static void dumpDiagnostics(Application app) {
        logger.finest("====[ Role and ACL Summary ]==========");
        if (!app.isVirtual()) {
            logger.finest("Summary for application: " + app.getRegistrationName());
        } else {
            logger.finest("Standalone module.");
        }
        logger.finest("EJB components: " + Audit.getEjbComponentCount(app));
        logger.finest("Web components: " + Audit.getWebComponentCount(app));
        Set<Role> allRoles = app.getRoles();
        if (allRoles == null) {
            logger.finest("- No roles present.");
            return;
        }
        SecurityRoleMapper roleMapper = app.getRoleMapper();
        if (roleMapper == null) {
            logger.finest("- No role mappings present.");
            return;
        }
        logger.finest("--[ Configured roles and mappings ]--");
        HashMap allRoleMap = new HashMap();
        for (Role role : allRoles) {
            logger.finest(" [" + role.getName() + "]");
            allRoleMap.put(role.getName(), new HashSet());
            StringBuffer sb = new StringBuffer();
            sb.append("  is mapped to groups: ");
            Enumeration<? extends Principal> enumeration = roleMapper.getGroupsAssignedTo(role);
            while (enumeration.hasMoreElements()) {
                sb.append(enumeration.nextElement());
                sb.append(" ");
            }
            logger.finest(sb.toString());
            sb = new StringBuffer();
            sb.append("  is mapped to principals: ");
            Enumeration<? extends Principal> users = roleMapper.getUsersAssignedTo(role);
            while (users.hasMoreElements()) {
                sb.append(users.nextElement());
                sb.append(" ");
            }
            logger.finest(sb.toString());
        }
        Set<EjbBundleDescriptor> ejbDescriptorSet = app.getBundleDescriptors(EjbBundleDescriptor.class);
        for (EjbBundleDescriptor ejbBundleDescriptor : ejbDescriptorSet) {
            logger.finest("--[ EJB module: " + ejbBundleDescriptor.getName() + " ]--");
            Set<? extends EjbDescriptor> ejbs = ejbBundleDescriptor.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbs) {
                logger.finest("EJB: " + ejbDescriptor.getEjbClassName());
                if (!ejbDescriptor.getUsesCallerIdentity().booleanValue()) {
                    RunAsIdentityDescriptor runas = ejbDescriptor.getRunAsIdentity();
                    if (runas == null) {
                        logger.finest(" (ejb does not use caller identity)");
                    } else {
                        String role = runas.getRoleName();
                        String string = runas.getPrincipal();
                        logger.finest(" Will run-as: Role: " + (String)role + "  Principal: " + string);
                        if ((role == null || "".equals(role) || string == null || "".equals(string)) && logger.isLoggable(Level.FINEST)) {
                            logger.finest("*** Configuration error!");
                        }
                    }
                }
                logger.finest(" Method to Role restriction list:");
                Set<MethodDescriptor> methods = ejbDescriptor.getMethodDescriptors();
                for (MethodDescriptor methodDescriptor : methods) {
                    Set ram;
                    logger.finest("   " + methodDescriptor.getFormattedString());
                    Set<MethodPermission> perms = ejbDescriptor.getMethodPermissionsFor(methodDescriptor);
                    StringBuffer rbuf = new StringBuffer();
                    rbuf.append("     can only be invoked by: ");
                    boolean unchecked = false;
                    boolean excluded = false;
                    boolean roleBased = false;
                    for (MethodPermission p : perms) {
                        if (p.isExcluded()) {
                            excluded = true;
                            logger.finest("     excluded - can not be invoked");
                            continue;
                        }
                        if (p.isUnchecked()) {
                            unchecked = true;
                            logger.finest("     unchecked - can be invoked by all");
                            continue;
                        }
                        if (!p.isRoleBased()) continue;
                        roleBased = true;
                        Role r = p.getRole();
                        rbuf.append(r.getName());
                        rbuf.append(" ");
                        ram = (Set)allRoleMap.get(r.getName());
                        ram.add(ejbBundleDescriptor.getName() + ":" + ejbDescriptor.getEjbClassName() + "." + methodDescriptor.getFormattedString());
                    }
                    if (roleBased) {
                        logger.finest(rbuf.toString());
                        if (!excluded && !unchecked) continue;
                        logger.finest("*** Configuration error!");
                        continue;
                    }
                    if (unchecked) {
                        if (excluded) {
                            logger.finest("*** Configuration error!");
                        }
                        Set rks = allRoleMap.keySet();
                        for (String key : rks) {
                            ram = (Set)allRoleMap.get(key);
                            ram.add(ejbBundleDescriptor.getName() + ":" + ejbDescriptor.getEjbClassName() + "." + methodDescriptor.getFormattedString());
                        }
                        continue;
                    }
                    if (excluded) continue;
                    logger.finest("*** Configuration error!");
                }
                logger.finest(" IOR configuration:");
                Set<EjbIORConfigurationDescriptor> iors = ejbDescriptor.getIORConfigurationDescriptors();
                if (iors == null) continue;
                for (EjbIORConfigurationDescriptor ior : iors) {
                    StringBuffer iorsb = new StringBuffer();
                    iorsb.append("realm=");
                    iorsb.append(ior.getRealmName());
                    iorsb.append(", integrity=");
                    iorsb.append(ior.getIntegrity());
                    iorsb.append(", trust-in-target=");
                    iorsb.append(ior.getEstablishTrustInTarget());
                    iorsb.append(", trust-in-client=");
                    iorsb.append(ior.getEstablishTrustInClient());
                    iorsb.append(", propagation=");
                    iorsb.append(ior.getCallerPropagation());
                    iorsb.append(", auth-method=");
                    iorsb.append(ior.getAuthenticationMethod());
                    logger.finest(iorsb.toString());
                }
            }
        }
        logger.finest("--[ EJB methods accessible by role ]--");
        Set set = allRoleMap.keySet();
        for (String roleName : set) {
            logger.finest(" [" + roleName + "]");
            Set ram = (Set)allRoleMap.get(roleName);
            for (String meth : ram) {
                logger.finest("   " + meth);
            }
        }
        Set<WebBundleDescriptor> set2 = app.getBundleDescriptors(WebBundleDescriptor.class);
        for (WebBundleDescriptor wbd : set2) {
            logger.finest("--[ Web module: " + wbd.getContextRoot() + " ]--");
            LoginConfiguration loginConfiguration = wbd.getLoginConfiguration();
            if (loginConfiguration != null) {
                logger.finest("  Login config: realm=" + loginConfiguration.getRealmName() + ", method=" + loginConfiguration.getAuthenticationMethod() + ", form=" + loginConfiguration.getFormLoginPage() + ", error=" + loginConfiguration.getFormErrorPage());
            }
            logger.finest("  Contains components:");
            Set<WebComponentDescriptor> webComps = wbd.getWebComponentDescriptors();
            for (WebComponentDescriptor webComponentDescriptor : webComps) {
                StringBuffer name = new StringBuffer();
                name.append("   - ").append(webComponentDescriptor.getCanonicalName());
                name.append(" [ ");
                Enumeration<String> urlPs = webComponentDescriptor.getUrlPatterns();
                while (urlPs.hasMoreElements()) {
                    name.append((String)urlPs.nextElement());
                    name.append(" ");
                }
                name.append("]");
                logger.finest(name.toString());
                RunAsIdentityDescriptor runas = webComponentDescriptor.getRunAsIdentity();
                if (runas == null) continue;
                String role = runas.getRoleName();
                Iterator<String> user = runas.getPrincipal();
                logger.finest("      Will run-as: Role: " + role + "  Principal: " + user);
                if (role != null && !"".equals(role) && user != null && !"".equals(user)) continue;
                logger.finest("*** Configuration error!");
            }
            logger.finest("  Security constraints:");
            Set<SecurityConstraint> constraints = wbd.getSecurityConstraints();
            for (SecurityConstraint constraint : constraints) {
                for (WebResourceCollection wrc : constraint.getWebResourceCollections()) {
                    StringBuffer sbm = new StringBuffer();
                    for (String httpMethod : wrc.getHttpMethods()) {
                        sbm.append(httpMethod);
                        sbm.append(" ");
                    }
                    logger.finest("     Using method: " + sbm.toString());
                    for (String urlPattern : wrc.getUrlPatterns()) {
                        logger.finest("       " + urlPattern);
                    }
                }
                AuthorizationConstraint authCons = constraint.getAuthorizationConstraint();
                Enumeration<SecurityRole> rolesEnum = authCons.getSecurityRoles();
                StringBuffer rsb = new StringBuffer();
                rsb.append("     Accessible by roles: ");
                while (rolesEnum.hasMoreElements()) {
                    SecurityRole sr = rolesEnum.nextElement();
                    rsb.append(sr.getName());
                    rsb.append(" ");
                }
                logger.finest(rsb.toString());
                UserDataConstraint udc = constraint.getUserDataConstraint();
                if (udc == null) continue;
                logger.finest("     Transport guarantee: " + udc.getTransportGuarantee());
            }
        }
        logger.finest("======================================");
    }

    private static int getWebComponentCount(Application app) {
        int count = 0;
        for (WebBundleDescriptor wbd : app.getBundleDescriptors(WebBundleDescriptor.class)) {
            count += wbd.getWebComponentDescriptors().size();
        }
        return count;
    }

    private static int getEjbComponentCount(Application app) {
        int count = 0;
        for (EjbBundleDescriptor ejbd : app.getBundleDescriptors(EjbBundleDescriptor.class)) {
            count += ejbd.getEjbs().size();
        }
        return count;
    }
}

