/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.AppCNonceCacheMap;
import com.sun.enterprise.security.CNonceCacheFactory;
import com.sun.enterprise.security.EjbSecurityPolicyProbeProvider;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.ee.SecurityContainer;
import com.sun.enterprise.security.ee.authorization.AuthorizationUtil;
import com.sun.enterprise.security.ee.authorization.GlassFishAuthorizationService;
import com.sun.enterprise.security.ee.web.integration.WebSecurityManager;
import com.sun.enterprise.security.ee.web.integration.WebSecurityManagerFactory;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DummyApplication;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.HAUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="Security")
public class SecurityDeployer
extends SimpleDeployer<SecurityContainer, DummyApplication>
implements PostConstruct {
    private static final Logger LOGGER = LogDomains.getLogger(SecurityDeployer.class, "jakarta.enterprise.system.core.security");
    @Inject
    private ServerContext serverContext;
    @Inject
    @Named(value="webSecurityCIH")
    private Provider<RegisteredComponentInvocationHandler> registeredComponentInvocationHandlerProvider;
    @Inject
    private Provider<Events> eventsProvider;
    @Inject
    private Provider<HAUtil> haUtilProvider;
    @Inject
    private Provider<AppCNonceCacheMap> appCNonceCacheMapProvider;
    @Inject
    private Provider<CNonceCacheFactory> cNonceCacheFactoryProvider;
    @Inject
    private WebSecurityManagerFactory webSecurityManagerFactory;
    private AppCNonceCacheMap appCnonceMap;
    private HAUtil haUtil;
    private CNonceCacheFactory cnonceCacheFactory;
    private static final String HA_CNONCE_BS_NAME = "HA-CNonceCache-Backingstore";
    private EventListener listener;
    private static WebSecurityDeployerProbeProvider websecurityProbeProvider = new WebSecurityDeployerProbeProvider();
    private static EjbSecurityPolicyProbeProvider ejbProbeProvider = new EjbSecurityPolicyProbeProvider();

    public static List<EventTypes<?>> getDeploymentEvents() {
        return List.of(Deployment.APPLICATION_PREPARED);
    }

    @Override
    public void postConstruct() {
        this.listener = new AppDeployEventListener();
        this.eventsProvider.get().register(this.listener);
    }

    @Override
    protected void generateArtifacts(DeploymentContext deploymentContext) throws DeploymentException {
        OpsParams params = deploymentContext.getCommandParameters(OpsParams.class);
        if (params.origin.isArtifactsPresent()) {
            return;
        }
        String applicationName = params.name();
        try {
            Application application = deploymentContext.getModuleMetaData(Application.class);
            Set<WebBundleDescriptor> webBundleDescriptors = application.getBundleDescriptors(WebBundleDescriptor.class);
            if (webBundleDescriptors == null) {
                return;
            }
            for (WebBundleDescriptor webBundleDescriptor : webBundleDescriptors) {
                webBundleDescriptor.setApplicationClassLoader(deploymentContext.getFinalClassLoader());
                this.loadWebPolicy(webBundleDescriptor, false);
            }
        }
        catch (Exception se) {
            throw new DeploymentException("Error in generating security policy for " + applicationName, se);
        }
    }

    @Override
    protected void cleanArtifacts(DeploymentContext deploymentContext) throws DeploymentException {
        CNonceCache cache;
        this.deletePolicy(deploymentContext);
        AuthorizationUtil.removeRoleMapper(deploymentContext);
        OpsParams params = deploymentContext.getCommandParameters(OpsParams.class);
        if (this.appCnonceMap != null && (cache = (CNonceCache)this.appCnonceMap.remove(params.name())) != null) {
            cache.destroy();
        }
    }

    @Override
    public DummyApplication load(SecurityContainer container, DeploymentContext context) {
        DeployCommandParameters dparams = context.getCommandParameters(DeployCommandParameters.class);
        Application application = context.getModuleMetaData(Application.class);
        this.handleCNonceCacheBSInit(application.getAppName(), application.getBundleDescriptors(WebBundleDescriptor.class), dparams.availabilityenabled);
        return new DummyApplication();
    }

    @Override
    public void unload(DummyApplication container, DeploymentContext context) {
        this.cleanSecurityContext(context.getCommandParameters(OpsParams.class).name());
    }

    private void loadWebPolicy(WebBundleDescriptor webBundleDescriptor, boolean remove) throws DeploymentException {
        try {
            if (webBundleDescriptor != null) {
                String contextId;
                WebSecurityManager webSecurityManager;
                if (remove && (webSecurityManager = this.webSecurityManagerFactory.getManager(contextId = AuthorizationUtil.getContextID(webBundleDescriptor), true)) != null) {
                    webSecurityManager.release();
                }
                this.webSecurityManagerFactory.createManager(webBundleDescriptor, true, this.serverContext);
            }
        }
        catch (Exception se) {
            throw new DeploymentException("Error in generating security policy for " + webBundleDescriptor.getModuleDescriptor().getModuleName(), se);
        }
    }

    private void commitWebPolicy(WebBundleDescriptor webBundleDescriptor) throws DeploymentException {
        try {
            if (webBundleDescriptor != null) {
                if (webBundleDescriptor.isPolicyModified()) {
                    this.loadWebPolicy(webBundleDescriptor, true);
                }
                String contextId = AuthorizationUtil.getContextID(webBundleDescriptor);
                websecurityProbeProvider.policyCreationStartedEvent(contextId);
                this.commitViaManager(contextId);
                websecurityProbeProvider.policyCreationEndedEvent(contextId);
                websecurityProbeProvider.policyCreationEvent(contextId);
            }
        }
        catch (Exception se) {
            throw new DeploymentException("Error in generating security policy for " + webBundleDescriptor.getModuleDescriptor().getModuleName(), se);
        }
    }

    private void commitEjbPolicies(Application application) throws DeploymentException {
        Set<EjbBundleDescriptor> ejbDescriptors = application.getBundleDescriptors(EjbBundleDescriptor.class);
        try {
            for (EjbBundleDescriptor ejbDescriptor : ejbDescriptors) {
                String contextId = AuthorizationUtil.getContextID(ejbDescriptor);
                ejbProbeProvider.policyCreationStartedEvent(contextId);
                this.commitViaManager(contextId);
                ejbProbeProvider.policyCreationEndedEvent(contextId);
                ejbProbeProvider.policyCreationEvent(contextId);
            }
        }
        catch (Exception se) {
            throw new DeploymentException("Error in committing security policy for ejbs of " + application.getRegistrationName(), se);
        }
    }

    private void linkPolicies(Application application, Collection<WebBundleDescriptor> webBundleDescriptors) throws DeploymentException {
        try {
            String linkedContextId = null;
            boolean lastInService = false;
            for (WebBundleDescriptor webBundleDescriptor : webBundleDescriptors) {
                String contextId = AuthorizationUtil.getContextID(webBundleDescriptor);
                WebSecurityManager manager = this.webSecurityManagerFactory.getManager(contextId);
                if (manager == null) continue;
                lastInService = GlassFishAuthorizationService.linkPolicy(contextId, linkedContextId, lastInService);
                linkedContextId = contextId;
            }
            Set<EjbBundleDescriptor> ejbBundleDescriptors = application.getBundleDescriptors(EjbBundleDescriptor.class);
            for (EjbBundleDescriptor ejbBundleDescriptor : ejbBundleDescriptors) {
                String contextId = AuthorizationUtil.getContextID(ejbBundleDescriptor);
                WebSecurityManager manager = this.webSecurityManagerFactory.getManager(contextId);
                if (manager == null) continue;
                lastInService = GlassFishAuthorizationService.linkPolicy(contextId, linkedContextId, lastInService);
                linkedContextId = contextId;
            }
        }
        catch (IllegalStateException se) {
            throw new DeploymentException("Error in linking security policy for " + application.getRegistrationName(), se);
        }
    }

    private void deletePolicy(DeploymentContext deploymentContext) throws DeploymentException {
        OpsParams params = deploymentContext.getCommandParameters(OpsParams.class);
        if (!params.origin.needsCleanArtifacts()) {
            return;
        }
        String applicationName = params.name();
        try {
            String[] contextIds = this.webSecurityManagerFactory.getContextsForApp(applicationName, false);
            if (contextIds != null) {
                for (String contextId : contextIds) {
                    if (contextId == null) continue;
                    websecurityProbeProvider.policyDestructionStartedEvent(contextId);
                    this.deleteViaManager(contextId);
                    websecurityProbeProvider.policyDestructionEndedEvent(contextId);
                    websecurityProbeProvider.policyDestructionEvent(contextId);
                }
            }
        }
        catch (IllegalStateException ex) {
            String msg = "Error in removing security policy for " + applicationName;
            LOGGER.log(Level.WARNING, msg, ex);
            throw new DeploymentException(msg, ex);
        }
        this.cleanSecurityContext(applicationName);
    }

    boolean linkViaManager(String contextId, String linkedContextId, boolean lastInService) {
        WebSecurityManager securityManager = this.webSecurityManagerFactory.getManager(contextId);
        if (securityManager != null) {
            return securityManager.getAuthorizationService().linkPolicy(linkedContextId, lastInService);
        }
        return GlassFishAuthorizationService.linkPolicy(contextId, linkedContextId, lastInService);
    }

    void commitViaManager(String contextId) {
        WebSecurityManager securityManager = this.webSecurityManagerFactory.getManager(contextId);
        if (securityManager != null) {
            securityManager.getAuthorizationService().commitPolicy();
        } else {
            GlassFishAuthorizationService.commitPolicy(contextId);
        }
    }

    void deleteViaManager(String contextId) {
        WebSecurityManager securityManager = this.webSecurityManagerFactory.getManager(contextId);
        if (securityManager != null) {
            securityManager.getAuthorizationService().deletePolicy();
        } else {
            GlassFishAuthorizationService.deletePolicy(contextId);
        }
    }

    @Override
    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    private boolean cleanSecurityContext(String appName) {
        boolean cleanUpDone = false;
        ArrayList<WebSecurityManager> managers = this.webSecurityManagerFactory.getManagersForApp(appName, false);
        for (int i = 0; managers != null && i < managers.size(); ++i) {
            try {
                websecurityProbeProvider.securityManagerDestructionStartedEvent(appName);
                managers.get(i).destroy();
                websecurityProbeProvider.securityManagerDestructionEndedEvent(appName);
                websecurityProbeProvider.securityManagerDestructionEvent(appName);
                cleanUpDone = true;
                continue;
            }
            catch (Exception pce) {
                LOGGER.log(Level.WARNING, "Unable to destroy WebSecurityManager", pce);
            }
        }
        return cleanUpDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHaEnabled() {
        boolean haEnabled = false;
        SecurityDeployer securityDeployer = this;
        synchronized (securityDeployer) {
            if (this.haUtil == null) {
                this.haUtil = this.haUtilProvider.get();
            }
        }
        if (this.haUtil != null && this.haUtil.isHAEnabled()) {
            haEnabled = true;
            securityDeployer = this;
            synchronized (securityDeployer) {
                if (this.appCnonceMap == null) {
                    this.appCnonceMap = this.appCNonceCacheMapProvider.get();
                }
                if (this.cnonceCacheFactory == null) {
                    this.cnonceCacheFactory = this.cNonceCacheFactoryProvider.get();
                }
            }
        }
        return haEnabled;
    }

    private void handleCNonceCacheBSInit(String appName, Set<WebBundleDescriptor> webDesc, boolean isHA) {
        boolean hasDigest = false;
        for (WebBundleDescriptor webBD : webDesc) {
            LoginConfiguration lc = webBD.getLoginConfiguration();
            if (lc == null || !"DIGEST".equals(lc.getAuthenticationMethod())) continue;
            hasDigest = true;
            break;
        }
        if (!hasDigest) {
            return;
        }
        if (this.isHaEnabled() && isHA) {
            String clusterName = this.haUtil.getClusterName();
            String instanceName = this.haUtil.getInstanceName();
            if (this.cnonceCacheFactory != null) {
                CNonceCache cache = this.cnonceCacheFactory.createCNonceCache(appName, clusterName, instanceName, HA_CNONCE_BS_NAME);
                this.appCnonceMap.put(appName, cache);
            }
        }
    }

    private class AppDeployEventListener
    implements EventListener {
        private AppDeployEventListener() {
        }

        @Override
        public void event(EventListener.Event<?> event) {
            if (Deployment.MODULE_LOADED.equals(event.type())) {
                ModuleInfo moduleInfo = (ModuleInfo)event.hook();
                if (moduleInfo instanceof ApplicationInfo) {
                    return;
                }
                WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)moduleInfo.getMetaData("org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl");
                SecurityDeployer.this.loadWebPolicy(webBundleDescriptor, false);
            } else if (Deployment.APPLICATION_LOADED.equals(event.type())) {
                RegisteredComponentInvocationHandler handler;
                ApplicationInfo applicationInfo = (ApplicationInfo)event.hook();
                Application application = applicationInfo.getMetaData(Application.class);
                if (application == null) {
                    return;
                }
                Set<WebBundleDescriptor> webBundleDescriptors = application.getBundleDescriptors(WebBundleDescriptor.class);
                SecurityDeployer.this.linkPolicies(application, webBundleDescriptors);
                SecurityDeployer.this.commitEjbPolicies(application);
                if (!Utility.isEmpty(webBundleDescriptors) && (handler = SecurityDeployer.this.registeredComponentInvocationHandlerProvider.get()) != null) {
                    handler.register();
                }
            } else if (WebBundleDescriptor.AFTER_SERVLET_CONTEXT_INITIALIZED_EVENT.equals(event.type())) {
                SecurityDeployer.this.commitWebPolicy((WebBundleDescriptor)event.hook());
            }
        }
    }
}

