/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.common;

import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.embedded.Server;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class Util {
    private static ServiceLocator habitat = Globals.getDefaultHabitat();
    @Inject
    private ProcessEnvironment penv;
    private CallbackHandler callbackHandler;
    private Object appClientMsgSecConfigs;

    public static ServiceLocator getDefaultHabitat() {
        return habitat;
    }

    public static Util getInstance() {
        return habitat.getService(Util.class, new Annotation[0]);
    }

    public boolean isACC() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public boolean isServer() {
        return this.penv.getProcessType().isServer();
    }

    public boolean isNotServerOrACC() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public <T> T getAppClientMsgSecConfigs() {
        return (T)this.appClientMsgSecConfigs;
    }

    public void setAppClientMsgSecConfigs(Object appClientMsgSecConfigs) {
        this.appClientMsgSecConfigs = appClientMsgSecConfigs;
    }

    public static boolean isEmbeddedServer() {
        List<String> servers = Server.getServerNames();
        return !servers.isEmpty();
    }

    public static File writeConfigFileToTempDir(String fileName) throws IOException {
        File filePath = new File(fileName);
        if (filePath.exists()) {
            return filePath;
        }
        File localFile = null;
        if (filePath.getParentFile() != null && filePath.getParentFile().exists()) {
            localFile = filePath;
            if (!localFile.createNewFile()) {
                throw new IOException();
            }
        } else {
            String embeddedServerName = Util.getCurrentEmbeddedServerName();
            File tempDir = FileUtils.USER_HOME.toPath().resolve(Path.of(".glassfish8-" + embeddedServerName, "config")).toFile();
            boolean mkDirSuccess = true;
            if (!tempDir.exists()) {
                mkDirSuccess = tempDir.mkdirs();
                tempDir.deleteOnExit();
            }
            localFile = new File(tempDir, fileName);
            if (mkDirSuccess && !localFile.exists()) {
                localFile.createNewFile();
                localFile.deleteOnExit();
            }
        }
        try (FileOutputStream oStream = new FileOutputStream(localFile);
             InputStream iStream = Util.class.getResourceAsStream("/config/" + fileName);){
            while (iStream != null && iStream.available() > 0) {
                oStream.write(iStream.read());
            }
        }
        return localFile;
    }

    public static String getCurrentEmbeddedServerName() {
        List<String> embeddedServerNames = Server.getServerNames();
        return embeddedServerNames.get(0) == null ? "embedded" : embeddedServerNames.get(0);
    }
}

