/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.common;

import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.common.AbstractSecurityContext;
import com.sun.enterprise.security.integration.AppServSecurityContext;
import java.security.Principal;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.security.common.UserNameAndPassword;

public final class ClientSecurityContext
extends AbstractSecurityContext {
    private static final Logger _logger = SecurityLoggerInfo.getLogger();
    public static final String IIOP_CLIENT_PER_THREAD_FLAG = "com.sun.appserv.iiopclient.perthreadauth";
    private static final boolean isPerThreadAuth = Boolean.getBoolean("com.sun.appserv.iiopclient.perthreadauth");
    private static ThreadLocal localCsc = isPerThreadAuth ? new ThreadLocal() : null;
    private static volatile ClientSecurityContext sharedCsc;

    public ClientSecurityContext(String userName, Subject s) {
        this.initiator = new UserNameAndPassword(userName);
        this.subject = s;
    }

    public static ClientSecurityContext getCurrent() {
        if (isPerThreadAuth) {
            return (ClientSecurityContext)localCsc.get();
        }
        return sharedCsc;
    }

    public static void setCurrent(ClientSecurityContext sc) {
        if (isPerThreadAuth) {
            localCsc.set(sc);
        } else {
            sharedCsc = sc;
        }
    }

    @Override
    public Principal getCallerPrincipal() {
        return this.initiator;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "ClientSecurityContext[ Initiator: " + String.valueOf(this.initiator) + "Subject " + String.valueOf(this.subject) + " ]";
    }

    public static boolean hasEmtpyCredentials(ClientSecurityContext clientSecurityContext) {
        if (clientSecurityContext == null) {
            return true;
        }
        Subject subject = clientSecurityContext.getSubject();
        if (subject == null) {
            return true;
        }
        return subject.getPrincipals().isEmpty();
    }

    @Override
    public AppServSecurityContext newInstance(String userName, Subject subject, String realm) {
        return new ClientSecurityContext(userName, subject);
    }

    @Override
    public AppServSecurityContext newInstance(String userName, Subject subject) {
        return new ClientSecurityContext(userName, subject);
    }

    @Override
    public void setCurrentSecurityContext(AppServSecurityContext context) {
        if (context instanceof ClientSecurityContext) {
            ClientSecurityContext.setCurrent((ClientSecurityContext)context);
            return;
        }
        throw new IllegalArgumentException("Expected ClientSecurityContext, found " + String.valueOf(context));
    }

    @Override
    public AppServSecurityContext getCurrentSecurityContext() {
        return ClientSecurityContext.getCurrent();
    }

    @Override
    public void setUnauthenticatedSecurityContext() {
        throw new UnsupportedOperationException("Not supported yet in V3.");
    }

    @Override
    public void setSecurityContextWithPrincipal(Principal principal) {
        throw new UnsupportedOperationException("Not supported yet in V3.");
    }
}

