/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.RequestPolicy;
import com.sun.enterprise.config.serverbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-message-security-provider")
@PerLookup
@I18n(value="create.message.security.provider")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateMessageSecurityProvider
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateMessageSecurityProvider.class);
    private static final String SERVER = "server";
    private static final String CLIENT = "client";
    private static final String CLIENT_SERVER = "client-server";
    @Param(name="layer", acceptableValues="SOAP,HttpServlet", defaultValue="SOAP")
    String authLayer;
    @Param(name="providertype", acceptableValues="client,server,client-server", optional=true, defaultValue="client-server")
    String providerType;
    @Param(name="requestauthsource", optional=true)
    String requestAuthSource;
    @Param(name="requestauthrecipient", optional=true)
    String requestAuthRecipient;
    @Param(name="responseauthsource", optional=true)
    String responseAuthSource;
    @Param(name="responseauthrecipient", optional=true)
    String responseAuthRecipient;
    @Param(name="isdefaultprovider", optional=true, defaultValue="false")
    Boolean isDefaultProvider;
    @Param(optional=true, name="property", separator=58)
    Properties properties;
    @Param(name="classname")
    String providerClass;
    @Param(name="providername", primary=true)
    String providerId;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @AccessRequired.NewChild(type=MessageSecurityConfig.class)
    private SecurityService securityService;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List<MessageSecurityConfig> messageSecurityConfigs = this.securityService.getMessageSecurityConfig();
        MessageSecurityConfig messageSecurityConfig = null;
        for (MessageSecurityConfig candidateMessageSecurityConfig : messageSecurityConfigs) {
            if (!candidateMessageSecurityConfig.getAuthLayer().equals(this.authLayer)) continue;
            messageSecurityConfig = candidateMessageSecurityConfig;
        }
        if (messageSecurityConfig != null) {
            for (ProviderConfig providerConfig : messageSecurityConfig.getProviderConfig()) {
                if (!providerConfig.getProviderId().equals(this.providerId)) continue;
                report.setMessage(localStrings.getLocalString("create.message.security.provider.duplicatefound", "Message security provider named {0} exists. Cannot add duplicate.", this.providerId));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                ConfigSupport.apply(new SingleConfigCode<MessageSecurityConfig>(){

                    @Override
                    public Object run(MessageSecurityConfig param) throws PropertyVetoException, TransactionFailure {
                        ProviderConfig newProviderConfig = param.createChild(ProviderConfig.class);
                        CreateMessageSecurityProvider.this.populateProviderConfigElement(newProviderConfig);
                        param.getProviderConfig().add(newProviderConfig);
                        if (CreateMessageSecurityProvider.this.isDefaultProvider.booleanValue()) {
                            if (CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.SERVER) || CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT_SERVER)) {
                                param.setDefaultProvider(CreateMessageSecurityProvider.this.providerId);
                            }
                            if (CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT) || CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT_SERVER)) {
                                param.setDefaultClientProvider(CreateMessageSecurityProvider.this.providerId);
                            }
                        }
                        return newProviderConfig;
                    }
                }, messageSecurityConfig);
            }
            catch (TransactionFailure e) {
                report.setMessage(localStrings.getLocalString("create.message.security.provider.fail", "Creation of message security provider named {0} failed", this.providerId));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
                return;
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(localStrings.getLocalString("create.message.security.provider.success", "Creation of message security provider named {0} completed successfully", this.providerId));
        } else {
            try {
                ConfigSupport.apply(new SingleConfigCode<SecurityService>(){

                    @Override
                    public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                        MessageSecurityConfig newMessageSecurityConfig = param.createChild(MessageSecurityConfig.class);
                        newMessageSecurityConfig.setAuthLayer(CreateMessageSecurityProvider.this.authLayer);
                        param.getMessageSecurityConfig().add(newMessageSecurityConfig);
                        ProviderConfig newProviderConfig = newMessageSecurityConfig.createChild(ProviderConfig.class);
                        CreateMessageSecurityProvider.this.populateProviderConfigElement(newProviderConfig);
                        newMessageSecurityConfig.getProviderConfig().add(newProviderConfig);
                        if (CreateMessageSecurityProvider.this.isDefaultProvider.booleanValue()) {
                            if (CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.SERVER) || CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT_SERVER)) {
                                newMessageSecurityConfig.setDefaultProvider(CreateMessageSecurityProvider.this.providerId);
                            }
                            if (CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT) || CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT_SERVER)) {
                                newMessageSecurityConfig.setDefaultClientProvider(CreateMessageSecurityProvider.this.providerId);
                            }
                        }
                        return newMessageSecurityConfig;
                    }
                }, this.securityService);
            }
            catch (TransactionFailure e) {
                report.setMessage(localStrings.getLocalString("create.message.security.provider.fail", "Creation of message security provider named {0} failed", this.providerId));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
                return;
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void populateProviderConfigElement(ProviderConfig newProviderConfig) throws PropertyVetoException, TransactionFailure {
        newProviderConfig.setClassName(this.providerClass);
        newProviderConfig.setProviderId(this.providerId);
        newProviderConfig.setProviderType(this.providerType);
        RequestPolicy newRequestPolicy = newProviderConfig.createChild(RequestPolicy.class);
        newRequestPolicy.setAuthSource(this.requestAuthSource);
        newRequestPolicy.setAuthRecipient(this.requestAuthRecipient);
        newProviderConfig.setRequestPolicy(newRequestPolicy);
        ResponsePolicy newResponsePolicy = newProviderConfig.createChild(ResponsePolicy.class);
        newResponsePolicy.setAuthSource(this.responseAuthSource);
        newResponsePolicy.setAuthRecipient(this.responseAuthRecipient);
        newProviderConfig.setResponsePolicy(newResponsePolicy);
        if (this.properties != null) {
            for (Object propname : this.properties.keySet()) {
                Property newProperty = newProviderConfig.createChild(Property.class);
                newProperty.setName((String)propname);
                newProperty.setValue(this.properties.getProperty((String)propname));
                newProviderConfig.getProperty().add(newProperty);
            }
        }
    }
}

