/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.file;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.exceptions.BadRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.util.IASSecurityException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.internal.api.RelativePathResolver;
import org.glassfish.security.common.FileRealmHelper;
import org.jvnet.hk2.annotations.Service;

@Service
public final class FileRealm
extends Realm {
    public static final String AUTH_TYPE = "filepassword";
    public static final String PARAM_KEYFILE = "file";
    FileRealmHelper fileRealmHelper;

    public FileRealm(String keyfile) throws BadRealmException, NoSuchRealmException {
        Properties properties = new Properties();
        properties.setProperty(PARAM_KEYFILE, keyfile);
        properties.setProperty("jaas-context", "ignore");
        this.init(properties);
    }

    public FileRealm() {
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    public static List<String> getRealmFileNames(Config config) {
        ArrayList<String> realmFileNames = new ArrayList<String>();
        for (AuthRealm authRealm : config.getSecurityService().getAuthRealm()) {
            String file;
            String fileRealmClassName = authRealm.getClassname();
            if (fileRealmClassName == null || !fileRealmClassName.equals(FileRealm.class.getName()) || (file = authRealm.getPropertyValue(PARAM_KEYFILE)) == null) continue;
            if (file.contains("$")) {
                file = RelativePathResolver.resolvePath(file);
            }
            realmFileNames.add(file);
        }
        return realmFileNames;
    }

    @Override
    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String file = props.getProperty(PARAM_KEYFILE);
        if (file == null) {
            throw new BadRealmException("Incomplete configuration in file realm: file not specified.");
        }
        if (file.contains("$")) {
            file = RelativePathResolver.resolvePath(file);
        }
        this.setProperty(PARAM_KEYFILE, file);
        String jaasCtx = props.getProperty("jaas-context");
        if (jaasCtx == null) {
            throw new BadRealmException("Incomplete configuration in file realm: login module not specified.");
        }
        this.setProperty("jaas-context", jaasCtx);
        _logger.log(Level.FINE, "FileRealm : file={0}", file);
        _logger.log(Level.FINE, "FileRealm : jaas-context={0}", jaasCtx);
        try {
            if (Util.isEmbeddedServer()) {
                file = Util.writeConfigFileToTempDir(file).getAbsolutePath();
            }
            this.fileRealmHelper = new FileRealmHelper(file);
        }
        catch (IOException ioe) {
            throw new BadRealmException(MessageFormat.format("Unable to create keyfile: {0}", ioe.toString()));
        }
    }

    @Override
    public Enumeration<String> getUserNames() throws BadRealmException {
        return Collections.enumeration(this.fileRealmHelper.getUserNames());
    }

    @Override
    public User getUser(String name) throws NoSuchUserException {
        FileRealmHelper.User user = this.fileRealmHelper.getUser(name);
        if (user == null) {
            throw new NoSuchUserException(MessageFormat.format("No such user [{0}]", name));
        }
        return new FileRealmUser(user, null);
    }

    @Override
    public Enumeration<String> getGroupNames() throws BadRealmException {
        return Collections.enumeration(this.fileRealmHelper.getGroupNames());
    }

    @Override
    public Enumeration<String> getGroupNames(String username) throws NoSuchUserException {
        String[] groups = this.fileRealmHelper.getGroupNames(username);
        if (groups == null) {
            groups = new String[]{};
        }
        return Collections.enumeration(Arrays.asList(this.addAssignGroups(groups)));
    }

    @Override
    public void refresh() throws BadRealmException {
        _logger.fine("Reloading file realm data.");
        try {
            FileRealm newRealm = new FileRealm(this.getProperty(PARAM_KEYFILE));
            newRealm.init(this.getProperties());
            Realm.updateInstance(newRealm, this.getName());
        }
        catch (Exception e) {
            throw new BadRealmException(e.toString());
        }
    }

    @Override
    public void refresh(String configName) throws BadRealmException {
        _logger.fine("Reloading file realm data.");
        try {
            FileRealm newRealm = new FileRealm(this.getProperty(PARAM_KEYFILE));
            newRealm.init(this.getProperties());
            Realm.updateInstance(configName, newRealm, this.getName());
        }
        catch (Exception e) {
            throw new BadRealmException(e.toString());
        }
    }

    @Override
    public void addUser(String name, char[] password, String[] groupList) throws BadRealmException, IASSecurityException {
        this.fileRealmHelper.addUser(name, password, groupList);
    }

    @Override
    public void removeUser(String name) throws NoSuchUserException, BadRealmException {
        this.fileRealmHelper.removeUser(name);
    }

    @Override
    public void updateUser(String name, String newName, char[] password, String[] groups) throws NoSuchUserException, BadRealmException, IASSecurityException {
        this.fileRealmHelper.updateUser(name, newName, password, groups);
    }

    public String[] authenticate(String user, char[] password) {
        String[] groups = this.fileRealmHelper.authenticate(user, password);
        if (groups != null) {
            groups = this.addAssignGroups(groups);
        }
        return groups;
    }

    public boolean hasAuthenticatableUser() {
        return this.fileRealmHelper.hasAuthenticatableUser();
    }

    @Override
    public boolean supportsUserManagement() {
        return true;
    }

    @Override
    public void persist() throws BadRealmException {
        try {
            this.fileRealmHelper.persist();
        }
        catch (IOException ex) {
            throw new BadRealmException(ex);
        }
    }
}

