/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.rm;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.rm.ResourceManager;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemResourceManagerImpl
implements ResourceManager {
    private static final Logger LOG = LogDomains.getLogger(SystemResourceManagerImpl.class, "jakarta.enterprise.resource.resourceadapter");

    @Override
    public Transaction getTransaction() throws PoolingException {
        try {
            return ConnectorRuntime.getRuntime().getTransaction();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "poolmgr.unexpected_exception", ex);
            throw new PoolingException(ex.toString(), ex);
        }
    }

    @Override
    public Object getComponent() {
        return null;
    }

    @Override
    public void enlistResource(ResourceHandle handle) throws PoolingException {
        try {
            JavaEETransactionManager transactionManager = SystemResourceManagerImpl.getTransactionManager();
            Transaction transaction = transactionManager.getTransaction();
            if (transaction != null) {
                transactionManager.enlistResource(transaction, handle);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "poolmgr.unexpected_exception", ex);
            throw new PoolingException(ex.toString(), ex);
        }
    }

    @Override
    public void registerResource(ResourceHandle handle) throws PoolingException {
    }

    @Override
    public void rollBackTransaction() {
        try {
            Transaction transaction = SystemResourceManagerImpl.getCurrentTransaction();
            if (transaction != null) {
                transaction.setRollbackOnly();
            }
        }
        catch (SystemException ex) {
            LOG.log(Level.WARNING, "poolmgr.system_exception", ex);
        }
        catch (IllegalStateException ex) {
            LOG.log(Level.FINEST, "Ignoring IllegalStateException.", ex);
        }
    }

    @Override
    public void delistResource(ResourceHandle h, int xaresFlag) {
        try {
            JavaEETransactionManager transactionManager = SystemResourceManagerImpl.getTransactionManager();
            Transaction transaction = transactionManager.getTransaction();
            if (transaction != null) {
                transactionManager.delistResource(transaction, h, xaresFlag);
            }
        }
        catch (SystemException ex) {
            LOG.log(Level.WARNING, "poolmgr.system_exception", ex);
        }
        catch (IllegalStateException ex) {
            LOG.log(Level.FINEST, "Ignoring IllegalStateException.", ex);
        }
    }

    @Override
    public void unregisterResource(ResourceHandle resource, int xaresFlag) {
    }

    private static JavaEETransactionManager getTransactionManager() {
        return ConnectorRuntime.getRuntime().getTransactionManager();
    }

    private static Transaction getCurrentTransaction() throws SystemException {
        return SystemResourceManagerImpl.getTransactionManager().getTransaction();
    }
}

