/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.recovery;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.deployer.ConnectorResourceDeployer;
import com.sun.enterprise.transaction.spi.RecoveryResourceHandler;
import com.sun.enterprise.v3.server.ApplicationLoaderService;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.security.PasswordCredential;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.security.common.UserNameAndPassword;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
public class ConnectorsRecoveryResourceHandler
implements RecoveryResourceHandler {
    @Inject
    private Domain domain;
    @Inject
    private Applications applications;
    @Inject
    private ConnectorsClassLoaderUtil cclUtil;
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;
    @Inject
    private Provider<ConnectorResourceDeployer> connectorResourceDeployerProvider;
    @Inject
    @Named(value="ApplicationLoaderService")
    private Provider<ApplicationLoaderService> startupProvider;
    @Inject
    private ConfigBeansUtilities configBeansUtilities;
    private ResourcesUtil resourcesUtil;
    private static final Logger LOG = LogDomains.getLogger(ConnectorsRecoveryResourceHandler.class, "jakarta.enterprise.resource.resourceadapter");
    private static final Locale locale = Locale.getDefault();

    private Collection<ConnectorResource> getAllConnectorResources() {
        ArrayList<ConnectorResource> allResources = new ArrayList<ConnectorResource>();
        Collection<ConnectorResource> connectorResources = this.domain.getResources().getResources(ConnectorResource.class);
        allResources.addAll(connectorResources);
        for (Application app : this.applications.getApplications()) {
            List<Module> modules;
            if (!ResourcesUtil.createInstance().isEnabled(app)) continue;
            Resources appScopedResources = app.getResources();
            if (appScopedResources != null && appScopedResources.getResources() != null) {
                allResources.addAll(appScopedResources.getResources(ConnectorResource.class));
            }
            if ((modules = app.getModule()) == null) continue;
            for (Module module : modules) {
                Resources msr = module.getResources();
                if (msr == null || msr.getResources() == null) continue;
                allResources.addAll(msr.getResources(ConnectorResource.class));
            }
        }
        return allResources;
    }

    private void loadAllConnectorResources() {
        block8: {
            try {
                Collection<ConnectorResource> connResources = this.getAllConnectorResources();
                InitialContext ic = new InitialContext();
                for (ConnectorResource connResource : connResources) {
                    if (!this.getResourcesUtil().isEnabled(connResource)) continue;
                    try {
                        ic.lookup(connResource.getJndiName());
                    }
                    catch (NamingException ne) {
                        try {
                            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(connResource);
                            ConnectorConnectionPool connConnectionPool = this.getResourcesUtil().getConnectorConnectionPoolOfResource(resourceInfo);
                            if (connConnectionPool == null) continue;
                            this.createActiveResourceAdapter(connConnectionPool.getResourceAdapterName());
                            this.getConnectorResourceDeployer().deployResource(connResource);
                        }
                        catch (Exception ex) {
                            LOG.log(Level.SEVERE, "error.loading.connector.resources.during.recovery", connResource.getJndiName());
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.log(Level.FINE, ne.toString(), ne);
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "error.loading.connector.resources.during.recovery", connResource.getJndiName());
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.log(Level.FINE, ex.toString(), ex);
                    }
                }
            }
            catch (NamingException ne) {
                LOG.log(Level.SEVERE, "error.loading.connector.resources.during.recovery", ne.getMessage());
                if (!LOG.isLoggable(Level.FINE)) break block8;
                LOG.log(Level.FINE, ne.toString(), ne);
            }
        }
    }

    private ResourcesUtil getResourcesUtil() {
        if (this.resourcesUtil == null) {
            this.resourcesUtil = ResourcesUtil.createInstance();
        }
        return this.resourcesUtil;
    }

    private ConnectorResourceDeployer getConnectorResourceDeployer() {
        return this.connectorResourceDeployerProvider.get();
    }

    @Override
    public void loadXAResourcesAndItsConnections(List xaresList, List connList) {
        ConnectorRuntime crt = this.connectorRuntimeProvider.get();
        this.startupProvider.get();
        Collection<ConnectorResource> connectorResources = this.getAllConnectorResources();
        if (connectorResources.isEmpty()) {
            return;
        }
        ArrayList<ConnectorConnectionPool> connPools = new ArrayList<ConnectorConnectionPool>();
        for (Resource resource : connectorResources) {
            ConnectorResource connResource = (ConnectorResource)resource;
            if (!this.getResourcesUtil().isEnabled(connResource)) continue;
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(connResource);
            ConnectorConnectionPool pool = ResourcesUtil.createInstance().getConnectorConnectionPoolOfResource(resourceInfo);
            if (pool == null || !"XATransaction".equals(this.getTransactionSupport(pool))) continue;
            connPools.add(pool);
            LOG.log(Level.FINE, "ConnectorsRecoveryResourceHandler loadXAResourcesAndItsConnections :: adding : {0}", connResource.getPoolName());
        }
        this.loadAllConnectorResources();
        LOG.log(Level.FINE, "Recovering pools : {0}", connPools.size());
        for (ConnectorConnectionPool connectorConnectionPool : connPools) {
            PoolInfo poolInfo = ResourceUtil.getPoolInfo(connectorConnectionPool);
            try {
                String dbUser;
                String dbPassword;
                String[] dbUserPassword = this.getdbUserPasswordOfConnectorConnectionPool(connectorConnectionPool);
                Subject subject = new Subject();
                if (dbUserPassword[1] == null) {
                    dbPassword = "";
                    LOG.log(Level.FINEST, "datasource.xadatasource_nullpassword_error", poolInfo);
                } else {
                    dbPassword = dbUserPassword[1];
                }
                if (dbUserPassword[0] == null) {
                    dbUser = "";
                    LOG.log(Level.FINEST, "datasource.xadatasource_nulluser_error", poolInfo);
                } else {
                    dbUser = dbUserPassword[0];
                }
                UserNameAndPassword principal = new UserNameAndPassword(dbUser, dbPassword);
                if (ConnectorAdminServiceUtils.isJMSRA(connectorConnectionPool.getResourceAdapterName())) {
                    LOG.log(Level.FINE, "Performing recovery for JMS RA, poolName {0}", poolInfo);
                    ManagedConnectionFactory[] mcfs = crt.obtainManagedConnectionFactories(poolInfo);
                    LOG.log(Level.INFO, "JMS resource recovery has created CFs = {0}", mcfs.length);
                    for (ManagedConnectionFactory mcf : mcfs) {
                        PasswordCredential pc = new PasswordCredential(principal.getName(), principal.getPassword());
                        pc.setManagedConnectionFactory(mcf);
                        subject.getPrincipals().add(principal);
                        subject.getPrivateCredentials().add(pc);
                        ManagedConnection mc = mcf.createManagedConnection(subject, null);
                        connList.add(mc);
                        try {
                            XAResource xares = mc.getXAResource();
                            if (xares == null) continue;
                            xaresList.add(xares);
                        }
                        catch (ResourceException resourceException) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                ManagedConnectionFactory mcf = crt.obtainManagedConnectionFactory(poolInfo);
                PasswordCredential pc = new PasswordCredential(dbUser, dbPassword.toCharArray());
                pc.setManagedConnectionFactory(mcf);
                subject.getPrincipals().add(principal);
                subject.getPrivateCredentials().add(pc);
                ManagedConnection mc = mcf.createManagedConnection(subject, null);
                connList.add(mc);
                try {
                    XAResource xares = mc.getXAResource();
                    if (xares == null) continue;
                    xaresList.add(xares);
                }
                catch (ResourceException resourceException) {
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "datasource.xadatasource_error", poolInfo);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "datasource.xadatasource_error_excp", ex);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Total XAResources identified for recovery is " + xaresList.size());
            LOG.log(Level.FINE, "Total connections identified for recovery is " + connList.size());
        }
    }

    private String getTransactionSupport(ConnectorConnectionPool pool) {
        String txSupport = pool.getTransactionSupport();
        if (txSupport != null) {
            return txSupport;
        }
        try {
            txSupport = ConnectorRuntime.getRuntime().getConnectorDescriptor(pool.getResourceAdapterName()).getOutboundResourceAdapter().getTransSupport();
        }
        catch (ConnectorRuntimeException cre) {
            Object[] params = new Object[]{pool.getResourceAdapterName(), cre};
            LOG.log(Level.WARNING, "error.retrieving.tx-support.from.rar", params);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("setting no-tx-support as tx-support-level for pool : " + pool.getName());
            }
            txSupport = "NoTransaction";
        }
        return txSupport;
    }

    @Override
    public void closeConnections(List connList) {
        for (Object obj : connList) {
            try {
                ((ManagedConnection)obj).destroy();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Connector Resource could not be closed", ex);
            }
        }
    }

    private String[] getdbUserPasswordOfConnectorConnectionPool(ConnectorConnectionPool connectorConnectionPool) {
        String[] userPassword = new String[]{null, null};
        List<Property> properties = connectorConnectionPool.getProperty();
        if (properties != null) {
            boolean foundUserPassword = false;
            for (Property elementProperty : properties) {
                String prop = elementProperty.getName().toUpperCase(locale);
                if ("USERNAME".equals(prop) || "USER".equals(prop)) {
                    userPassword[0] = elementProperty.getValue();
                    foundUserPassword = true;
                    continue;
                }
                if (!"PASSWORD".equals(prop)) continue;
                userPassword[1] = elementProperty.getValue();
                foundUserPassword = true;
            }
            if (foundUserPassword) {
                return userPassword;
            }
        }
        PoolInfo poolInfo = ResourceUtil.getPoolInfo(connectorConnectionPool);
        String rarName = connectorConnectionPool.getResourceAdapterName();
        String connectionDefName = connectorConnectionPool.getConnectionDefinitionName();
        ConnectorRegistry connectorRegistry = ConnectorRegistry.getInstance();
        ConnectorDescriptor connectorDescriptor = connectorRegistry.getDescriptor(rarName);
        ConnectionDefDescriptor cdd = connectorDescriptor.getConnectionDefinitionByCFType(connectionDefName);
        Set<ConnectorConfigProperty> configProps = cdd.getConfigProperties();
        for (ConnectorConfigProperty envProp : configProps) {
            String prop = envProp.getName().toUpperCase(locale);
            if ("USER".equals(prop) || "USERNAME".equals(prop)) {
                userPassword[0] = envProp.getValue();
                continue;
            }
            if (!"PASSWORD".equals(prop)) continue;
            userPassword[1] = envProp.getValue();
        }
        if (userPassword[0] != null && !userPassword[0].isBlank()) {
            return userPassword;
        }
        ManagedConnectionFactory mcf = connectorRegistry.getManagedConnectionFactory(poolInfo);
        userPassword[0] = ConnectionPoolObjectsUtils.getValueFromMCF("User", poolInfo, mcf);
        userPassword[1] = ConnectionPoolObjectsUtils.getValueFromMCF("Password", poolInfo, mcf);
        return userPassword;
    }

    private void createActiveResourceAdapter(String rarModuleName) throws ConnectorRuntimeException {
        ConnectorRuntime cr = ConnectorRuntime.getRuntime();
        ConnectorRegistry creg = ConnectorRegistry.getInstance();
        if (creg.isRegistered(rarModuleName)) {
            return;
        }
        if (ConnectorAdminServiceUtils.isEmbeddedConnectorModule(rarModuleName)) {
            cr.createActiveResourceAdapterForEmbeddedRar(rarModuleName);
        } else {
            String moduleDir = ConnectorsUtil.belongsToSystemRA(rarModuleName) ? ConnectorsUtil.getSystemModuleLocation(rarModuleName) : this.configBeansUtilities.getLocation(rarModuleName);
            ClassLoader loader = cr.createConnectorClassLoader(moduleDir, null, rarModuleName);
            cr.createActiveResourceAdapter(moduleDir, rarModuleName, loader);
        }
    }
}

