/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.listener.PoolLifeCycleListener;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolAppEmitterImpl;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolAppProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolAppProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolAppStatsProvider;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class ConnectionPoolEmitterImpl
implements PoolLifeCycleListener {
    private final PoolInfo poolInfo;
    private final ConnectionPoolProbeProvider poolProbeProvider;
    private final Map<PoolInfo, Map<String, ConnectionPoolAppEmitterImpl>> appStatsMap;
    private final Map<Long, String> resourceAppAssociationMap;
    private static Logger _logger = LogDomains.getLogger(ConnectionPoolEmitterImpl.class, "jakarta.enterprise.resource.resourceadapter");
    private final List<ConnectorConnPoolAppStatsProvider> ccPoolAppStatsProviders;
    private final ConnectorRuntime runtime;
    private static volatile InitialContext ic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConnectionPoolEmitterImpl(PoolInfo poolInfo, ConnectionPoolProbeProvider provider) {
        this.poolInfo = poolInfo;
        this.poolProbeProvider = provider;
        this.ccPoolAppStatsProviders = new ArrayList<ConnectorConnPoolAppStatsProvider>();
        this.appStatsMap = new HashMap<PoolInfo, Map<String, ConnectionPoolAppEmitterImpl>>();
        this.resourceAppAssociationMap = new ConcurrentHashMap<Long, String>();
        this.runtime = ConnectorRuntime.getRuntime();
        if (ic != null) return;
        Class<ConnectionPoolEmitterImpl> clazz = ConnectionPoolEmitterImpl.class;
        synchronized (ConnectionPoolEmitterImpl.class) {
            if (ic != null) return;
            try {
                ic = new InitialContext();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public void toString(StringBuffer stackTrace) {
        stackTrace.append("\n Monitoring Statistics for \n" + String.valueOf(this.poolInfo));
        this.poolProbeProvider.toString(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName(), stackTrace);
    }

    @Override
    public void connectionAcquired(long resourceHandleId) {
        ConnectionPoolAppEmitterImpl appEmitter = this.detectAppBasedProviders(this.getAppName(resourceHandleId));
        this.poolProbeProvider.connectionAcquiredEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
        if (appEmitter != null) {
            appEmitter.connectionAcquired();
        }
    }

    @Override
    public void connectionRequestServed(long timeTakenInMillis) {
        this.poolProbeProvider.connectionRequestServedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName(), timeTakenInMillis);
    }

    @Override
    public void connectionTimedOut() {
        this.poolProbeProvider.connectionTimedOutEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
    }

    @Override
    public void connectionNotMatched() {
        this.poolProbeProvider.connectionNotMatchedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
    }

    @Override
    public void connectionMatched() {
        this.poolProbeProvider.connectionMatchedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
    }

    @Override
    public void connectionDestroyed(long resourceHandleId) {
        this.poolProbeProvider.connectionDestroyedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
        this.resourceAppAssociationMap.remove(resourceHandleId);
    }

    @Override
    public void connectionReleased(long resourceHandleId) {
        ConnectionPoolAppEmitterImpl appEmitter = this.detectAppBasedProviders(this.getAppName(resourceHandleId));
        this.poolProbeProvider.connectionReleasedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
        if (appEmitter != null) {
            appEmitter.connectionReleased();
        }
        this.resourceAppAssociationMap.remove(resourceHandleId);
    }

    @Override
    public void connectionCreated() {
        this.poolProbeProvider.connectionCreatedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
    }

    @Override
    public void foundPotentialConnectionLeak() {
        this.poolProbeProvider.potentialConnLeakEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
    }

    @Override
    public void connectionValidationFailed(int count) {
        this.poolProbeProvider.connectionValidationFailedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName(), count);
    }

    @Override
    public void connectionUsed(long resourceHandleId) {
        ConnectionPoolAppEmitterImpl appEmitter = this.detectAppBasedProviders(this.getAppName(resourceHandleId));
        this.poolProbeProvider.connectionUsedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
        if (appEmitter != null) {
            appEmitter.connectionUsed();
        }
    }

    @Override
    public void connectionsFreed(int count) {
        this.poolProbeProvider.connectionsFreedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName(), count);
    }

    @Override
    public void decrementConnectionUsed(long resourceHandleId) {
        ConnectionPoolAppEmitterImpl appEmitter = this.detectAppBasedProviders(this.getAppName(resourceHandleId));
        this.poolProbeProvider.decrementConnectionUsedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
        if (appEmitter != null) {
            appEmitter.decrementConnectionUsed();
        }
    }

    @Override
    public void decrementNumConnFree() {
        this.poolProbeProvider.decrementNumConnFreeEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
    }

    @Override
    public void incrementNumConnFree(boolean beingDestroyed, int steadyPoolSize) {
        this.poolProbeProvider.incrementNumConnFreeEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName(), beingDestroyed, steadyPoolSize);
    }

    @Override
    public void connectionRequestQueued() {
        this.poolProbeProvider.connectionRequestQueuedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
    }

    @Override
    public void connectionRequestDequeued() {
        this.poolProbeProvider.connectionRequestDequeuedEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String getAppName(long resourceHandleId) {
        if (!this.runtime.isJdbcPoolMonitoringEnabled() && !this.runtime.isConnectorPoolMonitoringEnabled()) {
            return null;
        }
        String appName = this.resourceAppAssociationMap.get(resourceHandleId);
        if (appName != null) return appName;
        try {
            if (ic == null) {
                Class<ConnectionPoolEmitterImpl> clazz = ConnectionPoolEmitterImpl.class;
                // MONITORENTER : com.sun.enterprise.resource.pool.monitor.ConnectionPoolEmitterImpl.class
                if (ic == null) {
                    ic = new InitialContext();
                }
                // MONITOREXIT : clazz
            }
            appName = (String)ic.lookup("java:app/AppName");
            this.resourceAppAssociationMap.put(resourceHandleId, appName);
            return appName;
        }
        catch (NamingException ex) {
            if (!_logger.isLoggable(Level.FINE)) return appName;
            _logger.log(Level.FINE, "Unable to get application name using java:app/AppName method");
        }
        return appName;
    }

    private ConnectionPoolAppEmitterImpl detectAppBasedProviders(String appName) {
        ConnectionPoolAppProbeProvider probeAppProvider = null;
        ConnectionPoolAppEmitterImpl connPoolAppEmitter = null;
        if (appName == null) {
            return null;
        }
        if (this.appStatsMap.containsKey(this.poolInfo)) {
            Map<String, ConnectionPoolAppEmitterImpl> appEmitters = this.appStatsMap.get(this.poolInfo);
            ConnectionPoolAppEmitterImpl emitter = appEmitters.get(appName);
            if (emitter != null) {
                return emitter;
            }
            if (!ConnectorsUtil.isApplicationScopedResource(this.poolInfo)) {
                probeAppProvider = this.registerConnectionPool(appName);
                connPoolAppEmitter = this.addToList(appName, probeAppProvider, appEmitters);
            }
        } else if (!ConnectorsUtil.isApplicationScopedResource(this.poolInfo)) {
            probeAppProvider = this.registerConnectionPool(appName);
            HashMap<String, ConnectionPoolAppEmitterImpl> appEmitters = new HashMap<String, ConnectionPoolAppEmitterImpl>();
            connPoolAppEmitter = this.addToList(appName, probeAppProvider, appEmitters);
        }
        return connPoolAppEmitter;
    }

    private ConnectionPoolAppProbeProvider registerConnectionPool(String appName) {
        ResourcePool pool = this.runtime.getConnectionPoolConfig(this.poolInfo);
        ConnectionPoolAppProbeProvider probeAppProvider = this.runtime.getProbeProviderUtil().getConnPoolBootstrap().registerPool(this.poolInfo, appName);
        if (pool instanceof ConnectorConnectionPool) {
            probeAppProvider = new ConnectorConnPoolAppProbeProvider();
            ConnectorConnPoolAppStatsProvider ccPoolAppStatsProvider = new ConnectorConnPoolAppStatsProvider(this.poolInfo, appName);
            StatsProviderManager.register("connector-connection-pool", PluginPoint.SERVER, "resources/" + ConnectorsUtil.escapeResourceNameForMonitoring(this.poolInfo.getName()) + "/" + appName, ccPoolAppStatsProvider);
            this.ccPoolAppStatsProviders.add(ccPoolAppStatsProvider);
        }
        return probeAppProvider;
    }

    private ConnectionPoolAppEmitterImpl addToList(String appName, ConnectionPoolAppProbeProvider probeAppProvider, Map<String, ConnectionPoolAppEmitterImpl> appEmitters) {
        ConnectionPoolAppEmitterImpl connPoolAppEmitter;
        if (probeAppProvider == null) {
            connPoolAppEmitter = null;
        } else {
            connPoolAppEmitter = new ConnectionPoolAppEmitterImpl(this.poolInfo.getName(), appName, probeAppProvider);
            appEmitters.put(appName, connPoolAppEmitter);
            this.appStatsMap.put(this.poolInfo, appEmitters);
        }
        this.runtime.getProbeProviderUtil().getConnPoolBootstrap().addToPoolEmitters(this.poolInfo, this);
        return connPoolAppEmitter;
    }

    public void unregisterAppStatsProviders() {
        this.runtime.getProbeProviderUtil().getConnPoolBootstrap().unRegisterPool();
        for (ConnectorConnPoolAppStatsProvider ccPoolAppStatsProvider : this.ccPoolAppStatsProviders) {
            StatsProviderManager.unregister(ccPoolAppStatsProvider);
        }
        this.ccPoolAppStatsProviders.clear();
    }
}

