/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.listener;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.listener.ConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.logging.LogDomains;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ManagedConnection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalTxConnectionEventListener
extends ConnectionEventListener {
    private static final Logger logger = LogDomains.getLogger(ResourceHandle.class, "jakarta.enterprise.resource.resourceadapter");
    private final PoolManager poolManager = ConnectorRuntime.getRuntime().getPoolManager();
    private final IdentityHashMap<Object, ResourceHandle> associatedHandles = new IdentityHashMap(10);
    private final ResourceHandle resource;

    public LocalTxConnectionEventListener(ResourceHandle resource) {
        this.resource = resource;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LocalTxConnectionEventListener constructor, resource=" + String.valueOf(resource) + ", this=" + String.valueOf(this));
        }
    }

    @Override
    public synchronized void connectionClosed(ConnectionEvent evt) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LocalTxConnectionEventListener.connectionClosed START, resource=" + String.valueOf(this.resource) + ", this=" + String.valueOf(this));
            for (Object key : this.associatedHandles.keySet()) {
                ResourceHandle associatedHandle = this.associatedHandles.get(key);
                logger.log(Level.FINE, "LocalTxConnectionEventListener.connectionClosed associatedHandles: key=" + String.valueOf(key) + ", handle=" + String.valueOf(associatedHandle));
                logger.log(Level.FINE, "LocalTxConnectionEventListener.connectionClosed associatedHandles: resource=" + String.valueOf(associatedHandle.getResource()));
            }
        }
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.associatedHandles.getOrDefault(connectionHandle, this.resource);
        this.poolManager.resourceClosed(handle);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LocalTxConnectionEventListener.connectionClosed END, resource=" + String.valueOf(this.resource) + ", handle=" + String.valueOf(handle) + ", this=" + String.valueOf(this));
        }
    }

    @Override
    public synchronized void connectionErrorOccurred(ConnectionEvent evt) {
        this.resource.setConnectionErrorOccurred();
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener(this);
        this.poolManager.resourceErrorOccurred(this.resource);
    }

    @Override
    public synchronized void badConnectionClosed(ConnectionEvent evt) {
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.associatedHandles.getOrDefault(connectionHandle, this.resource);
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener(this);
        this.poolManager.badResourceClosed(handle);
    }

    @Override
    public void localTransactionStarted(ConnectionEvent evt) {
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent evt) {
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent evt) {
    }

    public synchronized void associateHandle(Object userHandle, ResourceHandle resourceHandle) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LocalTxConnectionEventListener associateHandle, userHandle=" + String.valueOf(userHandle) + ", resourceHandle=" + String.valueOf(resourceHandle) + ", this=" + String.valueOf(this));
        }
        this.associatedHandles.put(userHandle, resourceHandle);
    }

    public synchronized ResourceHandle removeAssociation(Object userHandle) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LocalTxConnectionEventListener removeAssociation, userHandle=" + String.valueOf(userHandle) + ", this=" + String.valueOf(this));
        }
        return this.associatedHandles.remove(userHandle);
    }

    public synchronized Map<Object, ResourceHandle> getAssociatedHandlesAndClearMap() {
        logger.log(Level.FINE, "LocalTxConnectionEventListener getAssociatedHandlesAndClearMap, this=" + String.valueOf(this));
        IdentityHashMap result = (IdentityHashMap)this.associatedHandles.clone();
        this.associatedHandles.clear();
        return result;
    }
}

