/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.resource.deployer.AbstractConnectorResourceDeployer;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@ResourceDeployerInfo(value=ConnectorResource.class)
public class ConnectorResourceDeployer
extends AbstractConnectorResourceDeployer<ConnectorResource> {
    private static Logger _logger = LogDomains.getLogger(ConnectorResourceDeployer.class, "jakarta.enterprise.resource.resourceadapter");
    @Inject
    private ConnectorRuntime runtime;

    @Override
    public synchronized void deployResource(ConnectorResource resource, String applicationName, String moduleName) throws Exception {
        ResourceInfo resourceInfo = new ResourceInfo(new SimpleJndiName(resource.getJndiName()), applicationName, moduleName);
        PoolInfo poolInfo = new PoolInfo(new SimpleJndiName(resource.getPoolName()), applicationName, moduleName);
        this.createConnectorResource(resource, resourceInfo, poolInfo);
    }

    @Override
    public void deployResource(ConnectorResource resource) throws Exception {
        SimpleJndiName poolName = new SimpleJndiName(resource.getPoolName());
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(resource);
        PoolInfo poolInfo = new PoolInfo(poolName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        this.createConnectorResource(resource, resourceInfo, poolInfo);
    }

    private void createConnectorResource(ConnectorResource connectorResource, ResourceInfo resourceInfo, PoolInfo poolInfo) throws ConnectorRuntimeException {
        _logger.log(Level.FINE, "Calling backend to add connector resource: {0}", resourceInfo);
        this.runtime.createConnectorResource(resourceInfo, poolInfo, null);
        SimpleJndiName jndiName = resourceInfo.getName();
        if (ConnectorsUtil.getValidSuffix(jndiName) == null) {
            ResourceInfo pmResourceInfo = new ResourceInfo(ConnectorsUtil.getPMJndiName(jndiName), resourceInfo.getApplicationName(), resourceInfo.getModuleName());
            this.runtime.createConnectorResource(pmResourceInfo, poolInfo, null);
        }
        _logger.log(Level.FINE, "Added connector resource in backend: {0}", resourceInfo);
    }

    @Override
    public void undeployResource(ConnectorResource resource, String applicationName, String moduleName) throws Exception {
        ResourceInfo resourceInfo = new ResourceInfo(new SimpleJndiName(resource.getJndiName()), applicationName, moduleName);
        this.deleteConnectorResource(resource, resourceInfo);
    }

    @Override
    public synchronized void undeployResource(ConnectorResource resource) throws Exception {
        this.deleteConnectorResource(resource, ConnectorsUtil.getResourceInfo(resource));
    }

    private void deleteConnectorResource(ConnectorResource connectorResource, ResourceInfo resourceInfo) throws Exception {
        this.runtime.deleteConnectorResource(resourceInfo);
        if (ConnectorsUtil.getValidSuffix(resourceInfo.getName()) == null) {
            SimpleJndiName pmJndiName = ConnectorsUtil.getPMJndiName(resourceInfo.getName());
            ResourceInfo pmResourceInfo = new ResourceInfo(pmJndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
            this.runtime.deleteConnectorResource(pmResourceInfo);
        }
        this.checkAndDeletePool(connectorResource);
    }

    @Override
    public synchronized void disableResource(ConnectorResource resource) throws Exception {
        this.undeployResource(resource);
    }

    @Override
    public synchronized void enableResource(ConnectorResource resource) throws Exception {
        this.deployResource(resource);
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof ConnectorResource;
    }

    private void checkAndDeletePool(ConnectorResource connectorResource) throws Exception {
        SimpleJndiName poolName = new SimpleJndiName(connectorResource.getPoolName());
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(connectorResource);
        PoolInfo poolInfo = new PoolInfo(poolName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        Resources resources = (Resources)connectorResource.getParent();
        if (resources != null) {
            try {
                boolean poolReferred = ResourcesUtil.createInstance().isPoolReferredInServerInstance(poolInfo);
                if (!poolReferred) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("Deleting connector connection pool [" + String.valueOf(poolName) + "] as there are no more resource-refs to the pool in this server instance");
                    }
                    ConnectorConnectionPool pool = resources.getResourceByName(ConnectorConnectionPool.class, poolName);
                    this.runtime.getResourceDeployer(pool).undeployResource(pool);
                }
            }
            catch (Exception ce) {
                _logger.warning(ce.getMessage());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Exception while deleting pool [ " + String.valueOf(poolName) + " ] : " + String.valueOf(ce));
                }
                throw ce;
            }
        }
    }
}

