/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=AdministeredObjectDefinitionDescriptor.class)
public class AdministeredObjectDefinitionDeployer
implements ResourceDeployer<AdministeredObjectDefinitionDescriptor> {
    private static final Logger LOG = LogDomains.getLogger(AdministeredObjectDefinitionDeployer.class, "jakarta.enterprise.resource.resourceadapter");
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;

    @Override
    public void deployResource(AdministeredObjectDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void deployResource(AdministeredObjectDefinitionDescriptor resource) throws Exception {
        SimpleJndiName jndiName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), resource.getJndiName(), resource.getResourceType());
        MyAdministeredObjectResource adminObjectResource = new MyAdministeredObjectResource(resource, jndiName);
        this.getDeployer(adminObjectResource).deployResource(adminObjectResource);
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }

    private AdministeredObjectProperty convertProperty(String name, String value) {
        return new AdministeredObjectProperty(name, value);
    }

    @Override
    public void undeployResource(AdministeredObjectDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void undeployResource(AdministeredObjectDefinitionDescriptor resource) throws Exception {
        SimpleJndiName jndiName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), resource.getJndiName(), resource.getResourceType());
        LOG.log(Level.FINE, "AdministeredObjectDefinitionDeployer.undeployResource() : resource-name [{0}]", jndiName);
        MyAdministeredObjectResource adminObjectResource = new MyAdministeredObjectResource(resource, jndiName);
        this.getDeployer(adminObjectResource).undeployResource(adminObjectResource);
    }

    @Override
    public void enableResource(AdministeredObjectDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for administered-object-definition type");
    }

    @Override
    public void disableResource(AdministeredObjectDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for administered-object-definition type");
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof AdministeredObjectDefinitionDescriptor;
    }

    class MyAdministeredObjectResource
    extends FakeConfigBean
    implements AdminObjectResource {
        private final AdministeredObjectDefinitionDescriptor desc;
        private final SimpleJndiName name;

        public MyAdministeredObjectResource(AdministeredObjectDefinitionDescriptor desc, SimpleJndiName name) {
            this.desc = desc;
            this.name = name;
        }

        @Override
        public String getObjectType() {
            return "user";
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.name.toString();
        }

        @Override
        public String getResAdapter() {
            return this.desc.getResourceAdapter();
        }

        @Override
        public void setResAdapter(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return this.desc.getDescription();
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public String getJndiName() {
            return this.name.toString();
        }

        @Override
        public void setJndiName(String value) throws PropertyVetoException {
        }

        @Override
        public String getResType() {
            return this.desc.getInterfaceName();
        }

        @Override
        public void setResType(String value) throws PropertyVetoException {
        }

        @Override
        public String getClassName() {
            return this.desc.getClassName();
        }

        @Override
        public void setClassName(String value) throws PropertyVetoException {
        }

        @Override
        public String getEnabled() {
            return "true";
        }

        @Override
        public void setEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            Properties p = this.desc.getProperties();
            ArrayList<Property> administeredObjectProperties = new ArrayList<Property>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith("org.glassfish.admin-object.")) continue;
                String value = (String)entry.getValue();
                AdministeredObjectProperty dp = AdministeredObjectDefinitionDeployer.this.convertProperty(key, value);
                administeredObjectProperties.add(dp);
            }
            return administeredObjectProperties;
        }

        @Override
        public Property getProperty(String name) {
            String value = this.desc.getProperty(name);
            return new AdministeredObjectProperty(name, value);
        }

        @Override
        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            String value = this.desc.getProperty(name);
            return value == null ? defaultValue : value;
        }

        public void injectedInto(Object o) {
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }

        @Override
        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String toString() {
            return super.toString() + "[identity=" + this.getIdentity() + "]";
        }
    }

    class AdministeredObjectProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        AdministeredObjectProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        @Override
        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigBeanProxy getParent() {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

