/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.allocator;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.AbstractConnectorAllocator;
import com.sun.enterprise.resource.listener.ConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ConnectorAllocator
extends AbstractConnectorAllocator {
    private final boolean shareable;

    public ConnectorAllocator(PoolManager poolMgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo reqInfo, ClientSecurityInfo info, ConnectorDescriptor desc, boolean shareable) {
        super(poolMgr, mcf, spec, subject, reqInfo, info, desc);
        this.shareable = shareable;
    }

    @Override
    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection mc = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resource = this.createResourceHandle(mc, this.spec, this);
            ConnectionListenerImpl l = new ConnectionListenerImpl(resource);
            mc.addConnectionEventListener(l);
            return resource;
        }
        catch (ResourceException ex) {
            throw new PoolingException(ex);
        }
    }

    @Override
    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = resource.getResource();
            Object con = mc.getConnection(this.subject, this.reqInfo);
            resource.incrementCount();
            XAResource xares = mc.getXAResource();
            resource.fillInResourceObjects(con, xares);
        }
        catch (ResourceException ex) {
            throw new PoolingException(ex);
        }
    }

    @Override
    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            this.closeUserConnection(resource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ManagedConnection mc = resource.getResource();
            mc.destroy();
        }
        catch (Exception ex) {
            throw new PoolingException(ex);
        }
    }

    @Override
    public boolean shareableWithinComponent() {
        return this.shareable;
    }

    class ConnectionListenerImpl
    extends ConnectionEventListener {
        private final ResourceHandle resource;

        ConnectionListenerImpl(ResourceHandle resource) {
            this.resource = resource;
        }

        @Override
        public void connectionClosed(ConnectionEvent evt) {
            if (this.resource.hasConnectionErrorOccurred()) {
                return;
            }
            this.resource.decrementCount();
            if (this.resource.getShareCount() == 0) {
                ConnectorAllocator.this.poolMgr.resourceClosed(this.resource);
            }
        }

        @Override
        public void badConnectionClosed(ConnectionEvent evt) {
            if (this.resource.hasConnectionErrorOccurred()) {
                return;
            }
            this.resource.decrementCount();
            if (this.resource.getShareCount() == 0) {
                ManagedConnection mc = (ManagedConnection)evt.getSource();
                mc.removeConnectionEventListener(this);
                ConnectorAllocator.this.poolMgr.badResourceClosed(this.resource);
            }
        }

        @Override
        public void connectionAbortOccurred(ConnectionEvent evt) {
            this.resource.setConnectionErrorOccurred();
            ManagedConnection mc = (ManagedConnection)evt.getSource();
            mc.removeConnectionEventListener(this);
            ConnectorAllocator.this.poolMgr.resourceAbortOccurred(this.resource);
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent evt) {
            this.resource.setConnectionErrorOccurred();
            ManagedConnection mc = (ManagedConnection)evt.getSource();
            mc.removeConnectionEventListener(this);
            ConnectorAllocator.this.poolMgr.resourceErrorOccurred(this.resource);
        }

        @Override
        public void localTransactionStarted(ConnectionEvent evt) {
        }

        @Override
        public void localTransactionCommitted(ConnectionEvent evt) {
        }

        @Override
        public void localTransactionRolledback(ConnectionEvent evt) {
        }
    }
}

