/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.connectors.PoolMetaData;
import java.io.Serializable;
import java.util.Objects;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class ResourceSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int JDBC_URL = 0;
    public static final int JNDI_NAME = 1;
    public static final int JMS = 2;
    private final SimpleJndiName resourceId;
    private final int resourceIdType;
    private boolean pmResource;
    private boolean nonTxResource;
    private boolean isXA_;
    private boolean lazyEnlistable_;
    private boolean lazyAssociatable_;
    private Object connectionToAssoc_;
    private PoolInfo poolInfo;

    public ResourceSpec(SimpleJndiName resourceId, int resourceIdType) {
        Objects.requireNonNull(resourceId, "resourceId");
        this.resourceId = resourceId;
        this.resourceIdType = resourceIdType;
        if (resourceId.hasSuffix("__nontx")) {
            this.nonTxResource = true;
        }
        if (resourceId.hasSuffix("__pm")) {
            this.pmResource = true;
        }
    }

    public ResourceSpec(SimpleJndiName resourceId, int resourceIdType, PoolMetaData poolMetaData) {
        Objects.requireNonNull(resourceId, "resourceId");
        this.resourceId = resourceId;
        this.resourceIdType = resourceIdType;
        if (poolMetaData.isNonTx() || resourceId.hasSuffix("__nontx")) {
            this.nonTxResource = true;
        }
        if (poolMetaData.isPM() || resourceId.hasSuffix("__pm")) {
            this.pmResource = true;
        }
        if (poolMetaData.isLazyEnlistable() && !this.nonTxResource && !this.pmResource) {
            this.lazyEnlistable_ = true;
        }
        if (poolMetaData.isLazyAssociatable() && !this.nonTxResource && !this.pmResource) {
            this.lazyAssociatable_ = true;
            this.lazyEnlistable_ = false;
        }
    }

    public PoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    public void setPoolInfo(PoolInfo poolInfo) {
        this.poolInfo = poolInfo;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ResourceSpec) {
            ResourceSpec obj = (ResourceSpec)other;
            if (this.poolInfo == null) {
                return this.resourceId.equals(obj.resourceId) && this.resourceIdType == obj.resourceIdType;
            }
            return this.poolInfo.equals(obj.poolInfo);
        }
        return false;
    }

    public int hashCode() {
        if (this.poolInfo == null) {
            return this.resourceId.hashCode() + this.resourceIdType;
        }
        return this.poolInfo.hashCode();
    }

    public String getResourceId() {
        return this.resourceId.toString();
    }

    public boolean isPM() {
        return this.pmResource;
    }

    public boolean isNonTx() {
        return this.nonTxResource;
    }

    public boolean isXA() {
        return this.isXA_;
    }

    public void markAsXA() {
        this.isXA_ = true;
    }

    public boolean isLazyEnlistable() {
        return this.lazyEnlistable_;
    }

    public void setLazyEnlistable(boolean lazyEnlist) {
        this.lazyEnlistable_ = lazyEnlist;
    }

    public boolean isLazyAssociatable() {
        return this.lazyAssociatable_;
    }

    public void setLazyAssociatable(boolean lazyAssoc) {
        this.lazyAssociatable_ = lazyAssoc;
    }

    public void setConnectionToAssociate(Object conn) {
        this.connectionToAssoc_ = conn;
    }

    public Object getConnectionToAssociate() {
        return this.connectionToAssoc_;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<ResourceSpec ");
        sb.append("connectionPoolName : ").append(this.poolInfo);
        sb.append(", isXA_ : ").append(this.isXA_);
        sb.append(", resoureId : ").append(this.resourceId);
        sb.append(", resoureIdType : ").append(this.resourceIdType);
        sb.append(", pmResource : ").append(this.pmResource);
        sb.append(", nonTxResource : ").append(this.nonTxResource);
        sb.append(", lazyEnlistable : ").append(this.lazyEnlistable_);
        sb.append(", lazyAssociatable : ").append(this.lazyAssociatable_);
        sb.append("/>");
        return sb.toString();
    }
}

