/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.cfg.OsgiPlatform;
import com.sun.enterprise.glassfish.bootstrap.log.LogFacade;
import com.sun.enterprise.glassfish.bootstrap.osgi.BundleProvisioner;
import com.sun.enterprise.glassfish.bootstrap.osgi.MinimalBundleProvisioner;
import com.sun.enterprise.glassfish.bootstrap.osgi.OSGiFrameworkLauncher;
import com.sun.enterprise.glassfish.bootstrap.osgi.OSGiGlassFishRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.spi.RuntimeBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;

public final class OSGiGlassFishRuntimeBuilder
implements RuntimeBuilder {
    private static final Logger LOG = LogFacade.BOOTSTRAP_LOGGER;
    private Properties oldProvisioningOptions;
    private Properties newProvisioningOptions;
    private OSGiFrameworkLauncher fwLauncher;
    private Framework framework;

    @Override
    public GlassFishRuntime build(BootstrapProperties bsProps, ClassLoader classloader) throws GlassFishException {
        try {
            Properties properties = bsProps.getProperties();
            properties.setProperty("GlassFish.BUILDER_NAME", this.getClass().getName());
            long t0 = System.currentTimeMillis();
            this.fwLauncher = new OSGiFrameworkLauncher(properties, classloader);
            this.framework = this.fwLauncher.launchOSGiFrameWork();
            long t1 = System.currentTimeMillis();
            LOG.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "build", "Launched {0}", this.framework);
            if (this.newFramework()) {
                this.storeProvisioningOptions(properties);
            } else {
                this.reconfigure(properties, classloader);
            }
            BundleProvisioner bundleProvisioner = OSGiGlassFishRuntimeBuilder.createBundleProvisioner(this.framework.getBundleContext(), properties);
            LOG.log(Level.CONFIG, "NCLS-BOOTSTRAP-00026", bundleProvisioner);
            List<Long> bundleIds = bundleProvisioner.installBundles();
            if (bundleProvisioner.hasAnyThingChanged()) {
                bundleProvisioner.refresh();
                this.deleteHK2Cache(properties);
                this.storeBundleIds(bundleIds.toArray(new Long[bundleIds.size()]));
            }
            if (bundleProvisioner.isSystemBundleUpdationRequired()) {
                LOG.log(Level.INFO, "NCLS-BOOTSTRAP-00034");
                this.framework.update();
                this.framework.waitForStop(0L);
                this.framework.init();
                bundleProvisioner.setBundleContext(this.framework.getBundleContext());
            }
            bundleProvisioner.startBundles();
            long t2 = System.currentTimeMillis();
            this.framework.start();
            long t3 = System.currentTimeMillis();
            this.printStats(bundleProvisioner, t0, t1, t2, t3);
            return this.getGlassFishRuntime();
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    @Override
    public boolean handles(BootstrapProperties bsProps) {
        String builderName = bsProps.getProperty("GlassFish.BUILDER_NAME");
        if (builderName != null && !builderName.equals(this.getClass().getName())) {
            return false;
        }
        String platformStr = bsProps.getProperty("GlassFish_Platform");
        if (platformStr != null && !platformStr.isBlank()) {
            try {
                OsgiPlatform osgiPlatform = OsgiPlatform.valueOf(platformStr);
                switch (osgiPlatform) {
                    case Felix: 
                    case Equinox: 
                    case Knopflerfish: {
                        return true;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    private GlassFishRuntime getGlassFishRuntime() throws GlassFishException {
        ServiceReference reference = this.framework.getBundleContext().getServiceReference(GlassFishRuntime.class);
        if (reference != null) {
            GlassFishRuntime embeddedGfr = (GlassFishRuntime)this.framework.getBundleContext().getService(reference);
            return new OSGiGlassFishRuntime(embeddedGfr, this.framework);
        }
        throw new GlassFishException("No GlassFishRuntime available");
    }

    private void deleteHK2Cache(Properties properties) throws GlassFishException {
        File inhabitantsCache;
        String cacheDir = properties.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheDir != null && (inhabitantsCache = new File(cacheDir, "inhabitants")).exists()) {
            LOG.logp(Level.CONFIG, "OSGiGlassFishRuntimeBuilder", "deleteHK2Cache", "Deleting OSGI inhabitants cache {0} ...", inhabitantsCache);
            if (!inhabitantsCache.delete()) {
                throw new GlassFishException("Cannot delete cache: " + inhabitantsCache.getAbsolutePath());
            }
        }
    }

    private void printStats(BundleProvisioner bundleProvisioner, long t0, long t1, long t2, long t3) {
        LOG.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "build", "installed = {0}, updated = {1}, uninstalled = {2}", new Object[]{bundleProvisioner.getNoOfInstalledBundles(), bundleProvisioner.getNoOfUpdatedBundles(), bundleProvisioner.getNoOfUninstalledBundles()});
        LOG.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "build", "Total time taken (in ms) to initialize framework = {0}, to install/update/delete/start bundles = {1}, to start framework= {2}", new Object[]{t1 - t0, t2 - t1, t3 - t2});
    }

    private boolean newFramework() {
        BundleContext context = this.framework.getBundleContext();
        return context == null || context.getBundles().length == 1;
    }

    private void reconfigure(Properties properties, ClassLoader classloader) throws Exception {
        if (this.hasBeenReconfigured(properties)) {
            LOG.log(Level.INFO, "NCLS-BOOTSTRAP-00035");
            this.framework.stop();
            this.framework.waitForStop(0L);
            properties.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
            this.fwLauncher = new OSGiFrameworkLauncher(properties, classloader);
            this.framework = this.fwLauncher.launchOSGiFrameWork();
            LOG.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "reconfigure", "Launched {0}", this.framework);
            this.storeProvisioningOptions(properties);
        }
    }

    private boolean hasBeenReconfigured(Properties properties) {
        LOG.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "hasBeenReconfigured", "oldProvisioningOptions = {0}", this.getOldProvisioningOptions());
        Properties newOptions = this.getNewProvisioningOptions(properties);
        LOG.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "hasBeenReconfigured", "newProvisioningOptions = {0}", newOptions);
        return !newOptions.equals(this.getOldProvisioningOptions());
    }

    private Properties getNewProvisioningOptions(Properties properties) {
        if (this.newProvisioningOptions == null) {
            Properties props = new Properties();
            for (String key : properties.stringPropertyNames()) {
                if (!key.startsWith("glassfish.osgi")) continue;
                props.setProperty(key, properties.getProperty(key));
            }
            this.newProvisioningOptions = props;
        }
        return this.newProvisioningOptions;
    }

    private void storeBundleIds(Long[] bundleIds) {
        File f = this.framework.getBundleContext().getDataFile("glassfish.bundleids");
        if (f == null) {
            LOG.log(Level.WARNING, "NCLS-BOOTSTRAP-00037");
            return;
        }
        try (ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(f));){
            os.writeObject(bundleIds);
            LOG.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "storeBundleIds", "Stored bundle ids in {0}", f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void storeProvisioningOptions(Properties properties) {
        BundleContext context = this.framework.getBundleContext();
        if (context == null) {
            throw new IllegalStateException("No bundle context available!");
        }
        File f = context.getDataFile("provisioning.properties");
        if (f == null) {
            LOG.log(Level.WARNING, "NCLS-BOOTSTRAP-00038");
            return;
        }
        try (FileOutputStream os = new FileOutputStream(f);){
            this.getNewProvisioningOptions(properties).store(os, "");
            os.flush();
            LOG.logp(Level.CONFIG, "OSGiGlassFishRuntimeBuilder", "storeProvisioningOptions", "Stored provisioning options in {0}", f);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Storing provisioning options failed.", e);
        }
    }

    private Properties getOldProvisioningOptions() {
        if (this.oldProvisioningOptions == null) {
            Properties options = new Properties();
            try {
                File f = this.framework.getBundleContext().getDataFile("provisioning.properties");
                if (f != null && f.exists()) {
                    options.load(new FileInputStream(f));
                    LOG.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "getOldProvisioningOptions", "Read provisioning options from {0}", f);
                    this.oldProvisioningOptions = options;
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Loading provisioning options failed.", e);
            }
        }
        return this.oldProvisioningOptions;
    }

    private static BundleProvisioner createBundleProvisioner(BundleContext bctx, Properties props) {
        boolean ondemandProvisioning = Boolean.parseBoolean(props.getProperty("glassfish.osgi.ondemand"));
        if (ondemandProvisioning) {
            return new MinimalBundleProvisioner(bctx, props);
        }
        return new BundleProvisioner(bctx, props);
    }
}

