/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.log.LogFacade;
import com.sun.enterprise.glassfish.bootstrap.osgi.BundleProvisioner;
import com.sun.enterprise.glassfish.bootstrap.osgi.Jar;
import com.sun.enterprise.glassfish.bootstrap.osgi.MinimalBundleProvisionerCustomizer;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

class MinimalBundleProvisioner
extends BundleProvisioner {
    private final Logger logger = LogFacade.BOOTSTRAP_LOGGER;
    private List<Long> installedBundleIds;

    MinimalBundleProvisioner(BundleContext bundleContext, Properties config) {
        super(bundleContext, new MinimalBundleProvisionerCustomizer(config));
    }

    @Override
    public List<Long> installBundles() {
        List<Long> bundleIds;
        BundleContext bctx = this.getBundleContext();
        int n = bctx.getBundles().length;
        if (n > 1) {
            this.logger.logp(Level.FINE, "MinimalBundleProvisioner", "installBundles", "Skipping installation of bundles as there are already {0} no. of bundles.", new Object[]{n});
            bundleIds = Collections.emptyList();
        } else {
            bundleIds = super.installBundles();
        }
        this.installedBundleIds = bundleIds;
        return this.installedBundleIds;
    }

    @Override
    public void startBundles() {
        if (this.installedBundleIds.isEmpty()) {
            this.logger.log(Level.INFO, "NCLS-BOOTSTRAP-00032");
        } else {
            super.startBundles();
        }
    }

    @Override
    public boolean hasAnyThingChanged() {
        long latestBundleTimestamp = -1L;
        Bundle latestBundle = null;
        for (Bundle bundle2 : this.getBundleContext().getBundles()) {
            if (bundle2.getLastModified() <= latestBundleTimestamp) continue;
            latestBundleTimestamp = bundle2.getLastModified();
            latestBundle = bundle2;
        }
        Jar latestJar = this.getCustomizer().getLatestJar();
        boolean chnaged = latestJar.getLastModified() > latestBundle.getLastModified();
        this.logger.log(Level.INFO, "NCLS-BOOTSTRAP-00033", new Object[]{chnaged, latestJar.getURI(), latestBundle.getLocation()});
        return chnaged;
    }

    @Override
    public void refresh() {
        for (Bundle b : this.getBundleContext().getBundles()) {
            if (b.getBundleId() == 0L) continue;
            try {
                b.uninstall();
            }
            catch (BundleException e) {
                throw new RuntimeException(e);
            }
        }
        this.installBundles();
        super.refresh();
        this.setSystemBundleUpdationRequired(true);
    }

    @Override
    public MinimalBundleProvisionerCustomizer getCustomizer() {
        return (MinimalBundleProvisionerCustomizer)super.getCustomizer();
    }
}

