/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.log.LogFacade;
import com.sun.enterprise.glassfish.bootstrap.osgi.BundleProvisionerCustomizer;
import com.sun.enterprise.glassfish.bootstrap.osgi.DefaultBundleProvisionerCustomizer;
import com.sun.enterprise.glassfish.bootstrap.osgi.GlassFishBundleContext;
import com.sun.enterprise.glassfish.bootstrap.osgi.Jar;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleProvisioner {
    private static final Logger LOG = LogFacade.BOOTSTRAP_LOGGER;
    private GlassFishBundleContext bundleContext;
    private boolean systemBundleUpdationRequired;
    private final Map<URI, Jar> currentManagedBundles = new HashMap<URI, Jar>();
    private int noOfUninstalledBundles;
    private int noOfUpdatedBundles;
    private int noOfInstalledBundles;
    private final BundleProvisionerCustomizer customizer;

    public BundleProvisioner(BundleContext bundleContext, Properties config) {
        this(bundleContext, new DefaultBundleProvisionerCustomizer(config));
    }

    public BundleProvisioner(BundleContext bundleContext, BundleProvisionerCustomizer customizer) {
        this.bundleContext = new GlassFishBundleContext(bundleContext);
        this.customizer = customizer;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext.unwrap();
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = new GlassFishBundleContext(bundleContext);
    }

    public List<Long> installBundles() {
        this.initCurrentManagedBundles();
        Collection<Jar> current = this.getBundleJars();
        List<Jar> discovered = this.discoverJars();
        ArrayList<Jar> newBundles = new ArrayList<Jar>(discovered);
        newBundles.removeAll(current);
        ArrayList<Jar> deletedBundles = new ArrayList<Jar>(current);
        deletedBundles.removeAll(discovered);
        ArrayList<Jar> existingBundles = new ArrayList<Jar>(discovered);
        existingBundles.retainAll(current);
        this.uninstall(deletedBundles);
        this.update(existingBundles);
        this.install(newBundles);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Jar jar : this.currentManagedBundles.values()) {
            ids.add(jar.getBundleId());
        }
        return ids;
    }

    public void startBundles() {
        for (URI uri : this.getAutoStartLocations()) {
            Bundle bundle2 = this.getBundle(new Jar(uri));
            if (bundle2 == null) {
                LOG.log(Level.WARNING, "NCLS-BOOTSTRAP-00005", uri);
                continue;
            }
            this.startBundle(bundle2);
        }
    }

    private void startBundle(Bundle bundle2) {
        if (!this.isFragment(bundle2)) {
            try {
                bundle2.start(this.customizer.getStartOptions());
                LOG.logp(Level.FINE, "BundleProvisioner", "startBundle", "Started bundle = {0}", bundle2);
            }
            catch (BundleException e) {
                LogFacade.log(LOG, Level.WARNING, "NCLS-BOOTSTRAP-00006", e, bundle2);
            }
        }
    }

    private void initCurrentManagedBundles() {
        Bundle[] bundles;
        for (Bundle bundle2 : bundles = this.getBundleContext().getBundles()) {
            try {
                Jar jar;
                long id = bundle2.getBundleId();
                if (id == 0L || !this.customizer.isManaged(jar = new Jar(bundle2))) continue;
                this.addBundle(jar);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private List<URI> getAutoInstallLocations() {
        return this.customizer.getAutoInstallLocations();
    }

    private List<URI> getAutoStartLocations() {
        return this.customizer.getAutoStartLocations();
    }

    private Integer getStartLevel(Jar jar) {
        return this.customizer.getStartLevel(jar);
    }

    private List<Jar> discoverJars() {
        ArrayList<Jar> jars = new ArrayList<Jar>();
        for (URI uri : this.getAutoInstallLocations()) {
            jars.add(new Jar(uri));
        }
        return jars;
    }

    private int uninstall(List<Jar> bundles) {
        for (Jar jar : bundles) {
            Bundle bundle2 = this.getBundle(jar);
            if (bundle2 == null) {
                LOG.log(Level.WARNING, "NCLS-BOOTSTRAP-00007", new Object[]{jar.getPath()});
                continue;
            }
            try {
                if (this.isFrameworkExtensionBundle(bundle2)) {
                    this.setSystemBundleUpdationRequired(true);
                }
                bundle2.uninstall();
                ++this.noOfUninstalledBundles;
                this.removeBundle(jar);
                LOG.log(Level.INFO, "NCLS-BOOTSTRAP-00008", new Object[]{bundle2.getBundleId(), jar.getPath()});
            }
            catch (Exception e) {
                LogFacade.log(LOG, Level.WARNING, "NCLS-BOOTSTRAP-00011", e, jar.getPath());
            }
        }
        return this.noOfUninstalledBundles;
    }

    private int update(Collection<Jar> jars) {
        for (Jar jar : jars) {
            Jar existingJar;
            if (!jar.isNewer(existingJar = this.getBundleJar(jar))) continue;
            Bundle bundle2 = this.getBundle(existingJar);
            if (bundle2 == null) {
                LOG.log(Level.WARNING, "NCLS-BOOTSTRAP-00009", new Object[]{existingJar.getPath()});
                continue;
            }
            try {
                if (this.isFrameworkExtensionBundle(bundle2)) {
                    this.setSystemBundleUpdationRequired(true);
                }
                bundle2.update();
                ++this.noOfUpdatedBundles;
                LOG.log(Level.INFO, "NCLS-BOOTSTRAP-00010", new Object[]{bundle2.getBundleId(), jar.getPath()});
            }
            catch (Exception e) {
                LogFacade.log(LOG, Level.WARNING, "NCLS-BOOTSTRAP-00012", e, jar.getPath());
            }
        }
        return this.noOfUpdatedBundles;
    }

    private Collection<Jar> getBundleJars() {
        return this.currentManagedBundles.values();
    }

    private Jar getBundleJar(Jar jar) {
        return this.currentManagedBundles.get(jar.getURI());
    }

    private void addBundle(Jar jar) throws URISyntaxException {
        this.currentManagedBundles.put(jar.getURI(), jar);
    }

    private void removeBundle(Jar jar) throws URISyntaxException {
        this.currentManagedBundles.remove(jar.getURI());
    }

    private Bundle getBundle(Jar jar) {
        Jar jar1;
        long bundleId = jar.getBundleId();
        if (bundleId < 0L && (jar1 = this.currentManagedBundles.get(jar.getURI())) != null) {
            bundleId = jar1.getBundleId();
        }
        return this.getBundleContext().getBundle(bundleId);
    }

    private boolean isFrameworkExtensionBundle(Bundle bundle2) {
        if (this.isFragment(bundle2)) {
            String fragmentHost = (String)bundle2.getHeaders().get("Fragment-Host");
            String separator = ";";
            for (String s : fragmentHost.split(";")) {
                String directiveName;
                int idx = s.indexOf(":=");
                if (idx == -1 || !(directiveName = s.substring(0, idx).trim()).equals("extension") || !s.substring(idx + 2).trim().equals("framework")) continue;
                LOG.logp(Level.FINE, "BundleProvisioner", "isSystemBundleFragment", "{0} is a framework extension bundle", bundle2);
                return true;
            }
        }
        return false;
    }

    private boolean isFragment(Bundle bundle2) {
        return this.bundleContext.isFragment(bundle2);
    }

    private int install(Collection<Jar> jars) {
        for (Jar jar : jars) {
            try {
                InputStream is = jar.getURI().toURL().openStream();
                try {
                    Bundle bundle2 = this.getBundleContext().installBundle(this.makeLocation(jar), is);
                    Integer jarStartLevel = this.getStartLevel(jar);
                    if (jarStartLevel != null) {
                        this.bundleContext.setInitialBundleStartLevel(jarStartLevel);
                    }
                    ++this.noOfInstalledBundles;
                    this.addBundle(new Jar(bundle2));
                    LOG.logp(Level.FINE, "BundleProvisioner", "install", "Installed bundle {0} from {1} ", new Object[]{bundle2.getBundleId(), jar.getURI()});
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                LogFacade.log(LOG, Level.WARNING, "NCLS-BOOTSTRAP-00013", e, jar.getURI());
            }
        }
        return this.noOfInstalledBundles;
    }

    private String makeLocation(Jar jar) {
        return this.customizer.makeLocation(jar);
    }

    public void refresh() {
        this.bundleContext.refresh();
    }

    public boolean hasAnyThingChanged() {
        return this.getNoOfInstalledBundles() + this.getNoOfUninstalledBundles() + this.getNoOfUpdatedBundles() > 0;
    }

    public boolean isSystemBundleUpdationRequired() {
        return this.systemBundleUpdationRequired;
    }

    protected void setSystemBundleUpdationRequired(boolean systemBundleUpdationRequired) {
        this.systemBundleUpdationRequired = systemBundleUpdationRequired;
    }

    public int getNoOfUninstalledBundles() {
        return this.noOfUninstalledBundles;
    }

    public int getNoOfUpdatedBundles() {
        return this.noOfUpdatedBundles;
    }

    public int getNoOfInstalledBundles() {
        return this.noOfInstalledBundles;
    }

    public BundleProvisionerCustomizer getCustomizer() {
        return this.customizer;
    }
}

