/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.embedded;

import com.sun.enterprise.glassfish.bootstrap.cfg.OsgiPlatform;
import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextUtil;
import com.sun.enterprise.glassfish.bootstrap.embedded.EmbeddedGlassFishRuntime;
import com.sun.enterprise.glassfish.bootstrap.embedded.EmbeddedMain;
import com.sun.enterprise.glassfish.bootstrap.embedded.SingleHK2Factory;
import com.sun.enterprise.glassfish.bootstrap.log.LogFacade;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.spi.RuntimeBuilder;

public class EmbeddedGlassFishRuntimeBuilder
implements RuntimeBuilder {
    private static final Logger LOG = LogFacade.BOOTSTRAP_LOGGER;
    private static final String JAR_EXT = ".jar";
    private static final Set<String> MODULE_EXCLUDES = Set.of("jsftemplating.jar", "gf-client-module.jar");
    public static boolean addModuleJars = true;

    @Override
    public GlassFishRuntime build(BootstrapProperties bsProps) throws GlassFishException {
        String installRoot = this.getInstallRoot(bsProps);
        List<URL> moduleJarURLs = this.getModuleJarURLs(installRoot);
        ClassLoader cl = moduleJarURLs.isEmpty() ? this.getClass().getClassLoader() : new EmbeddedClassLoader(this.getClass().getClassLoader(), moduleJarURLs);
        return this.build(bsProps, cl, installRoot);
    }

    @Override
    public GlassFishRuntime build(BootstrapProperties bsProps, ClassLoader cl) throws GlassFishException {
        String installRoot = this.getInstallRoot(bsProps);
        return this.build(bsProps, cl, installRoot);
    }

    private GlassFishRuntime build(BootstrapProperties bsProps, ClassLoader cl, String installRoot) {
        if (installRoot != null) {
            System.setProperty("org.glassfish.embeddable.installRoot", installRoot);
        }
        SingleHK2Factory.initialize(cl);
        ModulesRegistry modulesRegistry = AbstractFactory.getInstance().createModulesRegistry();
        modulesRegistry.setParentClassLoader(cl);
        return new EmbeddedGlassFishRuntime(new EmbeddedMain());
    }

    @Override
    public boolean handles(BootstrapProperties bsProps) {
        String builderName = bsProps.getProperty("GlassFish.BUILDER_NAME");
        if (builderName != null && !builderName.equals(this.getClass().getName())) {
            return false;
        }
        String platform = bsProps.getProperty("GlassFish_Platform");
        return platform == null || OsgiPlatform.Embedded.name().equalsIgnoreCase(platform) || OsgiPlatform.Static.name().equalsIgnoreCase(platform);
    }

    private String getInstallRoot(BootstrapProperties props) {
        File installRoot;
        String installRootProp = props.getInstallRoot();
        if (installRootProp == null && this.isValidInstallRoot(installRoot = StartupContextUtil.detectInstallRoot())) {
            installRootProp = installRoot.getAbsolutePath();
        }
        return installRootProp;
    }

    private List<URL> getModuleJarURLs(String installRoot) {
        if (installRoot == null || !addModuleJars) {
            return new ArrayList<URL>();
        }
        File modulesDir = new File(installRoot, "modules/");
        final File autostartModulesDir = new File(modulesDir, "autostart/");
        final ArrayList<URL> moduleJarURLs = new ArrayList<URL>();
        modulesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.equals(autostartModulesDir)) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith(EmbeddedGlassFishRuntimeBuilder.JAR_EXT) && !MODULE_EXCLUDES.contains(pathname.getName())) {
                    try {
                        moduleJarURLs.add(pathname.toURI().toURL());
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "NCLS-BOOTSTRAP-00039", ex);
                    }
                }
                return false;
            }
        });
        return moduleJarURLs;
    }

    private boolean isValidInstallRoot(File installRoot) {
        if (installRoot == null || !installRoot.exists()) {
            return false;
        }
        if (!new File(installRoot, "modules").exists()) {
            return false;
        }
        return new File(installRoot, "lib/dtds").exists();
    }

    private static class EmbeddedClassLoader
    extends GlassfishUrlClassLoader {
        private EmbeddedClassLoader(ClassLoader parent, List<URL> moduleJarURLs) {
            super("EmbeddedCL", (URL[])moduleJarURLs.toArray(URL[]::new), parent);
        }

        static {
            EmbeddedClassLoader.registerAsParallelCapable();
        }
    }
}

