/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.AbstractConnectorResourceDescriptor;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.CommonResourceValidator;
import com.sun.enterprise.deployment.util.ComponentValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EnvEntriesValidator;
import com.sun.enterprise.deployment.util.ManagedBeanVisitor;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="application_deploy")
public class ApplicationValidator
extends ComponentValidator
implements ApplicationVisitor,
ManagedBeanVisitor {
    @LogMessageInfo(message="Duplicate descriptor found for given jndi-name: {0}.\nDescriptor 1:\n{1}\nDescriptor 2:\n{2}", level="SEVERE", cause="Two or more resource definitions use the same jndi-name in the same or related contexts", action="Make sure that all JNDI names used to define resources in application's resource annotations or desciptors are unique in each context. For example java:app/myname conflicts with java:comp:myname because myname jndi-name is defined twice in the component context")
    private static final String DUPLICATE_DESCRIPTOR = "dol.validation.application.jndiNameConflict";
    @LogMessageInfo(message="Application validation failed for application: {0}, jndi-name: {1}, resource adapter name: {2} is wrong.", level="SEVERE", cause="For embedded resource adapter, its name should begin with '#' symbol", action="Remove application name before the '#' symbol in the resource adapter name.", comment="For the method validateResourceDescriptor of com.sun.enterprise.deployment.util.ApplicationValidator")
    private static final String RESOURCE_ADAPTER_NAME_INVALID = "dol.validation.application.failed";
    private static final System.Logger LOG = DOLUtils.getLogger();
    private static final String APPCLIENT_KEYS = "APPCLIENT_KEYS";
    private static final String EJBBUNDLE_KEYS = "EJBBUNDLE_KEYS";
    private static final String APP_KEYS = "APP_KEYS";
    private static final String WEBBUNDLE_KEYS = "WEBBUNDLE_KEYS";
    private static final String EJB_KEYS = "EJB_KEYS";
    private static final String CONNECTOR_KEYS = "CONNECTOR_KEYS";
    private static final String JNDI_COMP = "java:comp";
    private static final String JNDI_MODULE = "java:module";
    private static final String JNDI_APP = "java:app";
    private static final String APP_LEVEL = "AppLevel:";
    private static final String EJBBUNDLE_LEVEL = "EBDLevel:";
    private static final String EJB_LEVEL = "EJBLevel:";
    private static final String APPCLIENTBUNDLE_LEVEL = "ACDevel:";
    private static final String APPCLIENT_LEVEL = "ACLevel:";
    private static final String WEBBUNDLE_LEVEL = "WBDLevel:";
    private final HashMap<SimpleJndiName, CommonResourceValidator> allResourceDescriptors = new HashMap();
    private final HashMap<String, List<String>> validNameSpaceDetails = new HashMap();
    private boolean allUniqueResource = true;
    private SimpleJndiName inValidJndiName;

    @Override
    public void accept(BundleDescriptor descriptor) {
        LOG.log(System.Logger.Level.DEBUG, "accept(descriptor.name={0})", descriptor.getName());
        if (!Application.class.isInstance(descriptor)) {
            super.accept(descriptor);
            return;
        }
        this.accept((Application)descriptor);
        if (!this.validateResourceDescriptor()) {
            throw new IllegalArgumentException(MessageFormat.format("Application validation fails for given application {0} for jndi-name {1}", this.application.getAppName(), this.inValidJndiName));
        }
        this.validateEnvEntries(this.application);
        for (BundleDescriptor ebd : this.application.getBundleDescriptorsOfType(DOLUtils.ejbType())) {
            DescriptorVisitor visitor = this.getSubDescriptorVisitor(ebd);
            if (visitor == null) continue;
            ebd.visit(visitor);
        }
        for (BundleDescriptor wbd : this.application.getBundleDescriptorsOfType(DOLUtils.warType())) {
            if (wbd == null) continue;
            wbd.visit(this.getSubDescriptorVisitor(wbd));
        }
        for (BundleDescriptor cd : this.application.getBundleDescriptorsOfType(DOLUtils.rarType())) {
            cd.visit(this.getSubDescriptorVisitor(cd));
        }
        for (BundleDescriptor acd : this.application.getBundleDescriptorsOfType(DOLUtils.carType())) {
            acd.visit(this.getSubDescriptorVisitor(acd));
        }
        for (InjectionCapable injectable : this.application.getInjectableResources(this.application)) {
            this.accept(injectable);
        }
        for (BundleDescriptor bundle2 : this.application.getBundleDescriptors()) {
            for (ManagedBeanDescriptor next : bundle2.getManagedBeans()) {
                next.validate();
            }
        }
        super.accept(this.application);
    }

    @Override
    public void accept(Application application) {
        LOG.log(System.Logger.Level.DEBUG, "accept(application.name={0})", application.getName());
        this.application = application;
        if (application.getBundleDescriptors().isEmpty()) {
            throw new IllegalArgumentException("Application [" + application.getRegistrationName() + "] contains no valid components");
        }
        ArrayList<ModuleDescriptor<BundleDescriptor>> conflicted = new ArrayList<ModuleDescriptor<BundleDescriptor>>();
        Set<ModuleDescriptor<BundleDescriptor>> modules = application.getModules();
        for (ModuleDescriptor<BundleDescriptor> module1 : modules) {
            if (conflicted.contains(module1)) continue;
            boolean foundConflictedModule = false;
            for (ModuleDescriptor<BundleDescriptor> module2 : modules) {
                if (conflicted.contains(module2) || module1.equals(module2) || !Objects.equals(module1.getModuleName(), module2.getModuleName())) continue;
                conflicted.add(module2);
                foundConflictedModule = true;
            }
            if (!foundConflictedModule) continue;
            conflicted.add(module1);
        }
        for (ModuleDescriptor<BundleDescriptor> cModule : conflicted) {
            cModule.setModuleName(cModule.getModuleName() + Objects.toString(cModule.getModuleType()));
        }
    }

    public void accept(EjbBundleDescriptor bundleDescriptor) {
        LOG.log(System.Logger.Level.DEBUG, "accept(bundleDescriptor.name={0})", bundleDescriptor.getName());
        this.bundleDescriptor = bundleDescriptor;
        this.application = bundleDescriptor.getApplication();
        super.accept(bundleDescriptor);
        String rlm = this.application.getRealm();
        if (rlm != null) {
            for (EjbDescriptor ejbDescriptor : bundleDescriptor.getEjbs()) {
                for (EjbIORConfigurationDescriptor desc : ejbDescriptor.getIORConfigurationDescriptors()) {
                    desc.setRealmName(rlm);
                }
            }
        }
    }

    @Override
    public void accept(ManagedBeanDescriptor managedBean) {
        LOG.log(System.Logger.Level.DEBUG, "accept(managedBean.name={0})", managedBean.getName());
        this.bundleDescriptor = managedBean.getBundle();
        this.application = this.bundleDescriptor.getApplication();
        for (EjbReference ejbReference : managedBean.getEjbReferenceDescriptors()) {
            this.accept(ejbReference);
        }
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : managedBean.getResourceReferenceDescriptors()) {
            this.accept(resourceReferenceDescriptor);
        }
        for (ResourceEnvReferenceDescriptor resourceEnvReferenceDescriptor : managedBean.getResourceEnvReferenceDescriptors()) {
            this.accept(resourceEnvReferenceDescriptor);
        }
        for (MessageDestinationReferencer messageDestinationReferencer : managedBean.getMessageDestinationReferenceDescriptors()) {
            this.accept(messageDestinationReferencer);
        }
        for (ServiceReferenceDescriptor serviceReferenceDescriptor : managedBean.getServiceReferenceDescriptors()) {
            this.accept(serviceReferenceDescriptor);
        }
    }

    protected Collection<EjbDescriptor> getEjbDescriptors() {
        if (this.application != null) {
            return this.application.getEjbDescriptors();
        }
        return new HashSet<EjbDescriptor>();
    }

    @Override
    protected Application getApplication() {
        return this.application;
    }

    @Override
    public DescriptorVisitor getSubDescriptorVisitor(Descriptor subDescriptor) {
        if (subDescriptor instanceof BundleDescriptor) {
            return ((BundleDescriptor)subDescriptor).getBundleVisitor();
        }
        return super.getSubDescriptorVisitor(subDescriptor);
    }

    private boolean validateResourceDescriptor() {
        Set<EnvironmentProperty> environmentProperties = this.application.getEnvironmentProperties();
        if (environmentProperties != null) {
            for (EnvironmentProperty environmentProperty : environmentProperties) {
                SimpleJndiName jndiName = environmentProperty.hasLookupName() ? environmentProperty.getLookupName() : (!environmentProperty.getMappedName().isEmpty() ? environmentProperty.getMappedName() : SimpleJndiName.of(environmentProperty.getName()));
                if (!jndiName.isJavaComponent() && !jndiName.isJavaModule()) continue;
                this.inValidJndiName = jndiName;
                return false;
            }
        }
        ArrayList<CallSite> appLevel = new ArrayList<CallSite>();
        Set<ResourceDescriptor> resourceDescriptors = this.application.getAllResourcesDescriptors();
        if (this.findConflictingDescriptors(resourceDescriptors, APP_LEVEL + this.application.getName())) {
            return false;
        }
        appLevel.add((CallSite)((Object)(APP_LEVEL + this.application.getName())));
        this.validNameSpaceDetails.put(APP_KEYS, appLevel);
        Set<ApplicationClientDescriptor> appClientDescs = this.application.getBundleDescriptors(ApplicationClientDescriptor.class);
        ArrayList<CallSite> appClientLevel = new ArrayList<CallSite>();
        for (ApplicationClientDescriptor acd : appClientDescs) {
            Set<ResourceDescriptor> resourceDescriptors2 = acd.getAllResourcesDescriptors((Class)ApplicationClientDescriptor.class);
            if (this.findConflictingDescriptors(resourceDescriptors2, APPCLIENTBUNDLE_LEVEL + acd.getName())) {
                return false;
            }
            appClientLevel.add((CallSite)((Object)(APPCLIENTBUNDLE_LEVEL + acd.getName())));
        }
        this.validNameSpaceDetails.put(APPCLIENT_KEYS, appClientLevel);
        Set<ConnectorDescriptor> connectorDescs = this.application.getBundleDescriptors(ConnectorDescriptor.class);
        ArrayList<CallSite> cdLevel = new ArrayList<CallSite>();
        for (ConnectorDescriptor cd : connectorDescs) {
            Set<ResourceDescriptor> resourceDescriptors3 = cd.getAllResourcesDescriptors(ApplicationClientDescriptor.class);
            if (this.findConflictingDescriptors(resourceDescriptors3, APPCLIENT_LEVEL + cd.getName())) {
                return false;
            }
            cdLevel.add((CallSite)((Object)(APPCLIENT_LEVEL + cd.getName())));
        }
        this.validNameSpaceDetails.put(CONNECTOR_KEYS, cdLevel);
        Set<EjbBundleDescriptor> ejbBundleDescs = this.application.getBundleDescriptors(EjbBundleDescriptor.class);
        ArrayList<CallSite> ebdLevel = new ArrayList<CallSite>();
        ArrayList<CallSite> edLevel = new ArrayList<CallSite>();
        for (EjbBundleDescriptor ebd : ejbBundleDescs) {
            Set<ResourceDescriptor> resourceDescriptors4 = ebd.getAllResourcesDescriptors();
            if (this.findConflictingDescriptors(resourceDescriptors4, EJBBUNDLE_LEVEL + ebd.getName())) {
                return false;
            }
            ebdLevel.add((CallSite)((Object)(EJBBUNDLE_LEVEL + ebd.getName())));
            Set<? extends EjbDescriptor> ejbDescriptors = ebd.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                resourceDescriptors4 = ejbDescriptor.getAllResourcesDescriptors();
                if (this.findConflictingDescriptors(resourceDescriptors4, EJB_LEVEL + ebd.getName() + "#" + ejbDescriptor.getName())) {
                    return false;
                }
                edLevel.add((CallSite)((Object)(EJB_LEVEL + ebd.getName() + "#" + ejbDescriptor.getName())));
            }
        }
        this.validNameSpaceDetails.put(EJBBUNDLE_KEYS, ebdLevel);
        this.validNameSpaceDetails.put(EJB_KEYS, edLevel);
        Set<WebBundleDescriptor> webBundleDescs = this.application.getBundleDescriptors(WebBundleDescriptor.class);
        ArrayList<CallSite> wbdLevel = new ArrayList<CallSite>();
        for (WebBundleDescriptor wbd : webBundleDescs) {
            Set<ResourceDescriptor> resourceDescriptors5 = wbd.getAllResourcesDescriptors();
            if (this.findConflictingDescriptors(resourceDescriptors5, WEBBUNDLE_LEVEL + wbd.getName())) {
                return false;
            }
            wbdLevel.add((CallSite)((Object)(WEBBUNDLE_LEVEL + wbd.getName())));
        }
        this.validNameSpaceDetails.put(WEBBUNDLE_KEYS, wbdLevel);
        for (CommonResourceValidator rv : this.allResourceDescriptors.values()) {
            AbstractConnectorResourceDescriptor abstractConnectorResourceDescriptor;
            ResourceDescriptor desc = rv.getDescriptor();
            if (!(desc instanceof AbstractConnectorResourceDescriptor) || (abstractConnectorResourceDescriptor = (AbstractConnectorResourceDescriptor)desc).getResourceAdapter() == null) continue;
            int poundIndex = abstractConnectorResourceDescriptor.getResourceAdapter().indexOf(35);
            if (poundIndex == 0) {
                abstractConnectorResourceDescriptor.setResourceAdapter(this.application.getName() + abstractConnectorResourceDescriptor.getResourceAdapter());
                continue;
            }
            if (poundIndex < 0) continue;
            LOG.log(System.Logger.Level.ERROR, RESOURCE_ADAPTER_NAME_INVALID, this.application.getAppName(), abstractConnectorResourceDescriptor.getName(), abstractConnectorResourceDescriptor.getResourceAdapter());
            return false;
        }
        if (this.allUniqueResource) {
            return this.compareDescriptors();
        }
        return true;
    }

    private void validateEnvEntries(Application application) {
        EnvEntriesValidator envValidator = new EnvEntriesValidator();
        envValidator.validateEnvEntries(application);
        Set<ApplicationClientDescriptor> appClientDescs = application.getBundleDescriptors(ApplicationClientDescriptor.class);
        for (ApplicationClientDescriptor applicationClientDescriptor : appClientDescs) {
            envValidator.validateEnvEntries(applicationClientDescriptor);
        }
        Set<EjbBundleDescriptor> ejbBundleDescs = application.getBundleDescriptors(EjbBundleDescriptor.class);
        for (EjbBundleDescriptor ebd : ejbBundleDescs) {
            Set<? extends EjbDescriptor> ejbDescriptors = ebd.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                envValidator.validateEnvEntries(ejbDescriptor);
            }
        }
        Set<WebBundleDescriptor> set = application.getBundleDescriptors(WebBundleDescriptor.class);
        for (WebBundleDescriptor wbd : set) {
            envValidator.validateEnvEntries(wbd);
        }
    }

    private boolean findConflictingDescriptors(Set<ResourceDescriptor> descriptors, String scope) {
        boolean detected = false;
        for (ResourceDescriptor descriptor : descriptors) {
            if (!this.isConflictingDescriptor(descriptor.getJndiName(), descriptor, scope)) continue;
            detected = true;
        }
        return detected;
    }

    private boolean isConflictingDescriptor(SimpleJndiName name, ResourceDescriptor descriptor, String scope) {
        LOG.log(System.Logger.Level.DEBUG, "isConflictingDescriptor(name={0}, descriptor, scope={1})", name, scope);
        if (descriptor == null) {
            return false;
        }
        CommonResourceValidator commonResourceValidator = this.allResourceDescriptors.get(name);
        if (commonResourceValidator == null) {
            this.allResourceDescriptors.put(name, new CommonResourceValidator(descriptor, name, scope));
            return false;
        }
        ResourceDescriptor existingDescriptor = commonResourceValidator.getDescriptor();
        if (descriptor.equals(existingDescriptor)) {
            commonResourceValidator.addDuplicity(descriptor, scope);
            return false;
        }
        LOG.log(System.Logger.Level.ERROR, DUPLICATE_DESCRIPTOR, name, existingDescriptor, descriptor);
        this.inValidJndiName = name;
        this.allUniqueResource = false;
        return true;
    }

    private boolean compareDescriptors() {
        List<String> appLevelScopes = this.validNameSpaceDetails.get(APP_KEYS);
        List<String> ebdLevelScopes = this.validNameSpaceDetails.get(EJBBUNDLE_KEYS);
        for (Map.Entry<SimpleJndiName, CommonResourceValidator> entry : this.allResourceDescriptors.entrySet()) {
            CommonResourceValidator validator = entry.getValue();
            SimpleJndiName jndiName = validator.getJndiName();
            List<CommonResourceValidator.DuplicitDescriptor> possibleConflicts = validator.getDescriptors();
            if (jndiName.contains(JNDI_COMP)) {
                for (CommonResourceValidator.DuplicitDescriptor candidate : possibleConflicts) {
                    for (String appLevelScope : appLevelScopes) {
                        if (!candidate.scope.equals(appLevelScope)) continue;
                        this.inValidJndiName = jndiName;
                        LOG.log(System.Logger.Level.ERROR, "enterprise.deployment.util.application.invalid.jndiname.scope", candidate, jndiName);
                        return false;
                    }
                    for (String ebdLevelScope : ebdLevelScopes) {
                        if (!candidate.scope.equals(ebdLevelScope)) continue;
                        this.inValidJndiName = jndiName;
                        LOG.log(System.Logger.Level.ERROR, "enterprise.deployment.util.application.invalid.jndiname.scope", candidate, jndiName);
                        return false;
                    }
                }
            }
            if (jndiName.contains(JNDI_MODULE)) {
                for (CommonResourceValidator.DuplicitDescriptor candidate : possibleConflicts) {
                    for (String appLevelScope : appLevelScopes) {
                        if (!candidate.scope.equals(appLevelScope)) continue;
                        this.inValidJndiName = jndiName;
                        LOG.log(System.Logger.Level.ERROR, "enterprise.deployment.util.application.invalid.jndiname.scope", candidate, jndiName);
                        return false;
                    }
                }
            }
            if (possibleConflicts.size() <= 1) continue;
            if (jndiName.contains(JNDI_COMP)) {
                if (this.compareVectorForComp(possibleConflicts, jndiName)) continue;
                return false;
            }
            if (jndiName.contains(JNDI_MODULE)) {
                if (this.compareVectorForModule(possibleConflicts, jndiName)) continue;
                return false;
            }
            if (jndiName.contains(JNDI_APP)) {
                if (this.compareVectorForApp(possibleConflicts, jndiName)) continue;
                return false;
            }
            try {
                InitialContext ic = new InitialContext();
                Object lookup = ic.lookup(jndiName.toString());
                if (lookup == null) continue;
                this.inValidJndiName = jndiName;
                LOG.log(System.Logger.Level.ERROR, "enterprise.deployment.util.application.lookup", jndiName);
                return false;
            }
            catch (NamingException namingException) {
            }
        }
        return true;
    }

    private boolean compareVectorForApp(List<CommonResourceValidator.DuplicitDescriptor> possibleConflicts, SimpleJndiName jndiName) {
        for (int j = 0; j < possibleConflicts.size(); ++j) {
            CommonResourceValidator.DuplicitDescriptor candidate1 = possibleConflicts.get(j);
            String scope1 = this.getFirstScopeSegment(candidate1.scope);
            for (int i = j + 1; i < possibleConflicts.size(); ++i) {
                CommonResourceValidator.DuplicitDescriptor candidate2 = possibleConflicts.get(i);
                String scope2 = this.getFirstScopeSegment(candidate2.scope);
                if (!scope1.equals(scope2) || candidate1.descriptor == candidate2.descriptor) continue;
                this.inValidJndiName = jndiName;
                LOG.log(System.Logger.Level.WARNING, "JNDI name {0} is declared by multiple modules of the application {1}. Scopes: {2}, {3}", jndiName, this.application.getAppName(), candidate1.scope, candidate2.scope);
            }
        }
        return true;
    }

    private boolean compareVectorForModule(List<CommonResourceValidator.DuplicitDescriptor> possibleConflicts, SimpleJndiName jndiName) {
        if (!this.compareVectorForApp(possibleConflicts, jndiName)) {
            return false;
        }
        for (int j = 0; j < possibleConflicts.size(); ++j) {
            CommonResourceValidator.DuplicitDescriptor candidate1 = possibleConflicts.get(j);
            String scope1 = this.getFirstScopeSegment(this.removeFirstScopeSegment(candidate1.scope));
            for (int i = j + 1; i < possibleConflicts.size(); ++i) {
                CommonResourceValidator.DuplicitDescriptor candidate2 = possibleConflicts.get(i);
                String scope2 = this.getFirstScopeSegment(this.removeFirstScopeSegment(candidate1.scope));
                if (!scope1.equals(scope2) || candidate1.descriptor == candidate2.descriptor) continue;
                this.inValidJndiName = jndiName;
                LOG.log(System.Logger.Level.WARNING, "JNDI name {0} is declared by multiple components of the module {1} of the application {2}. Scopes: {3}, {4}", jndiName, scope1, this.application.getAppName(), candidate1.scope, candidate2.scope);
            }
        }
        return true;
    }

    private boolean compareVectorForComp(List<CommonResourceValidator.DuplicitDescriptor> possibleConflicts, SimpleJndiName jndiName) {
        if (!this.compareVectorForModule(possibleConflicts, jndiName)) {
            return false;
        }
        for (int j = 0; j < possibleConflicts.size(); ++j) {
            CommonResourceValidator.DuplicitDescriptor candidate1 = possibleConflicts.get(j);
            String scope1 = this.getLastScopeSegment(this.getLastScopeSegment(candidate1.scope));
            for (int i = j + 1; i < possibleConflicts.size(); ++i) {
                CommonResourceValidator.DuplicitDescriptor candidate2 = possibleConflicts.get(i);
                String scope2 = this.getLastScopeSegment(this.getLastScopeSegment(candidate2.scope));
                if (!scope1.equals(scope2) || candidate1.descriptor == candidate2.descriptor) continue;
                this.inValidJndiName = jndiName;
                LOG.log(System.Logger.Level.ERROR, "enterprise.deployment.util.application.invalid.namespace", jndiName, this.application.getAppName());
                return false;
            }
        }
        return true;
    }

    private String getFirstScopeSegment(String scope) {
        int index = scope.indexOf(35);
        return index > 0 ? scope.substring(0, index) : scope;
    }

    private String removeFirstScopeSegment(String scope) {
        int index = scope.indexOf(35);
        return index > 0 ? scope.substring(index + 1) : scope;
    }

    private String getLastScopeSegment(String scope) {
        int index = scope.lastIndexOf(35) + 1;
        return index > 0 ? scope.substring(index) : scope;
    }
}

