/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ws;

import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.NameValuePairNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.ws.WLServiceRefPortInfoRuntimeNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class WLServiceRefNode
extends DeploymentDescriptorNode<ServiceReferenceDescriptor> {
    private ServiceReferenceDescriptor descriptor;

    public WLServiceRefNode() {
        this.registerElementHandler(new XMLElement("port-info"), WLServiceRefPortInfoRuntimeNode.class);
        this.registerElementHandler(new XMLElement("call-property"), NameValuePairNode.class, "addCallProperty");
    }

    @Override
    public void addDescriptor(Object desc) {
        if (desc instanceof ServiceRefPortInfo) {
            ServiceRefPortInfo newPortInfo = (ServiceRefPortInfo)desc;
            ServiceReferenceDescriptor serviceRef = this.getDescriptor();
            serviceRef.addRuntimePortInfo(newPortInfo);
        }
    }

    @Override
    public ServiceReferenceDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        String name = element.getQName();
        if ("service-ref-name".equals(name)) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof JndiNameEnvironment) {
                this.descriptor = ((JndiNameEnvironment)parentDesc).getServiceReferenceByName(value);
            } else if (parentDesc instanceof WebBundleDescriptor) {
                WebBundleDescriptor desc = (WebBundleDescriptor)parentDesc;
                this.descriptor = desc.getServiceReferenceByName(value);
            }
        } else if ("wsdl-url".equals(name)) {
            try {
                URL url = new URL(value);
                this.descriptor.setWsdlOverride(url);
            }
            catch (MalformedURLException mue) {
                DOLUtils.getDefaultLogger().log(Level.INFO, "Warning : Invalid wsdl override url=" + value, mue);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, ServiceReferenceDescriptor serviceRef) {
        Node serviceRefNode = super.writeDescriptor(parent, nodeName, serviceRef);
        WLServiceRefNode.appendTextChild(serviceRefNode, "service-ref-name", serviceRef.getName());
        if (serviceRef.hasWsdlOverride()) {
            URL wsdlOverride = serviceRef.getWsdlOverride();
            WLServiceRefNode.appendTextChild(serviceRefNode, "wsdl-url", wsdlOverride.toExternalForm());
        }
        NameValuePairNode nameValueNode = new NameValuePairNode();
        for (NameValuePairDescriptor nameValuePairDescriptor : serviceRef.getCallProperties()) {
            nameValueNode.writeDescriptor(serviceRefNode, "call-property", nameValuePairDescriptor);
        }
        WLServiceRefPortInfoRuntimeNode portInfoRuntimeNode = new WLServiceRefPortInfoRuntimeNode();
        Set<ServiceRefPortInfo> portsInfo = serviceRef.getPortsInfo();
        for (ServiceRefPortInfo element : portsInfo) {
            portInfoRuntimeNode.writeDescriptor(serviceRefNode, "port-name", element);
        }
        return serviceRefNode;
    }

    public static void writeServiceReferences(Node parent, JndiNameEnvironment descriptor) {
        Iterator<ServiceReferenceDescriptor> serviceRefs = descriptor.getServiceReferenceDescriptors().iterator();
        if (serviceRefs.hasNext()) {
            WLServiceRefNode serviceRefNode = new WLServiceRefNode();
            while (serviceRefs.hasNext()) {
                ServiceReferenceDescriptor next = serviceRefs.next();
                if (next.getPortsInfo().isEmpty() && next.getCallProperties().isEmpty() && !next.hasWsdlOverride()) continue;
                serviceRefNode.writeDescriptor(parent, "service-reference-description", next);
            }
        }
    }
}

