/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.connector;

import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.node.runtime.common.RuntimeNameValuePairNode;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.runtime.connector.ResourceAdapter;
import org.glassfish.api.naming.SimpleJndiName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceAdapterNode
extends RuntimeDescriptorNode<RuntimeDescriptor> {
    protected RuntimeDescriptor descriptor;

    public ResourceAdapterNode() {
        this.handlers = null;
        this.registerElementHandler(new XMLElement("property"), RuntimeNameValuePairNode.class, "addPropertyElement");
    }

    @Override
    public RuntimeDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (RuntimeDescriptor)super.getDescriptor();
            this.descriptor.setValue("MaxPoolSize", "32");
            this.descriptor.setValue("SteadyPoolSize", "4");
            this.descriptor.setValue("MaxWaitTimeInMillis", "10000");
            this.descriptor.setValue("IdleTimeoutInSeconds", "1000");
        }
        return this.descriptor;
    }

    @Override
    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        this.getDescriptor();
        if (this.descriptor == null) {
            throw new RuntimeException("Trying to set values on a null descriptor");
        }
        if (attributeName.getQName().equals("jndi-name")) {
            this.descriptor.setAttributeValue("JndiName", SimpleJndiName.of(value));
            return true;
        }
        if (attributeName.getQName().equals("max-pool-size")) {
            this.descriptor.setAttributeValue("MaxPoolSize", value);
            return true;
        }
        if (attributeName.getQName().equals("steady-pool-size")) {
            this.descriptor.setAttributeValue("SteadyPoolSize", value);
            return true;
        }
        if (attributeName.getQName().equals("max-wait-time-in-millis")) {
            this.descriptor.setAttributeValue("MaxWaitTimeInMillis", value);
            return true;
        }
        if (attributeName.getQName().equals("idle-timeout-in-seconds")) {
            this.descriptor.setAttributeValue("IdleTimeoutInSeconds", value);
            return true;
        }
        return false;
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, ResourceAdapter descriptor) {
        Element raNode = (Element)super.writeDescriptor(parent, nodeName, descriptor);
        ResourceAdapterNode.appendTextChild((Node)raNode, "description", descriptor.getDescription());
        SimpleJndiName jndiName = (SimpleJndiName)descriptor.getValue("JndiName");
        if (jndiName != null) {
            ResourceAdapterNode.setAttribute(raNode, "jndi-name", jndiName.toString());
        }
        ResourceAdapterNode.setAttribute(raNode, "max-pool-size", (String)descriptor.getValue("MaxPoolSize"));
        ResourceAdapterNode.setAttribute(raNode, "steady-pool-size", (String)descriptor.getValue("SteadyPoolSize"));
        ResourceAdapterNode.setAttribute(raNode, "max-wait-time-in-millis", (String)descriptor.getValue("MaxWaitTimeInMillis"));
        ResourceAdapterNode.setAttribute(raNode, "idle-timeout-in-seconds", (String)descriptor.getValue("IdleTimeoutInSeconds"));
        NameValuePairDescriptor[] properties = descriptor.getPropertyElement();
        if (properties != null && properties.length > 0) {
            RuntimeNameValuePairNode subNode = new RuntimeNameValuePairNode();
            for (NameValuePairDescriptor element : properties) {
                subNode.writeDescriptor((Node)raNode, "property", element);
            }
        }
        return raNode;
    }
}

