/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.connector;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.connector.AuthMechNode;
import com.sun.enterprise.deployment.node.connector.ConfigPropertyNode;
import com.sun.enterprise.deployment.node.connector.ConnectionDefNode;
import com.sun.enterprise.deployment.node.connector.SecurityPermissionNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class OutBoundRANode
extends DeploymentDescriptorNode<OutboundResourceAdapter> {
    private OutboundResourceAdapter descriptor;

    public static Node writeOutboundResourceAdapter(Node connectorNode, OutboundResourceAdapter adapter) {
        Element raNode = OutBoundRANode.appendChild(connectorNode, "outbound-resourceadapter");
        ConnectionDefNode.writeConnectionDefDescriptors(raNode, adapter.getConnectionDefs());
        OutBoundRANode.appendTextChild((Node)raNode, "transaction-support", adapter.getTransSupport());
        AuthMechNode.writeAuthMechanisms(raNode, adapter.getAuthMechanisms());
        OutBoundRANode.appendTextChild((Node)raNode, "reauthentication-support", adapter.getReauthenticationSupport());
        return connectorNode;
    }

    public OutBoundRANode() {
        this.register();
    }

    public OutBoundRANode(XMLElement element) {
        this.setXMLRootTag(element);
        this.register();
    }

    private void register() {
        this.registerElementHandler(new XMLElement("authentication-mechanism"), AuthMechNode.class);
        this.registerElementHandler(new XMLElement("connection-definition"), ConnectionDefNode.class);
        this.registerElementHandler(new XMLElement("config-property"), ConfigPropertyNode.class);
        this.registerElementHandler(new XMLElement("security-permission"), SecurityPermissionNode.class);
    }

    public void createConDefDescriptorFor10() {
        ConnectionDefDescriptor conDef = new ConnectionDefDescriptor();
        this.getDescriptor().addConnectionDefDescriptor(conDef);
    }

    @Override
    public OutboundResourceAdapter getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (OutboundResourceAdapter)DescriptorFactory.getDescriptor(this.getXMLPath());
            ((ConnectorDescriptor)this.getParentNode().getDescriptor()).setOutboundResourceAdapter(this.descriptor);
        }
        return this.descriptor;
    }

    @Override
    public void addDescriptor(Object obj) {
        if (obj instanceof AuthMechanism) {
            boolean flag = this.descriptor.addAuthMechanism((AuthMechanism)obj);
            if (!flag) {
                DOLUtils.getDefaultLogger().finer("The AuthMechanism object already exists in the Descriptor");
            }
        } else if (obj instanceof ConnectionDefDescriptor) {
            this.descriptor.addConnectionDefDescriptor((ConnectionDefDescriptor)obj);
        } else if (obj instanceof ConnectorConfigProperty) {
            this.descriptor.addConfigProperty((ConnectorConfigProperty)obj);
        } else if (obj instanceof SecurityPermission) {
            ConnectorDescriptor connDesc = (ConnectorDescriptor)this.getParentNode().getDescriptor();
            connDesc.addSecurityPermission((SecurityPermission)obj);
        }
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("transaction-support", "setTransactionSupport");
        table.put("reauthentication-support", "setReauthenticationSupport");
        table.put("managedconnectionfactory-class", "setManagedConnectionFactoryImpl");
        table.put("connectionfactory-interface", "setConnectionFactoryIntf");
        table.put("connectionfactory-impl-class", "setConnectionFactoryImpl");
        table.put("connection-interface", "setConnectionIntf");
        table.put("connection-impl-class", "setConnectionImpl");
        return table;
    }

    @Override
    public void startElement(XMLElement element, Attributes attributes) {
    }
}

