/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.api.deployment.archive.WritableArchiveEntry;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.jvnet.hk2.annotations.Contract;
import org.xml.sax.SAXException;

@Contract
public abstract class ExtensionsArchivist<T extends RootDeploymentDescriptor> {
    private static final Logger LOG = DOLUtils.deplLogger;
    protected DeploymentDescriptorFile<RootDeploymentDescriptor> standardDD;
    protected List<ConfigurationDeploymentDescriptorFile> confDDFiles;
    private List<ConfigurationDeploymentDescriptorFile> sortedConfDDFiles;
    private ConfigurationDeploymentDescriptorFile confDD;

    public abstract DeploymentDescriptorFile getStandardDDFile(RootDeploymentDescriptor var1);

    public abstract List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles(RootDeploymentDescriptor var1);

    public ConfigurationDeploymentDescriptorFile getConfigurationDDFile(Archivist main, RootDeploymentDescriptor descriptor, ReadableArchive archive) throws IOException {
        if (this.confDD == null) {
            this.getSortedConfigurationDDFiles(descriptor, archive, main.getModuleType());
            if (this.sortedConfDDFiles != null && !this.sortedConfDDFiles.isEmpty()) {
                this.confDD = this.sortedConfDDFiles.get(0);
            }
        }
        return this.confDD;
    }

    public abstract boolean supportsModuleType(ArchiveType var1);

    public abstract <T extends RootDeploymentDescriptor> T getDefaultDescriptor();

    public <T extends RootDeploymentDescriptor> ModuleScanner<T> getScanner() {
        return null;
    }

    public void addExtension(RootDeploymentDescriptor root, RootDeploymentDescriptor extension) {
        root.addExtensionDescriptor(extension.getClass(), extension, null);
        extension.setModuleDescriptor(root.getModuleDescriptor());
    }

    public RootDeploymentDescriptor open(Archivist<?> main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXException {
        this.getStandardDDFile(descriptor).setArchiveType(main.getModuleType());
        if (archive.getURI() != null) {
            this.standardDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
        }
        try (InputStream is = archive.getEntry(this.standardDD.getDeploymentDescriptorPath());){
            if (is == null) {
                if (LOG.isLoggable(Level.CONFIG)) {
                    LOG.log(Level.CONFIG, "Deployment descriptor: " + this.standardDD.getDeploymentDescriptorPath() + " does not exist in archive: " + String.valueOf(archive.getURI()));
                }
                RootDeploymentDescriptor rootDeploymentDescriptor = null;
                return rootDeploymentDescriptor;
            }
            this.standardDD.setXMLValidation(main.getXMLValidation());
            this.standardDD.setXMLValidationLevel(main.getXMLValidationLevel());
            RootDeploymentDescriptor rootDeploymentDescriptor = this.standardDD.read(descriptor, is);
            return rootDeploymentDescriptor;
        }
    }

    public RootDeploymentDescriptor readRuntimeDeploymentDescriptor(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXException {
        ConfigurationDeploymentDescriptorFile ddFile = this.getConfigurationDDFile(main, descriptor, archive);
        if (ddFile == null) {
            return descriptor;
        }
        DOLUtils.readRuntimeDeploymentDescriptor(this.getSortedConfigurationDDFiles(descriptor, archive, main.getModuleType()), archive, descriptor, main, true);
        return descriptor;
    }

    public void writeDeploymentDescriptors(Archivist main, BundleDescriptor descriptor, ReadableArchive in, WritableArchive out) throws IOException {
        this.writeStandardDeploymentDescriptors(main, descriptor, out);
        this.writeRuntimeDeploymentDescriptors(main, descriptor, in, out);
    }

    public void writeStandardDeploymentDescriptors(Archivist main, BundleDescriptor descriptor, WritableArchive out) throws IOException {
        this.getStandardDDFile(descriptor).setArchiveType(main.getModuleType());
        try (WritableArchiveEntry os = out.putNextEntry(this.standardDD.getDeploymentDescriptorPath());){
            this.standardDD.write((RootDeploymentDescriptor)descriptor, os);
        }
    }

    public void writeRuntimeDeploymentDescriptors(Archivist main, BundleDescriptor descriptor, ReadableArchive in, WritableArchive out) throws IOException {
        List<ConfigurationDeploymentDescriptorFile> confDDFilesToWrite = this.getSortedConfigurationDDFiles(descriptor, in, main.getModuleType());
        if (confDDFilesToWrite.isEmpty()) {
            confDDFilesToWrite = this.getConfigurationDDFiles(descriptor);
        }
        for (ConfigurationDeploymentDescriptorFile ddFile : confDDFilesToWrite) {
            ddFile.setArchiveType(main.getModuleType());
            WritableArchiveEntry os = out.putNextEntry(ddFile.getDeploymentDescriptorPath());
            try {
                ddFile.write(descriptor, os);
            }
            finally {
                if (os == null) continue;
                os.close();
            }
        }
    }

    private List<ConfigurationDeploymentDescriptorFile> getSortedConfigurationDDFiles(RootDeploymentDescriptor descriptor, ReadableArchive archive, ArchiveType archiveType) throws IOException {
        if (this.sortedConfDDFiles == null) {
            this.sortedConfDDFiles = DOLUtils.processConfigurationDDFiles(this.getConfigurationDDFiles(descriptor), archive, archiveType);
        }
        return this.sortedConfDDFiles;
    }
}

