/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.IOException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
public class DescriptorArchivist {
    @Inject
    private ArchivistFactory archivistFactory;
    @Inject
    private Provider<ApplicationArchivist> archivistProvider;

    public void write(Application application, ReadableArchive in, WritableArchive out) throws IOException {
        if (application.isVirtual()) {
            ModuleDescriptor<BundleDescriptor> aModule = application.getModules().iterator().next();
            Object moduleArchivist = this.archivistFactory.getArchivist(aModule.getModuleType());
            this.write(aModule.getDescriptor(), (Archivist<BundleDescriptor>)moduleArchivist, in, out);
        } else {
            for (ModuleDescriptor<BundleDescriptor> aModule : application.getModules()) {
                Object moduleArchivist = this.archivistFactory.getArchivist(aModule.getModuleType());
                WritableArchive moduleArchive = out.createSubArchive(aModule.getArchiveUri());
                try {
                    ReadableArchive moduleArchive2 = in.getSubArchive(aModule.getArchiveUri());
                    try {
                        this.write(aModule.getDescriptor(), (Archivist<BundleDescriptor>)moduleArchivist, moduleArchive2, moduleArchive);
                    }
                    finally {
                        if (moduleArchive2 == null) continue;
                        moduleArchive2.close();
                    }
                }
                finally {
                    if (moduleArchive == null) continue;
                    moduleArchive.close();
                }
            }
            ApplicationArchivist archivist = this.archivistProvider.get();
            archivist.setDescriptor(application);
            archivist.writeDeploymentDescriptors(in, out);
        }
    }

    protected void write(BundleDescriptor bundle2, Archivist<BundleDescriptor> archivist, ReadableArchive in, WritableArchive out) throws IOException {
        archivist.setDescriptor(bundle2);
        archivist.writeDeploymentDescriptors(in, out);
    }
}

