/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import java.util.Objects;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.security.common.Role;

public class MethodPermission
extends Descriptor {
    private static final long serialVersionUID = 1L;
    private static final MethodPermission PERMIT_ALL = new MethodPermission(true, false);
    private static final MethodPermission DENY_ALL = new MethodPermission(false, true);
    private boolean isUnchecked;
    private boolean isExcluded;
    private final Role role;

    public MethodPermission(Role role) {
        this.role = Objects.requireNonNull(role);
    }

    private MethodPermission(boolean unchecked, boolean excluded) {
        this.isUnchecked = unchecked;
        this.isExcluded = excluded;
        this.role = null;
    }

    public static MethodPermission getPermitAllMethodPermission() {
        return PERMIT_ALL;
    }

    public static MethodPermission getDenyAllMethodPermission() {
        return DENY_ALL;
    }

    public boolean isRoleBased() {
        return this.role != null;
    }

    public boolean isUnchecked() {
        return this.isUnchecked;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public Role getRole() {
        return this.role;
    }

    public int hashCode() {
        if (this.isRoleBased()) {
            return Objects.hashCode(this.role);
        }
        return Objects.hash(this.isExcluded, this.isUnchecked);
    }

    public boolean equals(Object other) {
        boolean ret = false;
        if (other instanceof MethodPermission) {
            MethodPermission o = (MethodPermission)other;
            ret = this.isRoleBased() ? this.role.equals(o.getRole()) : this.isExcluded == o.isExcluded() && this.isUnchecked == o.isUnchecked();
        }
        return ret;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        if (this.isRoleBased()) {
            toStringBuffer.append(this.role.toString());
        } else if (this.isExcluded) {
            toStringBuffer.append("DENY_ALL");
        } else if (this.isUnchecked) {
            toStringBuffer.append("PERMIT_ALL");
        }
    }
}

