/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import org.glassfish.api.naming.SimpleJndiName;

public final class EjbReferenceDescriptor
extends EnvironmentProperty
implements EjbReference,
NamedDescriptor {
    private static final long serialVersionUID = 1L;
    private static final int NULL_HASH_CODE = Integer.valueOf(1).hashCode();
    private EjbDescriptor ejbDescriptor;
    private BundleDescriptor referringBundle;
    private String refType;
    private String refHomeIntf;
    private String refIntf;
    private boolean isLocal;
    private String ejbLink;
    private SimpleJndiName lookupName;

    public EjbReferenceDescriptor(String name, String description, EjbDescriptor ejbDescriptor, boolean isLocal) {
        super(name, "", description);
        this.isLocal = isLocal;
        this.setEjbDescriptor(ejbDescriptor);
    }

    public EjbReferenceDescriptor() {
    }

    @Override
    public void setReferringBundleDescriptor(BundleDescriptor referringBundle) {
        this.referringBundle = referringBundle;
    }

    @Override
    public BundleDescriptor getReferringBundleDescriptor() {
        return this.referringBundle;
    }

    @Override
    public void setEjbDescriptor(EjbDescriptor ejbDescriptor) {
        this.ejbDescriptor = ejbDescriptor;
        if (ejbDescriptor != null) {
            if (this.isLocal()) {
                if (ejbDescriptor.isLocalInterfacesSupported() || ejbDescriptor.isLocalBusinessInterfacesSupported() || ejbDescriptor.isLocalBean()) {
                    return;
                }
                throw new RuntimeException(localStrings.getLocalString("entreprise.deployment.invalidLocalInterfaceReference", "Trying to set an ejb-local-ref on an EJB while the EJB [{0}] does not define local interfaces", ejbDescriptor.getName()));
            }
            if (ejbDescriptor.isRemoteInterfacesSupported() || ejbDescriptor.isRemoteBusinessInterfacesSupported()) {
                return;
            }
            throw new RuntimeException(localStrings.getLocalString("entreprise.deployment.invalidRemoteInterfaceReference", "Trying to set an ejb-ref on an EJB, while the EJB [{0}] does not define remote interfaces", ejbDescriptor.getName()));
        }
    }

    public boolean isLinked() {
        return this.ejbLink != null;
    }

    @Override
    public String getLinkName() {
        if (this.ejbDescriptor == null) {
            return this.ejbLink;
        }
        if (this.ejbLink != null && !this.ejbLink.isEmpty()) {
            return this.ejbLink;
        }
        return this.ejbDescriptor.getName();
    }

    @Override
    public void setLinkName(String linkName) {
        this.ejbLink = linkName;
    }

    @Override
    public SimpleJndiName getJndiName() {
        String jndiName = this.getValue();
        if (this.isLocal() || jndiName != null && !jndiName.isEmpty()) {
            return SimpleJndiName.of(jndiName);
        }
        return this.getMappedName();
    }

    @Override
    public void setJndiName(SimpleJndiName jndiName) {
        this.setValue(jndiName == null ? null : jndiName.toString());
    }

    @Override
    public boolean hasJndiName() {
        SimpleJndiName name = this.getJndiName();
        return name != null && !name.isEmpty();
    }

    @Override
    public String getValue() {
        if (this.ejbDescriptor == null) {
            return super.getValue();
        }
        if (this.isLocal()) {
            return super.getValue();
        }
        SimpleJndiName jndiName = this.ejbDescriptor.getJndiName();
        return jndiName == null ? null : jndiName.toString();
    }

    @Override
    public void setLookupName(SimpleJndiName l) {
        this.lookupName = l;
    }

    @Override
    public SimpleJndiName getLookupName() {
        return this.lookupName == null ? new SimpleJndiName("") : this.lookupName;
    }

    @Override
    public boolean hasLookupName() {
        return this.lookupName != null && !this.lookupName.isEmpty();
    }

    @Override
    public EjbDescriptor getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public void setLocal(boolean local) {
        this.isLocal = local;
    }

    @Override
    public String getType() {
        if (this.ejbDescriptor == null) {
            return this.refType;
        }
        return this.ejbDescriptor.getType();
    }

    @Override
    public void setType(String type2) {
        this.refType = type2;
    }

    @Override
    public String getInjectResourceType() {
        return this.isEJB30ClientView() ? this.getEjbInterface() : this.getEjbHomeInterface();
    }

    @Override
    public void setInjectResourceType(String resourceType) {
        if (this.isEJB30ClientView()) {
            this.setEjbInterface(resourceType);
        } else {
            this.setEjbHomeInterface(resourceType);
        }
    }

    public String getHomeClassName() {
        return this.refHomeIntf;
    }

    public void setHomeClassName(String homeClassName) {
        this.refHomeIntf = homeClassName;
    }

    public String getBeanClassName() {
        return this.refIntf;
    }

    public void setBeanClassName(String remoteClassName) {
        this.refIntf = remoteClassName;
    }

    @Override
    public String getEjbHomeInterface() {
        return this.getHomeClassName();
    }

    @Override
    public void setEjbHomeInterface(String homeClassName) {
        this.setHomeClassName(homeClassName);
    }

    @Override
    public String getEjbInterface() {
        return this.getBeanClassName();
    }

    @Override
    public void setEjbInterface(String remoteClassName) {
        this.setBeanClassName(remoteClassName);
    }

    @Override
    public boolean isEJB30ClientView() {
        return this.getHomeClassName() == null;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        String localVsRemote = this.isLocal() ? "Local" : "Remote";
        toStringBuffer.append(localVsRemote + " ejb-ref ");
        toStringBuffer.append("name=" + this.getName());
        if (this.isEJB30ClientView()) {
            toStringBuffer.append("," + localVsRemote + " 3.x interface =" + this.getEjbInterface());
        } else {
            toStringBuffer.append("," + localVsRemote + " 2.x home =" + this.getEjbHomeInterface());
            toStringBuffer.append("," + localVsRemote + " 2.x component interface=" + this.getEjbInterface());
        }
        if (this.ejbDescriptor != null) {
            toStringBuffer.append(" resolved to intra-app EJB " + this.ejbDescriptor.getName() + " in module " + this.ejbDescriptor.getEjbBundleDescriptor().getModuleName());
        }
        toStringBuffer.append(",ejb-link=" + this.getLinkName());
        toStringBuffer.append(",lookup=" + String.valueOf(this.getLookupName()));
        toStringBuffer.append(",mappedName=" + String.valueOf(this.getMappedName()));
        toStringBuffer.append(",jndi-name=" + this.getValue());
        toStringBuffer.append(",refType=" + this.getType());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof EjbReference) {
            EjbReference ejbReference = (EjbReference)object;
            return ejbReference.getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = NULL_HASH_CODE;
        String name = this.getName();
        if (name != null) {
            result += name.hashCode();
        }
        return result;
    }

    public boolean isConflict(EjbReferenceDescriptor other) {
        return this.getName().equals(other.getName()) && (!DOLUtils.equals(this.getType(), other.getType()) || !DOLUtils.equals(this.getEjbHomeInterface(), other.getEjbHomeInterface()) || !DOLUtils.equals(this.getEjbInterface(), other.getEjbInterface()) || !DOLUtils.equals(this.getLinkName(), other.getLinkName()) || this.isConflictResourceGroup(other));
    }
}

