/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.spi.ManagedBeanManager;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.annotations.Service;

@Service
@NamespacePrefixes(value={"java:app/", "java:module/", "java:app/AppName", "java:module/ModuleName", "java:app/hk2/ServiceLocator"})
public class JavaModuleNamingProxy
implements NamedNamingObjectProxy,
PostConstruct {
    static final String JAVA_APP_NAME = "java:app/AppName";
    static final String JAVA_MODULE_NAME = "java:module/ModuleName";
    static final String JAVA_APP_SERVICE_LOCATOR = "java:app/hk2/ServiceLocator";
    private static final Logger LOG = LogDomains.getLogger(JavaModuleNamingProxy.class, "jakarta.enterprise.system.core.naming", false);
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private ApplicationRegistry applicationRegistry;
    private ProcessEnvironment.ProcessType processType;
    private InitialContext ic;

    @Override
    public void postConstruct() {
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException ne) {
            throw new RuntimeException("JavaModuleNamingProxy InitialContext creation failure", ne);
        }
        this.processType = this.processEnv.getProcessType();
    }

    @Override
    public Object handle(String name) throws NamingException {
        if (JAVA_APP_NAME.equals(name)) {
            return this.getAppName();
        }
        if (JAVA_MODULE_NAME.equals(name)) {
            return this.getModuleName();
        }
        if (JAVA_APP_SERVICE_LOCATOR.equals(name)) {
            return this.getAppServiceLocator();
        }
        if (name.startsWith("java:module/") || name.startsWith("java:app/")) {
            return this.getJavaModuleOrAppEJB(name);
        }
        return null;
    }

    private String getAppName() throws NamingException {
        ComponentEnvManager namingMgr = this.habitat.getService(ComponentEnvManager.class, new Annotation[0]);
        String appName = null;
        if (namingMgr != null) {
            JndiNameEnvironment env = namingMgr.getCurrentJndiNameEnvironment();
            BundleDescriptor bd = null;
            if (env instanceof EjbDescriptor) {
                bd = ((EjbDescriptor)env).getEjbBundleDescriptor();
            } else if (env instanceof BundleDescriptor) {
                bd = (BundleDescriptor)((Object)env);
            }
            if (bd != null) {
                Application app = bd.getApplication();
                appName = app.getAppName();
            } else {
                ApplicationEnvironment applicationEnvironment = namingMgr.getCurrentApplicationEnvironment();
                if (applicationEnvironment != null) {
                    appName = applicationEnvironment.getName();
                }
            }
        }
        if (appName == null) {
            throw new NamingException("Could not resolve java:app/AppName");
        }
        return appName;
    }

    private String getModuleName() throws NamingException {
        ComponentEnvManager namingMgr = this.habitat.getService(ComponentEnvManager.class, new Annotation[0]);
        if (namingMgr == null) {
            throw new NamingException("Could not resolve java:module/ModuleName, ComponentEnvManager is null.");
        }
        JndiNameEnvironment env = namingMgr.getCurrentJndiNameEnvironment();
        BundleDescriptor bd = env instanceof EjbDescriptor ? ((EjbDescriptor)env).getEjbBundleDescriptor() : (env instanceof BundleDescriptor ? (BundleDescriptor)((Object)env) : null);
        if (bd == null) {
            throw new NamingException("Could not resolve java:module/ModuleName, descriptor is null.");
        }
        String moduleName = bd.getModuleDescriptor().getModuleName();
        if (moduleName == null) {
            throw new NamingException("Could not resolve java:module/ModuleName, descriptor's module name is null");
        }
        return moduleName;
    }

    private ServiceLocator getAppServiceLocator() throws NamingException {
        String appName = this.getAppName();
        ApplicationInfo info = this.applicationRegistry.get(appName);
        if (info == null) {
            throw new NamingException("Could not resolve java:app/hk2/ServiceLocator");
        }
        return info.getAppServiceLocator();
    }

    private Object getJavaModuleOrAppEJB(String name) {
        JndiNameEnvironment env;
        BundleDescriptor bd;
        ComponentEnvManager namingMgr;
        String newName = null;
        Object returnValue = null;
        if (this.habitat != null && (namingMgr = this.habitat.getService(ComponentEnvManager.class, new Annotation[0])) != null && (bd = (env = namingMgr.getCurrentJndiNameEnvironment()) instanceof EjbDescriptor ? ((EjbDescriptor)env).getEjbBundleDescriptor() : (env instanceof BundleDescriptor ? (BundleDescriptor)((Object)env) : null)) != null) {
            Application app = bd.getApplication();
            String appName = app.isVirtual() ? null : app.getAppName();
            StringBuilder javaGlobalName = new StringBuilder(32).append("java:global/");
            if (name.startsWith("java:app/")) {
                if (appName != null) {
                    javaGlobalName.append(appName);
                    javaGlobalName.append('/');
                }
                javaGlobalName.append(name.substring("java:app/".length()));
            } else {
                if (appName != null) {
                    javaGlobalName.append(appName);
                    javaGlobalName.append('/');
                }
                javaGlobalName.append(bd.getModuleDescriptor().getModuleName());
                javaGlobalName.append('/');
                javaGlobalName.append(name.substring("java:module/".length()));
            }
            newName = javaGlobalName.toString();
        }
        if (newName != null) {
            try {
                if (this.processType == ProcessEnvironment.ProcessType.ACC) {
                    ManagedBeanManager mbMgr = this.habitat.getService(ManagedBeanManager.class, new Annotation[0]);
                    try {
                        returnValue = mbMgr.getManagedBean(newName);
                    }
                    catch (Exception e) {
                        NamingException ne = new NamingException("Error creating ACC managed bean " + newName);
                        ne.initCause(e);
                        throw ne;
                    }
                }
                if (returnValue == null) {
                    returnValue = this.ic.lookup(newName);
                }
            }
            catch (NamingException ne) {
                LOG.log(Level.FINE, newName + " Unable to map " + name + " to derived name " + newName, ne);
            }
        }
        return returnValue;
    }
}

