/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.WorkManagerFactory;
import com.sun.enterprise.connectors.work.CommonWorkManager;
import com.sun.enterprise.connectors.work.LogFacade;
import com.sun.enterprise.connectors.work.WorkManagerProxy;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.resource.spi.work.WorkManager;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public final class WorkManagerFactoryImpl
implements WorkManagerFactory {
    private static final String DEFAULT = "com.sun.enterprise.connectors.work.CommonWorkManager";
    private static final String WORK_MANAGER_CLASS = "workmanager.class";
    private static final Logger logger = LogFacade.getLogger();
    private static final Map<String, WorkManager> workManagers = Collections.synchronizedMap(new HashMap());
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;
    private ConnectorRuntime runtime;
    @LogMessageInfo(message="An error occurred during instantiation of the Work Manager class [ {0} ] for resource adapter [ {1} ].", comment="Failed to create Work Manager instance.", level="SEVERE", cause="Can not initiate the Work Manager class.", action="Check the Work Manager class type.", publish=true)
    private static final String RAR_INIT_WORK_MANAGER_ERR = "AS-RAR-05003";

    @Override
    public WorkManager createWorkManager(String poolName, String raName, ClassLoader rarCL) {
        String className = null;
        String methodName = "getInstance";
        Class<?> cls = null;
        WorkManager wm = null;
        try {
            className = System.getProperty(WORK_MANAGER_CLASS, DEFAULT);
            if (className.equals(DEFAULT)) {
                return new CommonWorkManager(poolName, this.getConnectorRuntime(), raName, rarCL);
            }
            cls = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (cls != null) {
                Method method = cls.getMethod(methodName, new Class[0]);
                wm = (WorkManager)method.invoke(cls, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, RAR_INIT_WORK_MANAGER_ERR, new Object[]{className, raName, e});
        }
        return wm;
    }

    static void addWorkManager(String moduleName, WorkManager wm) {
        workManagers.put(moduleName, wm);
    }

    static WorkManager retrieveWorkManager(String moduleName) {
        return workManagers.get(moduleName);
    }

    @Override
    public boolean removeWorkManager(String moduleName) {
        boolean result = true;
        WorkManager wm = workManagers.remove(moduleName);
        if (wm == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Failed to remove workManager for RAR [ " + moduleName + " ] from registry.");
            }
            result = false;
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Removed the workManager for RAR [ " + moduleName + " ] from registry.");
            }
            if (wm instanceof CommonWorkManager) {
                ((CommonWorkManager)wm).cleanUp();
            }
        }
        return result;
    }

    @Override
    public WorkManager getWorkManagerProxy(String poolId, String moduleName, ClassLoader rarCL) throws ConnectorRuntimeException {
        WorkManager wm = WorkManagerFactoryImpl.retrieveWorkManager(moduleName);
        if (wm == null) {
            wm = this.createWorkManager(poolId, moduleName, rarCL);
            WorkManagerFactoryImpl.addWorkManager(moduleName, wm);
        }
        return new WorkManagerProxy(wm, moduleName);
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = this.connectorRuntimeProvider.get();
        }
        return this.runtime;
    }
}

