/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface AdminService
extends ConfigBeanProxy,
PropertyBag {
    public static final String PATTERN_TYPE = "(das|das-and-server|server)";

    @Attribute(defaultValue="server")
    @Pattern(regexp="(das|das-and-server|server)", message="Pattern: (das|das-and-server|server)")
    public @Pattern(regexp="(das|das-and-server|server)", message="Pattern: (das|das-and-server|server)") String getType();

    public void setType(String var1) throws PropertyVetoException;

    @Attribute
    public String getSystemJmxConnectorName();

    public void setSystemJmxConnectorName(String var1) throws PropertyVetoException;

    @Element(value="jmx-connector")
    public List<JmxConnector> getJmxConnector();

    @Element(value="das-config")
    @NotNull
    public DasConfig getDasConfig();

    public void setDasConfig(DasConfig var1) throws PropertyVetoException;

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @Attribute(defaultValue="admin-realm")
    @NotNull
    public String getAuthRealmName();

    public void setAuthRealmName(String var1);

    default public JmxConnector getSystemJmxConnector() {
        for (JmxConnector connector : this.getJmxConnector()) {
            if (!this.getSystemJmxConnectorName().equals(connector.getName())) continue;
            return connector;
        }
        return null;
    }

    default public AuthRealm getAssociatedAuthRealm() {
        String realmName = this.getAuthRealmName();
        Config config = this.getParent(Config.class);
        List<AuthRealm> realms = config.getSecurityService().getAuthRealm();
        for (AuthRealm realm : realms) {
            if (!realmName.equals(realm.getName())) continue;
            return realm;
        }
        return null;
    }

    default public boolean usesFileRealm() {
        boolean usesFileRealm = false;
        AuthRealm authRealm = this.getAssociatedAuthRealm();
        if (authRealm != null && "com.sun.enterprise.security.auth.realm.file.FileRealm".equals(authRealm.getClassname())) {
            usesFileRealm = true;
        }
        return usesFileRealm;
    }
}

