/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.parser;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.RankedConfigBeanProxy;
import com.sun.enterprise.config.modularity.annotation.HasNoDefaultConfiguration;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.parser.ConfigurationParser;
import com.sun.enterprise.module.bootstrap.StartupContext;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.List;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class ModuleConfigurationLoader<C extends ConfigBeanProxy, U extends ConfigBeanProxy> {
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ConfigurationParser configurationParser;
    @Inject
    private ConfigModularityUtils configModularityUtils;
    private C extensionOwner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U extends ConfigBeanProxy> U createConfigBeanForType(Class<U> configExtensionType, C extensionOwner) throws TransactionFailure {
        this.extensionOwner = extensionOwner;
        if (this.configModularityUtils.hasCustomConfig(configExtensionType)) {
            this.addConfigBeanFor(configExtensionType);
        } else {
            if (configExtensionType.getAnnotation(HasNoDefaultConfiguration.class) != null) {
                return null;
            }
            final Class<U> childElement = configExtensionType;
            ConfigModularityUtils configModularityUtils = this.configModularityUtils;
            synchronized (configModularityUtils) {
                boolean oldIP = this.configModularityUtils.isIgnorePersisting();
                try {
                    this.configModularityUtils.setIgnorePersisting(true);
                    ConfigSupport.apply(new SingleConfigCode<ConfigBeanProxy>(){

                        @Override
                        public Object run(ConfigBeanProxy parent) throws PropertyVetoException, TransactionFailure {
                            Object child = parent.createChild(childElement);
                            Dom unwrappedChild = Dom.unwrap(child);
                            unwrappedChild.addDefaultChildren();
                            ModuleConfigurationLoader.this.configModularityUtils.getExtensions(parent).add(child);
                            return child;
                        }
                    }, extensionOwner);
                }
                finally {
                    this.configModularityUtils.setIgnorePersisting(oldIP);
                }
            }
        }
        return this.getExtension(configExtensionType, extensionOwner);
    }

    private <U extends ConfigBeanProxy> U getExtension(Class<U> configExtensionType, C extensionOwner) {
        List extensions = this.configModularityUtils.getExtensions((ConfigBeanProxy)extensionOwner);
        for (ConfigBeanProxy extension : extensions) {
            try {
                ConfigBeanProxy configBeanInstance = (ConfigBeanProxy)configExtensionType.cast(extension);
                if (configBeanInstance instanceof ConfigExtension) {
                    ServiceLocatorUtilities.addOneDescriptor(this.serviceLocator, BuilderHelper.createConstantDescriptor(configBeanInstance, "default-instance-name", ConfigSupport.getImpl(configBeanInstance).getProxyType()));
                }
                return (U)configBeanInstance;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    protected <U extends ConfigBeanProxy> void addConfigBeanFor(Class<U> extensionType) {
        if (!RankedConfigBeanProxy.class.isAssignableFrom(extensionType) && this.getExtension(extensionType, this.extensionOwner) != null) {
            return;
        }
        StartupContext context = this.serviceLocator.getService(StartupContext.class, new Annotation[0]);
        List<ConfigBeanDefaultValue> configBeanDefaultValueList = this.configModularityUtils.getDefaultConfigurations(extensionType, this.configModularityUtils.getRuntimeTypePrefix(context));
        this.configurationParser.parseAndSetConfigBean(configBeanDefaultValueList);
    }
}

