/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.PlatformServicesInfo;
import com.sun.enterprise.admin.servermgmt.services.ServiceFactory;
import com.sun.enterprise.admin.util.ServerDirsSelector;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="create-service")
@PerLookup
public final class CreateServiceCommand
extends CLICommand {
    @Param(name="name", optional=true)
    private String serviceName;
    @Param(name="serviceproperties", optional=true)
    private String serviceProperties;
    @Param(name="dry-run", shortName="n", optional=true, defaultValue="false")
    private boolean dry_run;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Param(name="domaindir", optional=true)
    private File userSpecifiedDomainDirParent;
    @Param(name="serviceuser", optional=true)
    private String serviceUser;
    @Param(name="domain_or_instance_name", primary=true, optional=true, alias="domain_name")
    private String userSpecifiedServerName;
    @Param(name="nodedir", optional=true, alias="agentdir")
    private String userSpecifiedNodeDir;
    @Param(name="node", optional=true, alias="nodeagent")
    private String userSpecifiedNode;
    private File asadminScript;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateServiceCommand.class);
    private ServerDirs dirs;
    private ServerDirsSelector selector = null;

    @Override
    protected void validate() throws CommandException {
        try {
            super.validate();
            if (CreateServiceCommand.ok(this.serviceUser) && !OS.isLinux()) {
                throw new CommandException(strings.get("serviceUser_wrong_os"));
            }
            this.selector = ServerDirsSelector.getInstance(this.userSpecifiedDomainDirParent, this.userSpecifiedServerName, this.userSpecifiedNodeDir, this.userSpecifiedNode);
            this.dirs = this.selector.dirs();
            this.validateServiceName();
            this.validateAsadmin();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), e);
        }
    }

    @Override
    protected int executeCommand() throws CommandException {
        try {
            com.sun.enterprise.admin.servermgmt.services.Service service = ServiceFactory.getService(this.dirs, this.getType());
            PlatformServicesInfo info = service.getInfo();
            info.setTrace(logger.isLoggable(Level.FINER));
            info.setDryRun(this.dry_run);
            info.setForce(this.force);
            info.setAppServerUser(this.getProgramOptions().getUser());
            if (CreateServiceCommand.ok(this.serviceName)) {
                info.setServiceName(this.serviceName);
            }
            if (CreateServiceCommand.ok(this.serviceUser)) {
                info.setServiceUser(this.serviceUser);
            }
            if (this.programOpts.getPasswordFile() != null) {
                info.setPasswordFile(SmartFile.sanitize(new File(this.programOpts.getPasswordFile())));
            }
            service.setServiceProperties(this.serviceProperties);
            service.createService();
            String help = service.getSuccessMessage();
            String tellUserAboutHelp = strings.get("create.service.runtimeHelp", help, new File(this.dirs.getServerDir(), "PlatformServices.log"));
            logger.info(tellUserAboutHelp);
            service.writeReadmeFile(help);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (CreateServiceCommand.ok(msg)) {
                throw new CommandException(msg);
            }
            throw new CommandException(e);
        }
        return 0;
    }

    private void validateServiceName() throws CommandException {
        if (!CreateServiceCommand.ok(this.serviceName)) {
            this.serviceName = this.dirs.getServerDir().getName();
        }
        if (OS.isWindowsForSure() && !FileUtils.isFriendlyFilename(this.serviceName)) {
            throw new CommandException(strings.get("create.service.badServiceName", this.serviceName));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("service name = " + this.serviceName);
        }
    }

    private void validateAsadmin() throws CommandException {
        String s = SystemPropertyConstants.getAsAdminScriptLocation();
        if (!CreateServiceCommand.ok(s)) {
            throw new CommandException(strings.get("internal.error", "Can't get Asadmin script location"));
        }
        this.asadminScript = SmartFile.sanitize(new File(s));
        if (!this.asadminScript.isFile()) {
            throw new CommandException(strings.get("create.service.noAsadminScript", this.asadminScript));
        }
    }

    private AppserverServiceType getType() {
        if (this.selector.isInstance()) {
            return AppserverServiceType.Instance;
        }
        return AppserverServiceType.Domain;
    }
}

