/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.servermgmt.NodeKeystoreManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_change-master-password-node")
@PerLookup
public class ChangeNodeMasterPasswordCommand
extends LocalInstanceCommand {
    @Param(name="nodedir", optional=true)
    protected String nodeDir0;
    @Param(name="node", primary=true)
    protected String node0;
    @Param(name="savemasterpassword", optional=true, defaultValue="false")
    protected boolean savemp;
    private static final String MASTER_PASSWORD_ALIAS = "master-password";
    private static final LocalStringsImpl strings = new LocalStringsImpl(ChangeNodeMasterPasswordCommand.class);
    private String newPassword;
    private String oldPassword;

    @Override
    protected int executeCommand() throws CommandException {
        try {
            this.nodeDir = this.nodeDir0;
            this.node = this.node0;
            File serverDir = new File(this.nodeDir, this.node);
            if (!serverDir.isDirectory()) {
                throw new CommandException(strings.get("bad.node.dir", serverDir));
            }
            ArrayList<String> serverNames = this.getInstanceDirs(serverDir);
            for (String string : serverNames) {
                if (!this.isRunning(serverDir, string)) continue;
                throw new CommandException(strings.get("instance.is.running", string));
            }
            this.oldPassword = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD");
            if (this.oldPassword == null) {
                char[] opArr = super.readPassword(strings.get("old.mp"));
                String string = this.oldPassword = opArr != null ? new String(opArr) : null;
            }
            if (this.oldPassword == null) {
                throw new CommandException(strings.get("no.console"));
            }
            boolean valid = true;
            for (String instanceDir0 : this.getInstanceDirs(this.nodeDirChild)) {
                valid &= this.verifyInstancePassword(new File(this.nodeDirChild, instanceDir0));
            }
            if (!valid) {
                throw new CommandException(strings.get("incorrect.old.mp"));
            }
            CommandModelData.ParamModelData paramModelData = new CommandModelData.ParamModelData("AS_ADMIN_NEWMASTERPASSWORD", String.class, false, null);
            paramModelData.prompt = strings.get("new.mp");
            paramModelData.promptAgain = strings.get("new.mp.again");
            paramModelData.param._password = true;
            char[] npArr = super.getPassword(paramModelData, null, true);
            this.newPassword = npArr != null ? new String(npArr) : null;
            for (String instanceDir2 : this.getInstanceDirs(this.nodeDirChild)) {
                this.encryptKeystore(instanceDir2);
            }
            if (this.savemp) {
                this.createMasterPasswordFile();
            }
            return 0;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), e);
        }
    }

    private boolean verifyInstancePassword(File instanceDir) {
        File mp = new File(new File(instanceDir, "config"), "cacerts.jks");
        return this.loadAndVerifyKeystore(mp, this.oldPassword);
    }

    @Override
    public int execute(String ... argv) throws CommandException {
        this.checkOneAndOnly = false;
        return super.execute(argv);
    }

    protected void createMasterPasswordFile() throws CommandException {
        File pwdFile = new File(this.getServerDirs().getAgentDir(), MASTER_PASSWORD_ALIAS);
        try {
            PasswordAdapter p = new PasswordAdapter(pwdFile.getAbsolutePath(), MASTER_PASSWORD_ALIAS.toCharArray());
            p.setPasswordForAlias(MASTER_PASSWORD_ALIAS, this.newPassword.getBytes());
            pwdFile.setReadable(true);
            pwdFile.setWritable(true);
        }
        catch (Exception ex) {
            throw new CommandException(strings.get("masterPasswordFileNotCreated", pwdFile), ex);
        }
    }

    public void encryptKeystore(String f) throws CommandException {
        RepositoryConfig nodeConfig = new RepositoryConfig(f, new File(this.nodeDir, this.node).toString(), f);
        NodeKeystoreManager km = new NodeKeystoreManager();
        try {
            km.encryptKeystore(nodeConfig, this.oldPassword, this.newPassword);
        }
        catch (Exception e) {
            throw new CommandException(strings.get("Keystore.not.encrypted"), e);
        }
    }

    private ArrayList<String> getInstanceDirs(File parent) throws CommandException {
        ArrayList<String> instancesList = new ArrayList<String>();
        File[] files = parent.listFiles(File::isDirectory);
        if (files == null || files.length == 0) {
            throw new CommandException(strings.get("Instance.noInstanceDirs", parent));
        }
        for (File f : files) {
            if (f.getName().equals("agent")) continue;
            instancesList.add(f.getName());
        }
        return instancesList;
    }

    private boolean isRunning(File nodeDirChild, String serverName) throws CommandException {
        try {
            File serverDir = new File(nodeDirChild, serverName);
            File configDir = new File(serverDir, "config");
            File domainXml = new File(configDir, "domain.xml");
            if (!domainXml.exists()) {
                return false;
            }
            MiniXmlParser parser = new MiniXmlParser(domainXml, serverName);
            List<HostAndPort> addrSet = parser.getAdminAddresses();
            if (addrSet.isEmpty()) {
                throw new CommandException(strings.get("NoAdminPort"));
            }
            HostAndPort addr = addrSet.get(0);
            return ProcessUtils.isListening(addr);
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException(strings.get("NoAdminPortEx", ex), ex);
        }
    }
}

