/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KDF;
import java.util.Map;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

public class Argon2
implements KDF {
    private Argon2BytesGenerator generator;

    @Override
    public void initWithPPKv3Header(Map<String, String> header) throws Exception {
        try {
            int type2;
            String argonTypeStr = header.get("Key-Derivation");
            String saltStr = header.get("Argon2-Salt");
            if (argonTypeStr == null || saltStr == null || saltStr != null && saltStr.length() % 2 != 0) {
                throw new JSchException("Invalid argon2 params.");
            }
            switch (argonTypeStr) {
                case "Argon2d": {
                    type2 = 0;
                    break;
                }
                case "Argon2i": {
                    type2 = 1;
                    break;
                }
                case "Argon2id": {
                    type2 = 2;
                    break;
                }
                default: {
                    throw new JSchException("Invalid argon2 params.");
                }
            }
            int memory = Integer.parseInt(header.get("Argon2-Memory"));
            int passes = Integer.parseInt(header.get("Argon2-Passes"));
            int parallelism = Integer.parseInt(header.get("Argon2-Parallelism"));
            byte[] salt = new byte[saltStr.length() / 2];
            for (int i = 0; i < salt.length; ++i) {
                int j = i * 2;
                salt[i] = (byte)Integer.parseInt(saltStr.substring(j, j + 2), 16);
            }
            Argon2Parameters params = new Argon2Parameters.Builder(type2).withSalt(salt).withAdditional(new byte[0]).withSecret(new byte[0]).withIterations(passes).withMemoryAsKB(memory).withParallelism(parallelism).withVersion(19).build();
            this.generator = new Argon2BytesGenerator();
            this.generator.init(params);
        }
        catch (NumberFormatException e) {
            throw new JSchException("Invalid argon2 params.", e);
        }
    }

    @Override
    public byte[] getKey(byte[] pass, int size) {
        byte[] key = new byte[size];
        this.generator.generateBytes(pass, key);
        return key;
    }
}

