/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.XMLUtil;
import org.netbeans.modules.schema2beansdev.DataEnumRestriction;
import org.netbeans.modules.schema2beansdev.DataTypeRestriction;
import org.netbeans.modules.schema2beansdev.PrefixGuesser;
import org.netbeans.modules.schema2beansdev.gen.JavaUtil;
import org.netbeans.modules.schema2beansdev.gen.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaRep
implements PrefixGuesser {
    public static boolean debug = false;
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    private static Map schemaValidSubElementTypeMap = null;
    private static Map complexTypeValidSubElementTypeMap;
    private static Map simpleContentValidSubElementTypeMap;
    private static Map complexContentValidSubElementTypeMap;
    private static Map simpleTypeValidSubElementTypeMap;
    private static Map unionTypeValidSubElementTypeMap;
    private static Map restrictionValidSubElementTypeMap;
    private static Map extensionValidSubElementTypeMap;
    private static Map listValidSubElementTypeMap;
    private static Map restrictionTypeValidSubElementTypeMap;
    private static Map keyValidSubElementTypeMap;
    private static Map uniqueValidSubElementTypeMap;
    private static Map keyrefValidSubElementTypeMap;
    private static Map selectorValidSubElementTypeMap;
    private static Map fieldValidSubElementTypeMap;
    private static Map sequenceValidSubElementTypeMap;
    private static Map choiceValidSubElementTypeMap;
    private static Map allValidSubElementTypeMap;
    private static Map groupValidSubElementTypeMap;
    private static Map annotationValidSubElementTypeMap;
    private static Map appInfoValidSubElementTypeMap;
    private static Map documentationValidSubElementTypeMap;
    private static Map anyNodeValidSubElementTypeMap;
    private static Map textNodeValidSubElementTypeMap;
    private static Map elementValidSubElementTypeMap;
    private static Map anyValidSubElementTypeMap;
    private static Map anyAttributeValidSubElementTypeMap;
    private static Map attributeValidSubElementTypeMap;
    private static Map attributeGroupValidSubElementTypeMap;
    protected Map namespaceTable;
    protected String targetNamespace;
    protected String documentNamespace;
    private boolean elementFormQualifiedDefault;
    private boolean attributeFormQualifiedDefault;
    protected ContainsSubElements rootElement;
    protected Map elementTable;
    protected Map optionallyDefinedTypes = null;
    protected Map definedTypes;
    protected Map definedTypesFull;
    protected Map definedAttributes;
    protected Map predefinedSchemaTypes;
    protected Map requiredPredefinedTypes;
    protected Stack currentElementStack;
    protected Annotation topAnnotation;
    protected ElementExpr lastPopped;
    protected Map sampleNodes;
    private Map schemaTypeDefs;
    protected Map includedAlready = new HashMap();
    private String currentParsedURI;
    private boolean useBigDataTypes = true;

    public SchemaRep() {
        this.init();
    }

    public SchemaRep(Document schemaDoc, String uri) {
        this.init();
        this.currentParsedURI = uri;
        this.readDocument(schemaDoc);
    }

    public SchemaRep(Document schemaDoc, String uri, boolean useBigDataTypes) {
        this.useBigDataTypes = useBigDataTypes;
        this.init();
        this.currentParsedURI = uri;
        this.readDocument(schemaDoc);
    }

    private void init() {
        this.targetNamespace = null;
        this.documentNamespace = null;
        this.namespaceTable = new HashMap();
        this.addToNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.addToNamespace("xsd", XSD_NS);
        this.schemaTypeDefs = new HashMap();
        this.predefinedSchemaTypes = new HashMap();
        this.insertPredefinedSchemaTypes(this.predefinedSchemaTypes);
        this.currentElementStack = new Stack();
        this.topAnnotation = null;
        this.definedTypes = new HashMap();
        this.definedTypesFull = new HashMap();
        this.definedAttributes = new HashMap();
        this.mapSimpleAttributes(this.definedAttributes);
        this.requiredPredefinedTypes = new HashMap();
        if (this.optionallyDefinedTypes == null) {
            this.optionallyDefinedTypes = new HashMap();
            this.mapSimpleJavaTypesOptional(this.optionallyDefinedTypes);
        }
        this.sampleNodes = new HashMap();
        this.putSampleNode(new Element("dummy"));
        this.putSampleNode(new ComplexType());
        this.putSampleNode(new SimpleType(null));
        this.putSampleNode(new UnionType(null, null));
        this.putSampleNode(new Restriction());
        this.putSampleNode(new Sequence());
        this.putSampleNode(new Choice());
        this.putSampleNode(new All());
        this.putSampleNode(new Group());
        this.putSampleNode(new Annotation());
        this.putSampleNode(new AppInfo());
        this.putSampleNode(new Documentation());
        this.putSampleNode(new Attribute("dummy"));
        this.putSampleNode(new AttributeGroup());
        this.putSampleNode(new MaxExclusive("dummy"));
        this.putSampleNode(new MinExclusive("dummy"));
        this.putSampleNode(new Enumeration("dummy"));
        this.putSampleNode(new Pattern("dummy"));
        this.putSampleNode(new MinLength("0"));
        this.putSampleNode(new MaxLength("0"));
        this.putSampleNode(new TotalDigits("dummy"));
        this.putSampleNode(new MinInclusive("dummy"));
        this.putSampleNode(new MaxInclusive("dummy"));
        this.putSampleNode(new FractionDigits("dummy"));
        this.putSampleNode(new Length("dummy"));
        this.putSampleNode(new WhiteSpace("dummy"));
        this.putSampleNode(new Key());
        this.putSampleNode(new Unique());
        this.putSampleNode(new KeyRef());
        this.putSampleNode(new Selector());
        this.putSampleNode(new Field());
        this.putSampleNode(new Include("dummy"));
        this.putSampleNode(new Import());
        this.putSampleNode(new SimpleContent());
        this.putSampleNode(new ComplexContent());
        this.putSampleNode(new Extension());
        this.putSampleNode(new ListElement());
        this.putSampleNode(new Any());
        this.putSampleNode(new AnyAttribute());
    }

    public void addToNamespace(String ns, String URI2) {
        this.namespaceTable.put(ns, URI2);
    }

    public String getNamespaceURI(String ns) {
        return (String)this.namespaceTable.get(ns);
    }

    public String getNamespace(String URI2) {
        String ns2;
        for (String ns2 : this.namespaceTable.keySet()) {
            if (!URI2.equals(this.namespaceTable.get(ns2))) continue;
            return ns2;
        }
        String baseNs = ns2 = SchemaRep.guessPrefix(URI2);
        int count = 2;
        while (this.namespaceTable.containsKey(ns2)) {
            ns2 = baseNs + count;
            ++count;
        }
        this.namespaceTable.put(ns2, URI2);
        return ns2;
    }

    public Set getAllNamespaces() {
        return this.namespaceTable.keySet();
    }

    public String getXSDNamespace() {
        String ns = this.getNamespace(XSD_NS);
        if (ns == null) {
            return "xsd";
        }
        return ns;
    }

    public String getXMLNamespace() {
        String ns = this.getNamespace("http://www.w3.org/XML/1998/namespace");
        if (ns == null) {
            return "xml";
        }
        return ns;
    }

    public Attribute getAttribute(String name) {
        if (name == null) {
            return null;
        }
        String ns = SchemaRep.prefixOf(name);
        Attribute result = (Attribute)this.definedAttributes.get(name = ns == null ? this.resolveNamespace(this.documentNamespace, SchemaRep.removePrefix(name)) : this.resolveNamespace(ns, SchemaRep.removePrefix(name)));
        if (result == null && ns == null) {
            name = this.resolveNamespace(this.targetNamespace, name);
            result = (Attribute)this.definedAttributes.get(name);
        }
        return result;
    }

    protected void putSampleNode(ElementExpr ee) {
        this.sampleNodes.put(ee.getName(), ee);
    }

    protected ElementExpr getSampleNode(String name) {
        return (ElementExpr)this.sampleNodes.get(name);
    }

    public void setTargetNamespace(String ns) {
        this.targetNamespace = ns;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setCurrentParsedURI(String uri) {
        this.currentParsedURI = uri;
    }

    protected String getCurrentParsedURI() {
        return this.currentParsedURI;
    }

    public void setRootElement(ContainsSubElements el) {
        if (debug) {
            System.out.println("Changing rootElement of " + this + " to " + el);
        }
        this.rootElement = el;
    }

    public ContainsSubElements getRootElement() {
        return this.rootElement;
    }

    public void addToTopAnnotation(ElementExpr subElement) {
        if (this.topAnnotation == null) {
            this.topAnnotation = new Annotation();
        }
        this.topAnnotation.addSubElement(subElement);
    }

    public void addAppInfoToTopAnnotation(String name, String value) {
        AppInfo ai = new AppInfo();
        AnyNode ue = new AnyNode(name, value);
        ai.addSubElement(ue);
        this.addToTopAnnotation(ai);
    }

    public void pushCurrent(ElementExpr el) {
        if (this.currentElementStack.empty()) {
            this.setRootElement((ContainsSubElements)el);
        } else {
            this.peekCurrentNeedSub().addSubElement(el);
        }
        this.currentElementStack.push(el);
    }

    public void pushElement(String elementName, String elementType) {
        this.pushCurrent(this.createElement(elementName, elementType));
    }

    public void pushSchemaNode() {
        this.pushCurrent(new SchemaNode());
    }

    public void pushComplexType() {
        this.pushCurrent(new ComplexType());
    }

    public void pushSequence() {
        this.pushCurrent(new Sequence());
    }

    public ElementExpr popCurrent() {
        this.lastPopped = (ElementExpr)this.currentElementStack.pop();
        return this.lastPopped;
    }

    public ElementExpr peekCurrent() {
        return (ElementExpr)this.currentElementStack.peek();
    }

    private ElementExpr findAncestor(Class type2) {
        for (int i = this.currentElementStack.size() - 1; i >= 0; --i) {
            ElementExpr ee = (ElementExpr)this.currentElementStack.get(i);
            if (!type2.isAssignableFrom(ee.getClass())) continue;
            return ee;
        }
        return null;
    }

    public ContainsSubElements peekCurrentNeedSub() {
        if (!(this.currentElementStack.peek() instanceof ContainsSubElements)) {
            throw new ClassCastException("Expected ContainsSubElements, but got " + this.currentElementStack.peek().getClass() + " instead on object " + this.currentElementStack.peek());
        }
        return (ContainsSubElements)this.currentElementStack.peek();
    }

    public ElementExpr getLastPopped() {
        return this.lastPopped;
    }

    public void addElement(String name, String type2) {
        Element el = this.createElement(name);
        el.setType(type2);
        if (this.currentElementStack.empty()) {
            this.setRootElement(el);
        } else {
            this.peekCurrentNeedSub().addSubElement(el);
        }
    }

    public void addAppInfo(String name, String value) {
        ElementExpr e = this.peekCurrent();
        Annotation ann = e instanceof Annotation ? (Annotation)e : new Annotation();
        AppInfo ai = new AppInfo();
        AnyNode ue = new AnyNode(name, value);
        ai.addSubElement(ue);
        ann.addSubElement(ai);
        this.peekCurrentNeedSub().addSubElement(ann);
    }

    public void setType(String t) {
        ElementExpr e = this.peekCurrent();
        if (!(e instanceof Element)) {
            throw new IllegalStateException(Common.getMessage("MSG_TryingToCallOnWrongClass", "setType", e.getClass()));
        }
        ((Element)e).setType(t);
    }

    public List findAllSubElements(String name) {
        LinkedList lst = new LinkedList();
        this.rootElement.findAllSubElements(name, lst);
        return lst;
    }

    public void setXMLSchemaType(String t) {
        ElementExpr e = this.peekCurrent();
        if (!(e instanceof Element)) {
            throw new IllegalStateException(Common.getMessage("MSG_TryingToCallOnWrongClass", "setXMLSchemaType", e.getClass()));
        }
        ((Element)e).setXMLSchemaType(t);
    }

    public void setMinOccurs(String t) {
        ElementExpr e = this.peekCurrent();
        if (e instanceof Element) {
            ((Element)e).setMinOccurs(t);
        } else if (e instanceof ModelGroup) {
            ((ModelGroup)e).setMinOccurs(t);
        } else {
            throw new IllegalStateException(Common.getMessage("MSG_TryingToCallOnWrongClass", "setMinOccurs", e.getClass()));
        }
    }

    public void setMaxOccurs(String t) {
        ElementExpr e = this.peekCurrent();
        if (e instanceof Element) {
            ((Element)e).setMaxOccurs(t);
        } else if (e instanceof ModelGroup) {
            ((ModelGroup)e).setMaxOccurs(t);
        } else {
            throw new IllegalStateException(Common.getMessage("MSG_TryingToCallOnWrongClass", "setMaxOccurs", e.getClass()));
        }
    }

    public Element createElement(String name) {
        Element el = new Element(name);
        return el;
    }

    public Element createElement(String name, String type2) {
        Element el = new Element(name);
        el.setType(type2);
        return el;
    }

    public void addSubElement(String elementName, ElementExpr subElement) {
        Element el = this.createElement(elementName);
        el.addSubElement(subElement);
    }

    public void addSubElement(String elementName, List subElements) {
        Element el = this.createElement(elementName);
        el.addSubElement(subElements);
    }

    public void addSubElement(String elementName, String subElementName) {
        Element subElement = this.createElement(subElementName);
        this.addSubElement(elementName, subElement);
    }

    public void addSubElementCurrent(String subElementName) {
        Element subElement = this.createElement(subElementName);
        this.peekCurrentNeedSub().addSubElement(subElement);
    }

    public ElementExpr optimize() {
        if (this.rootElement == null) {
            return null;
        }
        return this.rootElement.optimize();
    }

    public void writeDTD(Writer out) throws IOException {
        if (this.rootElement == null) {
            return;
        }
        this.elementTable = new HashMap();
        this.optimize();
        this.rootElement.validate();
        StringBuffer outBuffer = new StringBuffer();
        this.rootElement.writeDTD(outBuffer);
        out.write(outBuffer.toString());
        this.elementTable = null;
    }

    public void writeXMLSchemaStandalone(Writer out) throws IOException {
        if (this.rootElement == null) {
            return;
        }
        XMLWriter xw = new XMLWriter();
        ContainsSubElements realRootElement = this.rootElement;
        if (!(realRootElement instanceof SchemaNode)) {
            SchemaNode sn = new SchemaNode();
            sn.addSubElement(realRootElement);
            realRootElement = sn;
            if (this.topAnnotation != null) {
                sn.addSubElement(this.topAnnotation);
            }
        }
        realRootElement.validate();
        realRootElement.writeXMLSchema(xw);
        xw.writeTo(out);
    }

    public void writeXMLSchema(XMLWriter out) throws IOException {
        if (this.rootElement == null) {
            return;
        }
        this.rootElement.writeXMLSchema(out);
    }

    public void readSchemaFromLocation(String schemaLocation, boolean include) throws IOException, SAXException {
        if (debug) {
            System.out.println("Reading schema from " + schemaLocation);
        }
        if (schemaLocation == null || "".equals(schemaLocation)) {
            return;
        }
        String oldParsedURI = this.currentParsedURI;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = null;
            FileNotFoundException ioException = null;
            SAXParseException saxException = null;
            try {
                doc = db.parse(schemaLocation);
                this.currentParsedURI = schemaLocation;
            }
            catch (FileNotFoundException e) {
                ioException = e;
            }
            catch (SAXParseException e) {
                saxException = e;
            }
            if ((ioException != null || saxException != null) && this.currentParsedURI != null) {
                URI uri;
                try {
                    uri = new URI(this.currentParsedURI);
                }
                catch (URISyntaxException e) {
                    uri = new File(this.currentParsedURI).toURI();
                }
                if (debug) {
                    System.out.println("uri=" + uri);
                }
                URI schemaLocationURI = uri.resolve(schemaLocation);
                this.currentParsedURI = schemaLocationURI.toString();
                if (debug) {
                    System.out.println("Since the first try failed, now trying to read currentParsedURI:" + this.currentParsedURI);
                }
                doc = db.parse(this.currentParsedURI);
                ioException = null;
                saxException = null;
            }
            if (ioException != null) {
                throw ioException;
            }
            if (saxException != null) {
                throw saxException;
            }
            org.w3c.dom.Element childNode = doc.getDocumentElement();
            if (childNode != null) {
                if (!childNode.getLocalName().equals("schema")) {
                    throw new IllegalStateException(Common.getMessage("MSG_ExpectedNode", "schema", childNode.getNodeName()));
                }
                this.readSchemaElement(childNode, include);
            }
        }
        catch (ParserConfigurationException e) {
            throw new Schema2BeansRuntimeException(Common.getMessage("MSG_FailedToParse", schemaLocation), e);
        }
        finally {
            this.currentParsedURI = oldParsedURI;
        }
    }

    public void readDocument(Document doc) {
        this.includedAlready.clear();
        org.w3c.dom.Element childNode = doc.getDocumentElement();
        if (childNode != null) {
            if (!childNode.getLocalName().equals("schema")) {
                throw new IllegalStateException(Common.getMessage("MSG_ExpectedNode", "schema", childNode.getNodeName()));
            }
            this.pushSchemaNode();
            this.peekCurrentNeedSub().readSchema(childNode);
            this.readSchemaElement(childNode, false);
            this.popCurrent();
        }
    }

    public void readSchemaElement(org.w3c.dom.Element el, boolean include) {
        ContainsSubElements re;
        NamedNodeMap attrs = el.getAttributes();
        String theTargetNamespace = null;
        String theDocumentNamespaceURI = null;
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            Node attr = attrs.item(i);
            if ("xmlns".equals(attr.getPrefix())) {
                this.addToNamespace(attr.getLocalName(), attr.getNodeValue());
                continue;
            }
            if ("targetNamespace".equals(attr.getNodeName())) {
                theTargetNamespace = attr.getNodeValue();
                continue;
            }
            if (!"xmlns".equals(attr.getNodeName())) continue;
            theDocumentNamespaceURI = attr.getNodeValue();
        }
        if (theDocumentNamespaceURI != null) {
            this.documentNamespace = theDocumentNamespaceURI;
        }
        if (theTargetNamespace != null) {
            this.targetNamespace = theTargetNamespace;
        }
        if (include && theDocumentNamespaceURI == null && theTargetNamespace == null && this.targetNamespace != null) {
            this.documentNamespace = this.targetNamespace;
        }
        if ((re = this.getRootElement()) instanceof SchemaNode) {
            SchemaNode schemaNode = (SchemaNode)re;
            schemaNode.merge(el);
        }
        this.read(el);
    }

    protected void read(Node node) {
        boolean ignoreUnknown = false;
        boolean keepText = false;
        if (this.peekCurrent() instanceof AnyNode || this.peekCurrent() instanceof Documentation || this.peekCurrent() instanceof AppInfo || this.peekCurrent() instanceof TextNode) {
            keepText = true;
            ignoreUnknown = true;
        }
        AnyNode anyNode = new AnyNode("dummy1", "dummy2");
        TextNode textNode = new TextNode("dummy");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childNode = children.item(i);
            if (childNode instanceof org.w3c.dom.Element) {
                org.w3c.dom.Element childElement = (org.w3c.dom.Element)childNode;
                String nodeName = childElement.getLocalName().intern();
                ElementExpr ee = this.getSampleNode(nodeName);
                if (ee == null) {
                    if (!ignoreUnknown) {
                        System.out.println("SchemaRep Warning: unknown node at " + SchemaRep.getXPathExpr(childElement));
                    }
                    anyNode.readSchema(childElement);
                    continue;
                }
                ee.readSchema(childElement);
                continue;
            }
            if (!keepText || !(childNode instanceof Text)) continue;
            textNode.readSchema((Text)childNode);
        }
    }

    public static String getXPathExpr(Node node) {
        return SchemaRep.getXPathExpr(node, true);
    }

    public static String getXPathExpr(Node node, boolean addDescription) {
        String nameAttr;
        if (node instanceof Document) {
            return "/";
        }
        Node parentNode = node.getParentNode();
        if (parentNode instanceof Document) {
            return "/" + node.getNodeName();
        }
        String curNodeName = node.getNodeName();
        if (addDescription && node instanceof org.w3c.dom.Element && (nameAttr = ((org.w3c.dom.Element)node).getAttribute("name")) != null && !"".equals(nameAttr)) {
            curNodeName = curNodeName + " name='" + nameAttr + "'";
        }
        return SchemaRep.getXPathExpr(node.getParentNode(), addDescription) + "/" + curNodeName;
    }

    public String schemaTypeToJavaType(String xmlSchemaType) {
        ElementExpr schemaTypeDef = this.getSchemaTypeDef(xmlSchemaType);
        if (schemaTypeDef == null) {
            System.out.println(Common.getMessage("MSG_UnableToFindTypeDef", xmlSchemaType));
            return null;
        }
        String javaType = null;
        if (schemaTypeDef instanceof HasJavaTypeName) {
            javaType = ((HasJavaTypeName)((Object)schemaTypeDef)).getJavaTypeName();
        } else {
            System.out.println("!!! What's the java type of " + schemaTypeDef + " for " + xmlSchemaType);
        }
        return javaType;
    }

    public ElementExpr getSchemaTypeDef(String origTypeName) {
        String typeName = origTypeName;
        if (typeName == null) {
            return null;
        }
        ElementExpr result = (ElementExpr)this.schemaTypeDefs.get(typeName = this.resolveNamespace(typeName));
        if (result != null) {
            return result;
        }
        String ns = SchemaRep.prefixOf(origTypeName);
        if (ns == null) {
            typeName = SchemaRep.canonicalQName(this.documentNamespace, SchemaRep.removePrefix(origTypeName));
        }
        if ((result = (ElementExpr)this.schemaTypeDefs.get(typeName)) != null) {
            return result;
        }
        return (ElementExpr)this.definedTypes.get(origTypeName);
    }

    public ElementExpr getSchemaTypeDefResolvedNamespace(String typeName) {
        ElementExpr result = (ElementExpr)this.schemaTypeDefs.get(typeName);
        if (result == null) {
            result = (ElementExpr)this.definedTypes.get(typeName);
        }
        return result;
    }

    public Set getSchemaTypeNames() {
        return this.schemaTypeDefs.keySet();
    }

    public Element getDefinedElement(String typeName) {
        String t = this.resolveNamespace(typeName);
        return this.getDefinedElementResolvedNamespace(t);
    }

    public Element getDefinedElementResolvedNamespace(String typeName) {
        return (Element)this.definedTypesFull.get(typeName);
    }

    public Set getDefinedElementNames() {
        return this.definedTypesFull.keySet();
    }

    public void putSchemaTypeDef(String typeName, ElementExpr ee) {
        if (typeName == null) {
            return;
        }
        String ns = SchemaRep.prefixOf(typeName);
        typeName = ns == null ? this.resolveNamespace(this.targetNamespace, SchemaRep.removePrefix(typeName)) : this.resolveNamespace(ns, SchemaRep.removePrefix(typeName));
        this.schemaTypeDefs.put(typeName, ee);
    }

    public String resolveNamespace(String typeName) {
        return this.resolveNamespaceDefault(typeName, this.targetNamespace);
    }

    protected String resolveNamespaceDefault(String typeName, String defaultNS) {
        if (typeName == null) {
            return null;
        }
        String prefix = SchemaRep.prefixOf(typeName);
        typeName = this.resolveNamespaceDefault(prefix, defaultNS, SchemaRep.removePrefix(typeName));
        return typeName;
    }

    public String resolveNamespace(String ns, String type2) {
        return this.resolveNamespaceDefault(ns, this.targetNamespace, type2);
    }

    protected String resolveNamespaceDefault(String prefix, String defaultNS, String type2) {
        String uri;
        if (prefix == null) {
            if (defaultNS == null) {
                return type2;
            }
            uri = defaultNS;
        } else {
            uri = this.getNamespaceURI(prefix);
            if (uri == null) {
                System.out.println("resolveNamespace: Namespace prefix '" + prefix + "' was not found (type=" + type2 + ").");
                new Exception().printStackTrace();
            }
        }
        return SchemaRep.canonicalQName(uri, type2);
    }

    public static String canonicalQName(String namespaceURI, String localPart) {
        if (namespaceURI == null || namespaceURI.equals("")) {
            return localPart;
        }
        return "{" + namespaceURI + "}" + localPart;
    }

    protected String normalizeTargetNamespace(String type2) {
        if (type2 == null) {
            return null;
        }
        if (this.targetNamespace == null) {
            return type2;
        }
        if (type2.indexOf(58) >= 0) {
            return type2;
        }
        return this.normalizeNamespace(this.targetNamespace, type2);
    }

    protected String normalizeNamespace(String namespaceURI, String localPart) {
        if (localPart == null) {
            return null;
        }
        if (namespaceURI == null || "".equals(namespaceURI)) {
            return localPart;
        }
        String prefix = this.getNamespace(namespaceURI);
        return prefix + ":" + localPart;
    }

    protected String normalizeDocumentNamespace(String type2) {
        if (type2 == null) {
            return null;
        }
        if (this.documentNamespace == null) {
            return type2;
        }
        if (type2.indexOf(58) >= 0) {
            return type2;
        }
        return this.normalizeNamespace(this.documentNamespace, type2);
    }

    public void setSchemaTypeMapping(String schemaTypeNamespace, String schemaTypeName, String javaType) {
        if (schemaTypeNamespace == null) {
            SimpleType st = new SimpleType(schemaTypeName, javaType);
        } else {
            String ns = this.getNamespace(schemaTypeNamespace);
            SimpleType st = new SimpleType(ns + ":" + schemaTypeName, javaType);
        }
    }

    public void setSchemaTypesForME(boolean isFloatingPoint) {
        this.setSchemaTypeMapping(XSD_NS, "anyURI", "java.lang.String");
        this.setSchemaTypeMapping(XSD_NS, "decimal", isFloatingPoint ? "double" : "java.lang.String");
        this.setSchemaTypeMapping(XSD_NS, "integer", "long");
        if (!isFloatingPoint) {
            this.setSchemaTypeMapping(XSD_NS, "double", "java.lang.String");
            this.setSchemaTypeMapping(XSD_NS, "float", "java.lang.String");
        }
    }

    private void insertPredefinedSchemaTypes(Map st) {
        String namespace = this.getXSDNamespace() + ":";
        String[] types = new String[]{"java.lang.String", "java.util.Calendar", "java.util.Calendar", "long", "int", "char", "short", "double", "float", "byte", "boolean", "java.lang.String", "long", "long", "long", "long", "long", "int", "short", "byte", "java.net.URI", "javax.xml.namespace.QName", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "int", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        String[] schemaType = new String[]{"string", "dateTime", "date", "long", "int", "char", "short", "double", "float", "byte", "boolean", "NMTOKEN", "positiveInteger", "nonNegativeInteger", "nonPositiveInteger", "negativeInteger", "unsignedLong", "unsignedInt", "unsignedShort", "unsignedByte", "anyURI", "QName", "NCName", "Name", "duration", "time", "ID", "token", "normalizedString", "gYear", "gYearMonth", "gMonthDay", "gDay", "gMonth", "language"};
        for (int i = 0; i < schemaType.length; ++i) {
            st.put(schemaType[i], new SimpleType(namespace + schemaType[i], types[i]));
        }
        if (this.useBigDataTypes) {
            st.put("decimal", new SimpleType(namespace + "decimal", "java.math.BigDecimal"));
            st.put("integer", new SimpleType(namespace + "integer", "java.math.BigInteger"));
        } else {
            st.put("decimal", new SimpleType(namespace + "decimal", "double"));
            st.put("integer", new SimpleType(namespace + "integer", "long"));
        }
        String[] whiteSpaceReplace = new String[]{"normalizedString"};
        for (int i = 0; i < whiteSpaceReplace.length; ++i) {
            SimpleType t = (SimpleType)st.get(whiteSpaceReplace[i]);
            Restriction restrict = new Restriction(namespace + "string");
            t.addSubElement(restrict);
            WhiteSpace ws = new WhiteSpace("replace");
            restrict.addSubElement(ws);
        }
        String[] whiteSpaceCollapse = new String[]{"token", "NMTOKEN", "Name", "NCName", "ID"};
        for (int i = 0; i < whiteSpaceCollapse.length; ++i) {
            SimpleType t = (SimpleType)st.get(whiteSpaceCollapse[i]);
            Restriction restrict = new Restriction(namespace + "normalizedString");
            t.addSubElement(restrict);
            WhiteSpace ws = new WhiteSpace("collapse");
            restrict.addSubElement(ws);
        }
        this.addRestriction((SimpleType)st.get("language"), namespace + "token", new WhiteSpace("collapse"), new Pattern("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*"));
        this.addRestriction((SimpleType)st.get("nonPositiveInteger"), namespace + "integer", new MaxInclusive("0"));
        this.addRestriction((SimpleType)st.get("negativeInteger"), namespace + "nonPositiveInteger", new MaxExclusive("0"));
        this.addRestriction((SimpleType)st.get("nonNegativeInteger"), namespace + "integer", new MinInclusive("0"));
        this.addRestriction((SimpleType)st.get("unsignedLong"), namespace + "nonNegativeInteger", new MinInclusive("0"));
        this.addRestriction((SimpleType)st.get("unsignedInt"), namespace + "unsignedLong", new MinInclusive("0"));
        this.addRestriction((SimpleType)st.get("positiveInteger"), namespace + "nonNegativeInteger", new MinExclusive("0"));
        st.put("hexBinary", new HexBinary());
        st.put("base64Binary", new Base64Binary());
    }

    protected void addRestriction(ContainsSubElements cse, String restrictionBase, RestrictionType ... rt) {
        Restriction restrict = new Restriction(restrictionBase);
        cse.addSubElement(restrict);
        for (RestrictionType r : rt) {
            restrict.addSubElement(r);
        }
    }

    public void mapSimpleJavaTypesOptional(Map optionalElementMap) {
        String namespace = this.getXSDNamespace() + ":";
        String[] types = new String[]{"java.lang.Integer", "java.lang.Short", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Boolean", "java.lang.Character", "java.lang.StringBuffer", "java.lang.Byte", "java.math.BigInteger", "char[]", "char"};
        String[] restrictions = new String[]{"int", "short", "long", "double", "float", "boolean", "string", "string", "byte", "integer", "string", "string"};
        for (int i = 0; i < types.length; ++i) {
            optionalElementMap.put(types[i], new SimpleType(SchemaRep.javaType2XMLSchemaType(types[i]), new Restriction(namespace + restrictions[i])));
        }
    }

    private void mapSimpleAttributes(Map a) {
        a.put("xml:lang", new Attribute("lang", this.getNamespaceURI("xml"), "xsd:string"));
    }

    public void mapSimpleJavaTypesPredefined(Map definedElementMap) {
        String namespace = this.getXSDNamespace() + ":";
        String[] types = new String[]{"java.lang.String", "String", "java.math.BigDecimal", "java.util.Calendar", "long", "int", "char", "short", "double", "float", "byte", "boolean"};
        String[] schemaType = new String[]{"string", "string", "decimal", "dateTime", "long", "int", "char", "short", "double", "float", "byte", "boolean"};
        for (int i = 0; i < types.length; ++i) {
            ElementExpr def = this.getSchemaTypeDef(schemaType[i]);
            if (def == null) {
                def = new SimpleType(namespace + schemaType[i], types[i]);
            }
            definedElementMap.put(types[i], def);
        }
    }

    public static void printExtraJavaTypes(Writer out, int level) throws IOException {
        SchemaRep schema = new SchemaRep();
        HashMap elementMap = new HashMap();
        schema.mapSimpleJavaTypesOptional(elementMap);
        Iterator it = elementMap.keySet().iterator();
        XMLWriter xw = new XMLWriter(false);
        while (it.hasNext()) {
            Object key = it.next();
            ElementExpr el = (ElementExpr)elementMap.get(key);
            el.writeXMLSchema(xw);
        }
        xw.writeTo(out);
        out.write("\n");
    }

    private static String javaType2XMLSchemaType(String typeName) {
        return SchemaRep.javaType2XMLSchemaType(typeName, false);
    }

    private static String javaType2XMLSchemaType(String typeName, boolean unknownOkay) {
        if ("java.lang.String".equals(typeName) || "String".equals(typeName)) {
            return "xsd:string";
        }
        if ("java.lang.Integer".equals(typeName) || "java.lang.Short".equals(typeName) || "java.lang.Long".equals(typeName) || "java.lang.Double".equals(typeName) || "java.lang.Boolean".equals(typeName) || "java.lang.Character".equals(typeName) || "java.lang.Float".equals(typeName) || "java.lang.StringBuffer".equals(typeName) || "java.lang.Byte".equals(typeName) || "java.math.BigInteger".equals(typeName) || "char".equals(typeName)) {
            return typeName;
        }
        if ("char[]".equals(typeName)) {
            return "char_lb_rb";
        }
        if (JavaUtil.isPrimitiveType(typeName)) {
            return "xsd:" + typeName;
        }
        if ("java.math.BigDecimal".equals(typeName)) {
            return "xsd:decimal";
        }
        if ("java.util.Calendar".equals(typeName)) {
            return "xsd:dateTime";
        }
        if ("java.net.URI".equals(typeName)) {
            return "xsd:anyURI";
        }
        if ("javax.xml.namespace.QName".equals(typeName)) {
            return "xsd:QName";
        }
        if (!unknownOkay) {
            String err = "javaType2XMLSchemaType: No known XML Schema type for '" + typeName + "'.";
            System.out.println(err);
            return typeName;
        }
        return null;
    }

    private static boolean isXMLSchemaDefinedType(String typeName) {
        return SchemaRep.javaType2XMLSchemaType(typeName, true) != null;
    }

    public String javaType2XMLSchemaTypeComplex(String type2) {
        Object el = this.definedTypes.get(type2);
        if (el == null) {
            el = this.optionallyDefinedTypes.get(type2);
        }
        if (el == null) {
            el = this.predefinedSchemaTypes.get(type2);
        }
        if (el == null) {
            if (debug) {
                System.out.println("No type found for " + type2);
            }
            return SchemaRep.javaType2XMLSchemaType(type2);
        }
        if (el instanceof SimpleType) {
            return ((SimpleType)el).getTypeName();
        }
        if (el instanceof String) {
            return (String)el;
        }
        if (el instanceof Element) {
            return ((Element)el).getElementName();
        }
        return el.getClass().toString();
    }

    public boolean isDefinedType(String type2) {
        if (this.optionallyDefinedTypes.containsKey(type2)) {
            return true;
        }
        return this.definedTypes.containsKey(type2);
    }

    public boolean isPredefinedType(String type2) {
        boolean rv = false;
        if (this.predefinedSchemaTypes.get(type2) != null) {
            rv = true;
        }
        return rv;
    }

    public static String removePrefix(String typeName) {
        int pos = typeName.indexOf(58);
        if (pos < 0) {
            return typeName;
        }
        return typeName.substring(pos + 1);
    }

    public static String prefixOf(String typeName) {
        int pos = typeName.indexOf(58);
        if (pos < 0) {
            return null;
        }
        return typeName.substring(0, pos);
    }

    public static String guessPrefix(String namespaceURI) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        int pos = namespaceURI.lastIndexOf(47);
        String prefix = pos >= 0 ? namespaceURI.substring(pos + 1, namespaceURI.length()) : namespaceURI;
        if ((prefix = prefix.replace('#', '_').replace('\'', '_').replace('\"', '_').replace(':', '_')).startsWith("xml")) {
            prefix = "x" + prefix;
        }
        return prefix;
    }

    @Override
    public String guessPrefixFromURI(String uri) {
        String prefix = this.getNamespace(uri);
        if (prefix != null) {
            return prefix;
        }
        return SchemaRep.guessPrefix(uri);
    }

    static {
        schemaValidSubElementTypeMap = new HashMap();
        schemaValidSubElementTypeMap.put(Annotation.class, null);
        schemaValidSubElementTypeMap.put(SimpleType.class, null);
        schemaValidSubElementTypeMap.put(ComplexType.class, null);
        schemaValidSubElementTypeMap.put(Element.class, null);
        schemaValidSubElementTypeMap.put(Attribute.class, null);
        schemaValidSubElementTypeMap.put(AttributeGroup.class, null);
        schemaValidSubElementTypeMap.put(Include.class, null);
        schemaValidSubElementTypeMap.put(Import.class, null);
        schemaValidSubElementTypeMap.put(Group.class, null);
        complexTypeValidSubElementTypeMap = null;
        complexTypeValidSubElementTypeMap = new HashMap();
        complexTypeValidSubElementTypeMap.put(Annotation.class, null);
        complexTypeValidSubElementTypeMap.put(Choice.class, null);
        complexTypeValidSubElementTypeMap.put(Group.class, null);
        complexTypeValidSubElementTypeMap.put(Sequence.class, null);
        complexTypeValidSubElementTypeMap.put(All.class, null);
        complexTypeValidSubElementTypeMap.put(Attribute.class, null);
        complexTypeValidSubElementTypeMap.put(AttributeGroup.class, null);
        complexTypeValidSubElementTypeMap.put(AnyAttribute.class, null);
        complexTypeValidSubElementTypeMap.put(SimpleContent.class, null);
        complexTypeValidSubElementTypeMap.put(ComplexContent.class, null);
        simpleContentValidSubElementTypeMap = null;
        simpleContentValidSubElementTypeMap = new HashMap();
        simpleContentValidSubElementTypeMap.put(Annotation.class, null);
        simpleContentValidSubElementTypeMap.put(Restriction.class, null);
        simpleContentValidSubElementTypeMap.put(Extension.class, null);
        complexContentValidSubElementTypeMap = null;
        complexContentValidSubElementTypeMap = new HashMap();
        complexContentValidSubElementTypeMap.put(Annotation.class, null);
        complexContentValidSubElementTypeMap.put(Restriction.class, null);
        complexContentValidSubElementTypeMap.put(Extension.class, null);
        simpleTypeValidSubElementTypeMap = null;
        simpleTypeValidSubElementTypeMap = new HashMap();
        simpleTypeValidSubElementTypeMap.put(Annotation.class, null);
        simpleTypeValidSubElementTypeMap.put(Restriction.class, null);
        simpleTypeValidSubElementTypeMap.put(ListElement.class, null);
        simpleTypeValidSubElementTypeMap.put(UnionType.class, null);
        unionTypeValidSubElementTypeMap = null;
        unionTypeValidSubElementTypeMap = new HashMap();
        unionTypeValidSubElementTypeMap.put(Annotation.class, null);
        unionTypeValidSubElementTypeMap.put(SimpleType.class, null);
        restrictionValidSubElementTypeMap = null;
        restrictionValidSubElementTypeMap = new HashMap();
        restrictionValidSubElementTypeMap.put(Annotation.class, null);
        restrictionValidSubElementTypeMap.put(SimpleType.class, null);
        restrictionValidSubElementTypeMap.put(All.class, null);
        restrictionValidSubElementTypeMap.put(Choice.class, null);
        restrictionValidSubElementTypeMap.put(Sequence.class, null);
        restrictionValidSubElementTypeMap.put(Group.class, null);
        restrictionValidSubElementTypeMap.put(Attribute.class, null);
        restrictionValidSubElementTypeMap.put(AttributeGroup.class, null);
        restrictionValidSubElementTypeMap.put(AnyAttribute.class, null);
        restrictionValidSubElementTypeMap.put(MinExclusive.class, null);
        restrictionValidSubElementTypeMap.put(MaxExclusive.class, null);
        restrictionValidSubElementTypeMap.put(Enumeration.class, null);
        restrictionValidSubElementTypeMap.put(Pattern.class, null);
        restrictionValidSubElementTypeMap.put(MinLength.class, null);
        restrictionValidSubElementTypeMap.put(MaxLength.class, null);
        restrictionValidSubElementTypeMap.put(TotalDigits.class, null);
        restrictionValidSubElementTypeMap.put(MinInclusive.class, null);
        restrictionValidSubElementTypeMap.put(MaxInclusive.class, null);
        restrictionValidSubElementTypeMap.put(FractionDigits.class, null);
        restrictionValidSubElementTypeMap.put(Length.class, null);
        restrictionValidSubElementTypeMap.put(WhiteSpace.class, null);
        extensionValidSubElementTypeMap = null;
        extensionValidSubElementTypeMap = new HashMap();
        extensionValidSubElementTypeMap.put(Annotation.class, null);
        extensionValidSubElementTypeMap.put(Attribute.class, null);
        extensionValidSubElementTypeMap.put(AttributeGroup.class, null);
        extensionValidSubElementTypeMap.put(AnyAttribute.class, null);
        extensionValidSubElementTypeMap.put(Choice.class, null);
        extensionValidSubElementTypeMap.put(Group.class, null);
        extensionValidSubElementTypeMap.put(Sequence.class, null);
        extensionValidSubElementTypeMap.put(All.class, null);
        listValidSubElementTypeMap = null;
        listValidSubElementTypeMap = new HashMap();
        listValidSubElementTypeMap.put(Annotation.class, null);
        restrictionTypeValidSubElementTypeMap = null;
        restrictionTypeValidSubElementTypeMap = new HashMap();
        restrictionTypeValidSubElementTypeMap.put(Annotation.class, null);
        keyValidSubElementTypeMap = null;
        keyValidSubElementTypeMap = new HashMap();
        keyValidSubElementTypeMap.put(Annotation.class, null);
        keyValidSubElementTypeMap.put(Selector.class, null);
        keyValidSubElementTypeMap.put(Field.class, null);
        uniqueValidSubElementTypeMap = null;
        uniqueValidSubElementTypeMap = new HashMap();
        uniqueValidSubElementTypeMap.put(Annotation.class, null);
        uniqueValidSubElementTypeMap.put(Selector.class, null);
        uniqueValidSubElementTypeMap.put(Field.class, null);
        keyrefValidSubElementTypeMap = null;
        keyrefValidSubElementTypeMap = new HashMap();
        keyrefValidSubElementTypeMap.put(Annotation.class, null);
        keyrefValidSubElementTypeMap.put(Selector.class, null);
        keyrefValidSubElementTypeMap.put(Field.class, null);
        selectorValidSubElementTypeMap = null;
        selectorValidSubElementTypeMap = new HashMap();
        selectorValidSubElementTypeMap.put(Annotation.class, null);
        fieldValidSubElementTypeMap = null;
        fieldValidSubElementTypeMap = new HashMap();
        fieldValidSubElementTypeMap.put(Annotation.class, null);
        sequenceValidSubElementTypeMap = null;
        sequenceValidSubElementTypeMap = new HashMap();
        sequenceValidSubElementTypeMap.put(Annotation.class, null);
        sequenceValidSubElementTypeMap.put(Element.class, null);
        sequenceValidSubElementTypeMap.put(Any.class, null);
        sequenceValidSubElementTypeMap.put(Choice.class, null);
        sequenceValidSubElementTypeMap.put(Sequence.class, null);
        sequenceValidSubElementTypeMap.put(Group.class, null);
        choiceValidSubElementTypeMap = null;
        choiceValidSubElementTypeMap = new HashMap();
        choiceValidSubElementTypeMap.put(Annotation.class, null);
        choiceValidSubElementTypeMap.put(Element.class, null);
        choiceValidSubElementTypeMap.put(Any.class, null);
        choiceValidSubElementTypeMap.put(Choice.class, null);
        choiceValidSubElementTypeMap.put(Sequence.class, null);
        choiceValidSubElementTypeMap.put(Group.class, null);
        allValidSubElementTypeMap = null;
        allValidSubElementTypeMap = new HashMap();
        allValidSubElementTypeMap.put(Annotation.class, null);
        allValidSubElementTypeMap.put(Element.class, null);
        allValidSubElementTypeMap.put(Any.class, null);
        groupValidSubElementTypeMap = null;
        groupValidSubElementTypeMap = new HashMap();
        groupValidSubElementTypeMap.put(All.class, null);
        groupValidSubElementTypeMap.put(Choice.class, null);
        groupValidSubElementTypeMap.put(Sequence.class, null);
        groupValidSubElementTypeMap.put(Annotation.class, null);
        annotationValidSubElementTypeMap = null;
        annotationValidSubElementTypeMap = new HashMap();
        annotationValidSubElementTypeMap.put(AppInfo.class, null);
        annotationValidSubElementTypeMap.put(Documentation.class, null);
        appInfoValidSubElementTypeMap = null;
        appInfoValidSubElementTypeMap = new HashMap();
        appInfoValidSubElementTypeMap.put(AnyNode.class, null);
        appInfoValidSubElementTypeMap.put(TextNode.class, null);
        documentationValidSubElementTypeMap = null;
        documentationValidSubElementTypeMap = new HashMap();
        documentationValidSubElementTypeMap.put(AnyNode.class, null);
        documentationValidSubElementTypeMap.put(TextNode.class, null);
        anyNodeValidSubElementTypeMap = null;
        anyNodeValidSubElementTypeMap = new HashMap();
        anyNodeValidSubElementTypeMap.put(AnyNode.class, null);
        anyNodeValidSubElementTypeMap.put(TextNode.class, null);
        textNodeValidSubElementTypeMap = null;
        textNodeValidSubElementTypeMap = new HashMap();
        textNodeValidSubElementTypeMap.put(AnyNode.class, null);
        textNodeValidSubElementTypeMap.put(TextNode.class, null);
        elementValidSubElementTypeMap = null;
        elementValidSubElementTypeMap = new HashMap();
        elementValidSubElementTypeMap.put(Annotation.class, null);
        elementValidSubElementTypeMap.put(SimpleType.class, null);
        elementValidSubElementTypeMap.put(ComplexType.class, null);
        elementValidSubElementTypeMap.put(Unique.class, null);
        elementValidSubElementTypeMap.put(Key.class, null);
        elementValidSubElementTypeMap.put(KeyRef.class, null);
        anyValidSubElementTypeMap = null;
        anyValidSubElementTypeMap = new HashMap();
        anyValidSubElementTypeMap.put(Annotation.class, null);
        anyAttributeValidSubElementTypeMap = null;
        anyAttributeValidSubElementTypeMap = new HashMap();
        anyAttributeValidSubElementTypeMap.put(Annotation.class, null);
        attributeValidSubElementTypeMap = null;
        attributeValidSubElementTypeMap = new HashMap();
        attributeValidSubElementTypeMap.put(Annotation.class, null);
        attributeValidSubElementTypeMap.put(SimpleType.class, null);
        attributeGroupValidSubElementTypeMap = null;
        attributeGroupValidSubElementTypeMap = new HashMap();
        attributeGroupValidSubElementTypeMap.put(Annotation.class, null);
        attributeGroupValidSubElementTypeMap.put(Attribute.class, null);
        attributeGroupValidSubElementTypeMap.put(AttributeGroup.class, null);
        attributeGroupValidSubElementTypeMap.put(AnyAttribute.class, null);
    }

    private class ParserSchemaState {
        private String targetNamespace;
        private String documentNamespace;
        private boolean elementFormQualifiedDefault;
        private boolean attributeFormQualifiedDefault;

        public ParserSchemaState() {
            this.targetNamespace = SchemaRep.this.targetNamespace;
            this.documentNamespace = SchemaRep.this.documentNamespace;
            this.elementFormQualifiedDefault = SchemaRep.this.elementFormQualifiedDefault;
            this.attributeFormQualifiedDefault = SchemaRep.this.attributeFormQualifiedDefault;
        }

        public void reload() {
            SchemaRep.this.targetNamespace = this.targetNamespace;
            SchemaRep.this.documentNamespace = this.documentNamespace;
            SchemaRep.this.elementFormQualifiedDefault = this.elementFormQualifiedDefault;
            SchemaRep.this.attributeFormQualifiedDefault = this.attributeFormQualifiedDefault;
        }
    }

    public class AttributeGroup
    extends ContainsSubElements
    implements CanRef {
        private String name;
        private String ref;

        public AttributeGroup() {
        }

        public AttributeGroup(String n) {
            if (n != null && !n.equals("")) {
                this.name = SchemaRep.this.normalizeTargetNamespace(n).intern();
                SchemaRep.this.putSchemaTypeDef(this.name, this);
            }
        }

        @Override
        public Map validSubElementTypeMap() {
            return attributeGroupValidSubElementTypeMap;
        }

        @Override
        public String getName() {
            return "attributeGroup";
        }

        @Override
        public String getContentName() {
            return this.name;
        }

        public String getGroupName() {
            return this.name;
        }

        @Override
        public boolean hasRef() {
            return this.getRef() != null;
        }

        @Override
        public String getRef() {
            return this.ref;
        }

        public AttributeGroup getRefAttributeGroup() {
            if (this.ref == null) {
                return null;
            }
            ElementExpr o = SchemaRep.this.getSchemaTypeDef(this.ref);
            if (o instanceof AttributeGroup) {
                AttributeGroup referredGroup = (AttributeGroup)o;
                return referredGroup;
            }
            throw new IllegalStateException(Common.getMessage("MSG_FailedToFindRef", this.ref, this.toString()));
        }

        @Override
        public ElementExpr getRefElementExpr() {
            return this.getRefAttributeGroup();
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return this.writeDTDSubElementNames(out, false);
        }

        @Override
        public String getAttributeString() {
            StringBuffer sb = new StringBuffer();
            if (this.name != null) {
                sb.append(" name='" + this.name + "'");
            }
            if (this.ref != null) {
                sb.append(" ref='" + this.ref + "'");
            }
            return sb.toString();
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String myName = node.getAttribute("name");
            String myRef = node.getAttribute("ref");
            AttributeGroup ag = new AttributeGroup(myName);
            if (myRef != null && !myRef.equals("")) {
                ag.ref = myRef.intern();
            }
            SchemaRep.this.pushCurrent(ag);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof AttributeGroup)) {
                return false;
            }
            AttributeGroup el = (AttributeGroup)o;
            if (this.name != el.name) {
                return false;
            }
            if (this.ref != el.ref) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 37 * result + (this.ref == null ? 0 : this.ref.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class Attribute
    extends ContainsSubElements
    implements CanRef {
        private String namespace;
        private String name;
        private String type;
        private String defaultValue;
        private String id;
        private String ref;
        private String fixed;
        private String use;
        private String arrayType;

        public Attribute(String n) {
            this(n, this$0.targetNamespace);
        }

        public Attribute(String n, String ns) {
            this(n, ns, null);
        }

        public Attribute(String n, String ns, String type2) {
            this.name = n == null || n.equals("") ? null : n.intern();
            this.namespace = ns;
            this.setType(type2);
        }

        @Override
        public String getName() {
            return "attribute";
        }

        @Override
        public String getContentName() {
            return "@" + this.name;
        }

        public String getAttributeName() {
            if (this.namespace == null || this.namespace.equals(SchemaRep.this.targetNamespace)) {
                return this.name;
            }
            return SchemaRep.this.getNamespace(this.namespace) + ":" + this.name;
        }

        public String getAttributeNamespace() {
            return this.namespace;
        }

        public String getAttributeNameNoNS() {
            return this.name;
        }

        private void setType(String ty) {
            if (ty == null) {
                this.type = null;
                return;
            }
            this.type = SchemaRep.this.normalizeDocumentNamespace(ty).intern();
        }

        public String getType() {
            return this.type;
        }

        public String getJavaType() {
            if (this.type == null) {
                return null;
            }
            String javaType = SchemaRep.this.schemaTypeToJavaType(this.type);
            return javaType;
        }

        public String getFixed() {
            return this.fixed;
        }

        public boolean isRequired() {
            return this.use == "required";
        }

        public boolean isOptional() {
            return this.use == "optional";
        }

        public boolean isProhibited() {
            return this.use == "prohibited";
        }

        public String getUse() {
            return this.use;
        }

        public boolean isAttributeNamed(String n) {
            n = SchemaRep.this.resolveNamespace(n);
            String fullName = SchemaRep.this.resolveNamespace(this.namespace, this.name);
            return n.equals(fullName);
        }

        @Override
        public boolean hasRef() {
            return this.getRef() != null;
        }

        @Override
        public String getRef() {
            return this.ref;
        }

        public Attribute getRefAttribute() {
            if (this.ref == null) {
                return null;
            }
            Object o = SchemaRep.this.definedAttributes.get(this.ref);
            if (o instanceof Attribute) {
                Attribute referredAttribute = (Attribute)o;
                return referredAttribute;
            }
            throw new IllegalStateException(Common.getMessage("MSG_FailedToFindRef", this.ref, this.toString()));
        }

        @Override
        public ElementExpr getRefElementExpr() {
            return this.getRefAttribute();
        }

        public boolean isDefiningNewType() {
            if (this.ref == null) {
                return true;
            }
            return this.subElements.size() >= 1 && this.type != null;
        }

        public String getArrayType() {
            return this.arrayType;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public void writeDTD(StringBuffer out) {
            this.writeDTD(out, "UNKNOWN");
        }

        public void writeDTD(StringBuffer out, String elementName) {
            out.append("<!ATTLIST " + elementName + " " + this.name + " ");
            out.append(">\n");
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            out.append(this.name);
            return false;
        }

        @Override
        public void validate() {
            super.validate();
        }

        @Override
        public Map validSubElementTypeMap() {
            return attributeValidSubElementTypeMap;
        }

        @Override
        public String getAttributeString() {
            StringBuffer sb = new StringBuffer();
            if (this.name != null) {
                sb.append(" name='" + this.getAttributeName() + "'");
            }
            if (this.type != null) {
                sb.append(" type='" + this.type + "'");
            }
            if (this.fixed != null) {
                sb.append(" fixed='");
                XMLUtil.printXML(sb, this.fixed, true);
                sb.append("'");
            }
            if (this.ref != null) {
                sb.append(" ref='" + this.ref + "'");
            }
            if (this.id != null) {
                sb.append(" id='" + this.id + "'");
            }
            if (this.defaultValue != null) {
                sb.append(" default='");
                XMLUtil.printXML(sb, this.defaultValue, true);
                sb.append("'");
            }
            if (this.use != null) {
                sb.append(" use='" + this.use + "'");
            }
            if (this.arrayType != null) {
                sb.append(" wsdl:arrayType='" + this.arrayType + "'");
            }
            return sb.toString();
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String myName = node.getAttribute("name");
            String myType = node.getAttribute("type");
            String myFixed = node.getAttribute("fixed");
            String myRef = node.getAttribute("ref");
            String myId = node.getAttribute("id");
            String myDefault = node.getAttribute("default");
            String myUse = node.getAttribute("use");
            String myArrayType = node.getAttributeNS("http://schemas.xmlsoap.org/wsdl/", "arrayType");
            Attribute attr = new Attribute(myName);
            if (myType != null && !myType.equals("")) {
                attr.setType(myType.intern());
            }
            if (myFixed != null && !myFixed.equals("")) {
                attr.fixed = myFixed.intern();
            }
            if (myRef != null && !myRef.equals("")) {
                attr.ref = myRef.intern();
            }
            if (myId != null && !myId.equals("")) {
                attr.id = myId.intern();
            }
            if (myDefault != null && !myDefault.equals("")) {
                attr.defaultValue = myDefault.intern();
            }
            if (myUse != null && !myUse.equals("")) {
                attr.use = myUse.intern();
            }
            if (myArrayType != null && !myArrayType.equals("")) {
                attr.arrayType = myArrayType.intern();
            }
            SchemaRep.this.pushCurrent(attr);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute el = (Attribute)o;
            if (this.name != el.name) {
                return false;
            }
            if (this.type != el.type) {
                return false;
            }
            if (this.fixed != el.fixed) {
                return false;
            }
            if (this.ref != el.ref) {
                return false;
            }
            if (this.id != el.id) {
                return false;
            }
            if (this.use != el.use) {
                return false;
            }
            if (this.arrayType != el.arrayType) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 37 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 37 * result + (this.fixed == null ? 0 : this.fixed.hashCode());
            result = 37 * result + (this.ref == null ? 0 : this.ref.hashCode());
            result = 37 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 37 * result + (this.use == null ? 0 : this.use.hashCode());
            result = 37 * result + (this.arrayType == null ? 0 : this.arrayType.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class AnyAttribute
    extends ContainsSubElements {
        private String namespace;
        private String processContents;

        @Override
        public String getName() {
            return "anyAttribute";
        }

        @Override
        public String getContentName() {
            return null;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String n) {
            this.namespace = n == null ? null : n.intern();
        }

        public String getProcessContents() {
            return this.processContents;
        }

        public void setProcessContents(String pc) {
            this.processContents = pc == null ? null : pc.intern();
        }

        @Override
        public String getAttributeString() {
            StringBuffer sb = new StringBuffer();
            if (this.namespace != null) {
                sb.append(" namespace='" + this.namespace + "'");
            }
            if (this.processContents != null) {
                sb.append(" processContents='" + this.processContents + "'");
            }
            return sb.toString();
        }

        @Override
        public Map validSubElementTypeMap() {
            return anyAttributeValidSubElementTypeMap;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String namespace = node.getAttribute("namespace");
            String processContents = node.getAttribute("processContents");
            AnyAttribute el = new AnyAttribute();
            if (namespace != null && !namespace.equals("")) {
                el.setNamespace(namespace);
            }
            if (processContents != null && !processContents.equals("")) {
                el.setProcessContents(processContents);
            }
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof AnyAttribute)) {
                return false;
            }
            AnyAttribute el = (AnyAttribute)o;
            if (this.namespace != el.namespace) {
                return false;
            }
            if (this.processContents != el.processContents) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            result = 37 * result + (this.processContents == null ? 0 : this.processContents.hashCode());
            return result;
        }
    }

    public class Any
    extends ContainsSubElements
    implements MinMaxOccurs {
        private String minOccurs;
        private String maxOccurs;
        private String namespace;
        private String processContents;

        public Any() {
            this.init();
        }

        private void init() {
            this.minOccurs = "1";
            this.maxOccurs = "1";
        }

        @Override
        public String getName() {
            return "any";
        }

        @Override
        public String getContentName() {
            return null;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String n) {
            this.namespace = n == null ? null : n.intern();
        }

        public String getProcessContents() {
            return this.processContents;
        }

        public void setProcessContents(String pc) {
            this.processContents = pc == null ? null : pc.intern();
        }

        public void setMinOccurs(String mino) {
            if (mino == null) {
                mino = "1";
            }
            this.minOccurs = mino.intern();
        }

        public void setMaxOccurs(String maxo) {
            if (maxo == null) {
                maxo = "1";
            }
            this.maxOccurs = maxo.intern();
        }

        @Override
        public String getMinOccurs() {
            return this.minOccurs;
        }

        @Override
        public String getMaxOccurs() {
            return this.maxOccurs;
        }

        @Override
        public String getAttributeString() {
            StringBuffer sb = new StringBuffer();
            if (this.minOccurs != "1") {
                sb.append(" minOccurs='" + this.minOccurs + "'");
            }
            if (this.maxOccurs != "1") {
                sb.append(" maxOccurs='" + this.maxOccurs + "'");
            }
            if (this.namespace != null) {
                sb.append(" namespace='" + this.namespace + "'");
            }
            if (this.processContents != null) {
                sb.append(" processContents='" + this.processContents + "'");
            }
            return sb.toString();
        }

        @Override
        public Map validSubElementTypeMap() {
            return anyValidSubElementTypeMap;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String namespace = node.getAttribute("namespace");
            String processContents = node.getAttribute("processContents");
            String minOccurs = node.getAttribute("minOccurs");
            String maxOccurs = node.getAttribute("maxOccurs");
            Any el = new Any();
            if (namespace != null && !namespace.equals("")) {
                el.setNamespace(namespace);
            }
            if (processContents != null && !processContents.equals("")) {
                el.setProcessContents(processContents);
            }
            if (minOccurs != null && !minOccurs.equals("")) {
                el.setMinOccurs(minOccurs);
            }
            if (maxOccurs != null && !maxOccurs.equals("")) {
                el.setMaxOccurs(maxOccurs);
            }
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Any)) {
                return false;
            }
            Any el = (Any)o;
            if (this.minOccurs != el.minOccurs) {
                return false;
            }
            if (this.maxOccurs != el.maxOccurs) {
                return false;
            }
            if (this.namespace != el.namespace) {
                return false;
            }
            if (this.processContents != el.processContents) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            result = 37 * result + (this.processContents == null ? 0 : this.processContents.hashCode());
            result = 37 * result + (this.minOccurs == null ? 0 : this.minOccurs.hashCode());
            result = 37 * result + (this.maxOccurs == null ? 0 : this.maxOccurs.hashCode());
            return result;
        }
    }

    public class Element
    extends ContainsSubElements
    implements MinMaxOccurs,
    CanRef {
        private String elementName;
        private String elementNamespace;
        private String defaultTargetNamespace;
        private boolean defaultFormQualified;
        private Boolean formQualified;
        private String type;
        private String xmlSchemaType;
        private String ref;
        private String refWithNamespace;
        private String minOccurs;
        private String maxOccurs;
        private boolean nillable;
        private String defaultValue;
        private ElementExpr parentElementExpr;

        protected Element(String n, String t) {
            this(n);
            this.setType(t);
            this$0.putSchemaTypeDef(this.type, this);
        }

        protected Element(String n) {
            this.minOccurs = "1";
            this.maxOccurs = "1";
            this.nillable = false;
            this.setElementName(n);
            this.type = null;
        }

        private Element() {
            this.minOccurs = "1";
            this.maxOccurs = "1";
            this.nillable = false;
        }

        @Override
        public String getName() {
            return "element";
        }

        @Override
        public String getContentName() {
            return this.elementName;
        }

        private void setElementName(String n) {
            if (n != null && !n.equals("")) {
                String prefix = SchemaRep.prefixOf(n);
                if (prefix == null) {
                    this.elementNamespace = this.parentElementExpr instanceof SchemaNode ? this.defaultTargetNamespace : (this.isFormQualified() ? this.defaultTargetNamespace : null);
                    this.elementName = n;
                } else {
                    this.elementNamespace = SchemaRep.this.getNamespaceURI(prefix);
                    this.elementName = SchemaRep.removePrefix(n);
                }
            } else {
                this.elementName = null;
                this.elementNamespace = null;
            }
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getElementNamespace() {
            return this.elementNamespace;
        }

        public String getPrefix() {
            return SchemaRep.this.getNamespace(this.elementNamespace);
        }

        public boolean isFormQualified() {
            if (this.formQualified != null) {
                return this.formQualified;
            }
            return this.defaultFormQualified;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public boolean hasRef() {
            return this.getRef() != null;
        }

        @Override
        public String getRef() {
            return this.ref;
        }

        public Element getRefElement() {
            if (this.ref == null) {
                return null;
            }
            Element referredElement = SchemaRep.this.getDefinedElementResolvedNamespace(this.refWithNamespace);
            return referredElement;
        }

        @Override
        public ElementExpr getRefElementExpr() {
            return this.getRefElement();
        }

        public void setType(String t) {
            if (t != null) {
                t = t.intern();
            }
            if ("void" == t) {
                t = null;
            }
            String oldType = this.type;
            this.type = t;
            if (SchemaRep.this.schemaTypeDefs.containsKey(oldType)) {
                SchemaRep.this.schemaTypeDefs.remove(oldType);
            }
            if (t == null) {
                return;
            }
            SchemaRep.this.putSchemaTypeDef(this.type, this);
            this.ref = null;
            if (debug) {
                System.out.println("setType(" + t + ")");
            }
            if (SchemaRep.this.optionallyDefinedTypes.containsKey(t)) {
                SchemaRep.this.requiredPredefinedTypes.put(t, "keep");
            }
        }

        public void setXMLSchemaType(String t) {
            if (t == null) {
                this.xmlSchemaType = null;
            } else {
                this.xmlSchemaType = SchemaRep.this.normalizeDocumentNamespace(t).intern();
                this.ref = null;
            }
        }

        public String getJavaType() {
            if (this.type != null) {
                return this.type;
            }
            if (this.ref != null) {
                Element referredElement = this.getRefElement();
                return referredElement.getJavaType();
            }
            if (this.xmlSchemaType == null) {
                return null;
            }
            String javaType = SchemaRep.this.schemaTypeToJavaType(this.xmlSchemaType);
            if (this.nillable) {
                javaType = JavaUtil.toObjectType(javaType);
            }
            return javaType;
        }

        public String getXMLSchemaType() {
            return this.xmlSchemaType;
        }

        public void setMinOccurs(String mino) {
            if (mino == null) {
                mino = "1";
            }
            this.minOccurs = mino.intern();
        }

        public void setMaxOccurs(String maxo) {
            if (maxo == null) {
                maxo = "1";
            }
            this.maxOccurs = maxo.intern();
        }

        @Override
        public String getMinOccurs() {
            return this.minOccurs;
        }

        @Override
        public String getMaxOccurs() {
            return this.maxOccurs;
        }

        public boolean isNillable() {
            return this.nillable;
        }

        public String getDefault() {
            return this.defaultValue;
        }

        public void setDefault(String d) {
            this.defaultValue = d;
        }

        @Override
        public void writeDTD(StringBuffer out) {
            Element firstElement = (Element)SchemaRep.this.elementTable.get(this.getElementName());
            if (firstElement != null) {
                if (debug) {
                    System.out.println("Found another element named " + this.getElementName());
                }
                if (!this.equals(firstElement)) {
                    throw new RuntimeException(Common.getMessage("MSG_SameNameDifferentContents", this.getElementName()));
                }
                return;
            }
            SchemaRep.this.elementTable.put(this.getElementName(), this);
            out.append("<!ELEMENT " + this.getElementName() + " ");
            if (this.subElements.size() == 0) {
                if (this.type == null || this.type == "void") {
                    out.append("()");
                } else {
                    out.append("#PCDATA");
                }
            } else if (!this.writeDTDSubElementNames(out)) {
                out.append("()");
            }
            out.append(">\n");
            super.writeDTD(out);
        }

        public boolean hasNamedSubElements() {
            if (this.subElements.size() == 0) {
                return false;
            }
            return this.writeDTDSubElementNames(new StringBuffer());
        }

        @Override
        public String getAttributeString() {
            String theXmlSchemaType;
            StringBuffer sb = new StringBuffer();
            if (this.elementName != null) {
                sb.append(" name='");
                if (this.elementNamespace != null && !this.elementNamespace.equals(SchemaRep.this.targetNamespace)) {
                    sb.append(SchemaRep.this.getNamespace(this.elementNamespace));
                    sb.append(':');
                }
                sb.append(this.elementName);
                sb.append("'");
            }
            if (this.ref != null) {
                sb.append(" ref='");
                sb.append(this.ref);
                sb.append("'");
            }
            if (this.xmlSchemaType != null) {
                sb.append(" type='");
                sb.append(this.xmlSchemaType);
                sb.append("'");
            } else if (this.type != null && (theXmlSchemaType = SchemaRep.this.javaType2XMLSchemaTypeComplex(this.getType())) != null) {
                sb.append(" type='");
                sb.append(theXmlSchemaType);
                sb.append("'");
            }
            if (this.minOccurs != "1") {
                sb.append(" minOccurs='" + this.minOccurs + "'");
            }
            if (this.maxOccurs != "1") {
                sb.append(" maxOccurs='" + this.maxOccurs + "'");
            }
            if (this.nillable) {
                sb.append(" nillable='true'");
            }
            if (this.defaultValue != null) {
                sb.append(" default='" + this.defaultValue + "'");
            }
            if (this.formQualified != null) {
                sb.append(" form='" + (this.formQualified != false ? "qualified" : "unqualified") + "'");
            }
            return sb.toString();
        }

        public boolean isDefiningNewType() {
            if (this.ref == null) {
                return true;
            }
            return this.subElements.size() >= 1 && this.type != null;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            out.append(this.getElementName());
            if ("unbounded" == this.maxOccurs) {
                out.append("*");
            }
            return true;
        }

        @Override
        public Map validSubElementTypeMap() {
            return elementValidSubElementTypeMap;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            boolean defaultFormQualified;
            String defaultTargetNamespace;
            String elementName = node.getAttribute("name");
            String elementType = node.getAttribute("type");
            String elementRef = node.getAttribute("ref");
            String minOccurs = node.getAttribute("minOccurs");
            String maxOccurs = node.getAttribute("maxOccurs");
            String myNillable = node.getAttribute("nillable");
            String myDefault = node.getAttribute("default");
            String myForm = node.getAttribute("form");
            ElementExpr parent = SchemaRep.this.peekCurrent();
            SchemaNode parentSchema = parent instanceof SchemaNode ? (SchemaNode)parent : (SchemaNode)SchemaRep.this.findAncestor(SchemaNode.class);
            if (parentSchema != null) {
                defaultTargetNamespace = SchemaRep.this.targetNamespace;
                defaultFormQualified = SchemaRep.this.elementFormQualifiedDefault;
            } else {
                defaultTargetNamespace = SchemaRep.this.targetNamespace;
                defaultFormQualified = false;
            }
            Element el = new Element();
            el.parentElementExpr = parent;
            el.defaultTargetNamespace = defaultTargetNamespace;
            el.defaultFormQualified = defaultFormQualified;
            el.setElementName(elementName);
            if (myForm != null && !"".equals(myForm)) {
                el.formQualified = "qualified".equals(myForm);
            }
            if (elementRef != null && !elementRef.equals("")) {
                el.ref = elementRef.intern();
                el.refWithNamespace = SchemaRep.this.resolveNamespace(el.ref);
            }
            if (elementType != null && !elementType.equals("")) {
                el.setXMLSchemaType(elementType);
            }
            if (minOccurs != null && !minOccurs.equals("")) {
                el.setMinOccurs(minOccurs);
            }
            if (maxOccurs != null && !maxOccurs.equals("")) {
                el.setMaxOccurs(maxOccurs);
            }
            if (myNillable != null && (myNillable.equals("true") || myNillable.equals("yes") || myNillable.equals("on"))) {
                el.nillable = true;
            }
            if (myDefault != null && !"".equals(myDefault)) {
                el.setDefault(myDefault);
            }
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Element)) {
                return false;
            }
            Element el = (Element)o;
            if (this.type != el.type) {
                return false;
            }
            if (this.ref != el.ref) {
                return false;
            }
            if (this.xmlSchemaType != el.xmlSchemaType) {
                return false;
            }
            if (this.minOccurs != el.minOccurs) {
                return false;
            }
            if (this.maxOccurs != el.maxOccurs) {
                return false;
            }
            if (this.nillable != el.nillable) {
                return false;
            }
            if (this.formQualified == null ? el.formQualified != null : el.formQualified == null || this.formQualified.booleanValue() != el.formQualified.booleanValue()) {
                return false;
            }
            if (!this.elementName.equals(el.elementName)) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 37 * result + (this.ref == null ? 0 : this.ref.hashCode());
            result = 37 * result + (this.xmlSchemaType == null ? 0 : this.xmlSchemaType.hashCode());
            result = 37 * result + (this.minOccurs == null ? 0 : this.minOccurs.hashCode());
            result = 37 * result + (this.maxOccurs == null ? 0 : this.maxOccurs.hashCode());
            result = 37 * result + (this.nillable ? 1 : 0);
            result = 37 * result + (this.elementName == null ? 0 : this.elementName.hashCode());
            result = 37 * result + super.hashCode();
            result = 37 * result + (this.formQualified == null ? 0 : this.formQualified.hashCode());
            return result;
        }
    }

    public class TextNode
    extends ContainsSubElements {
        protected String text;

        public TextNode(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public String getName() {
            return "TextNode";
        }

        @Override
        public String getContentName() {
            return null;
        }

        @Override
        public boolean compressWhiteSpaceInner() {
            return true;
        }

        @Override
        public ElementExpr optimize() {
            super.optimize();
            if (this.text == null || this.text.equals("")) {
                return null;
            }
            return this;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public void writeXMLSchema(XMLWriter out) throws IOException {
            XMLUtil.printXML((Writer)out, this.text, false);
            this.writeXMLSchema(out, false);
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            this.readSchema((Text)((Object)node));
        }

        public void readSchema(Text node) {
            TextNode el = new TextNode(node.getData());
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public String toString() {
            return "TextNode(" + this.text + ")";
        }

        @Override
        public Map validSubElementTypeMap() {
            return textNodeValidSubElementTypeMap;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof TextNode)) {
                return false;
            }
            TextNode el = (TextNode)o;
            return !(this.text == null ? el.text != null : !this.text.equals(el.text));
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.text == null ? 0 : this.text.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class AnyNode
    extends ContainsSubElements {
        protected String name;
        protected String value;

        public AnyNode(String n, String v) {
            this.name = n;
            this.value = v;
        }

        @Override
        public String getContentName() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean compressWhiteSpaceInner() {
            return this.findSubElement("TextNode") != null;
        }

        @Override
        public ElementExpr optimize() {
            super.optimize();
            if (this.name == null && this.value == null && this.subElements.size() == 0) {
                return null;
            }
            return this;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public void writeXMLSchema(XMLWriter out) throws IOException {
            if (this.value == null) {
                this.writeXMLSchema(out, true);
            } else {
                out.startTag(this.getName());
                XMLUtil.printXML((Writer)out, this.value, false);
                this.writeXMLSchema(out, false);
                out.endTag();
            }
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String myName = node.getLocalName();
            String myValue = node.getNodeValue();
            AnyNode el = new AnyNode(myName, myValue);
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public String toString() {
            return "AnyNode(" + this.name + ")";
        }

        @Override
        public Map validSubElementTypeMap() {
            return anyNodeValidSubElementTypeMap;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof AnyNode)) {
                return false;
            }
            AnyNode el = (AnyNode)o;
            if (this.value == null ? el.value != null : !this.value.equals(el.value)) {
                return false;
            }
            return !(this.name == null ? el.name != null : !this.name.equals(el.name));
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class Documentation
    extends ContainsSubElements {
        @Override
        public String getContentName() {
            return null;
        }

        @Override
        public boolean compressWhiteSpaceOuter() {
            return true;
        }

        @Override
        public boolean compressWhiteSpaceInner() {
            return true;
        }

        @Override
        public String getName() {
            return "documentation";
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            Documentation el = new Documentation();
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public Map validSubElementTypeMap() {
            return documentationValidSubElementTypeMap;
        }
    }

    public class AppInfo
    extends ContainsSubElements {
        @Override
        public String getContentName() {
            return null;
        }

        @Override
        public boolean compressWhiteSpaceOuter() {
            return true;
        }

        @Override
        public boolean compressWhiteSpaceInner() {
            return true;
        }

        @Override
        public String getName() {
            return "appinfo";
        }

        @Override
        public ElementExpr optimize() {
            super.optimize();
            if (this.subElements.size() == 0) {
                return null;
            }
            return this;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            AppInfo el = new AppInfo();
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public Map validSubElementTypeMap() {
            return appInfoValidSubElementTypeMap;
        }
    }

    public class Annotation
    extends ContainsSubElements {
        @Override
        public String getName() {
            return "annotation";
        }

        @Override
        public String getContentName() {
            return null;
        }

        @Override
        public ElementExpr optimize() {
            super.optimize();
            if (this.subElements.size() == 0) {
                return null;
            }
            return this;
        }

        @Override
        public boolean compressWhiteSpaceInner() {
            return true;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            Annotation el = new Annotation();
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public Map validSubElementTypeMap() {
            return annotationValidSubElementTypeMap;
        }
    }

    public class Group
    extends ModelGroup
    implements CanRef {
        private String name;
        private String ref;

        public Group() {
        }

        public Group(String n) {
            if (n != null && !n.equals("")) {
                this.name = SchemaRep.this.normalizeTargetNamespace(n).intern();
                SchemaRep.this.putSchemaTypeDef(this.name, this);
            }
        }

        @Override
        public ElementExpr optimize() {
            if (this.ref != null) {
                return this;
            }
            return super.optimize();
        }

        @Override
        public String getName() {
            return "group";
        }

        public String getGroupName() {
            return this.name;
        }

        @Override
        public boolean hasRef() {
            return this.getRef() != null;
        }

        @Override
        public String getRef() {
            return this.ref;
        }

        public Group getRefGroup() {
            if (this.ref == null) {
                return null;
            }
            ElementExpr o = SchemaRep.this.getSchemaTypeDef(this.ref);
            if (o instanceof Group) {
                Group referredGroup = (Group)o;
                return referredGroup;
            }
            throw new IllegalStateException(Common.getMessage("MSG_FailedToFindRef", this.ref, this.toString()));
        }

        @Override
        public ElementExpr getRefElementExpr() {
            return this.getRefGroup();
        }

        @Override
        public Map validSubElementTypeMap() {
            return groupValidSubElementTypeMap;
        }

        @Override
        public String getAttributeString() {
            StringBuffer sb = new StringBuffer();
            if (this.name != null) {
                sb.append(" name='" + this.name + "'");
            }
            if (this.ref != null) {
                sb.append(" ref='" + this.ref + "'");
            }
            return sb.toString();
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String myName = node.getAttribute("name");
            String myRef = node.getAttribute("ref");
            Group g = new Group(myName);
            if (myRef != null && !myRef.equals("")) {
                g.ref = myRef.intern();
            }
            SchemaRep.this.pushCurrent(g);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        protected ModelGroup newInstance() {
            return new Group();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof AttributeGroup)) {
                return false;
            }
            AttributeGroup el = (AttributeGroup)o;
            if (this.name != el.name) {
                return false;
            }
            if (this.ref != el.ref) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 37 * result + (this.ref == null ? 0 : this.ref.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class All
    extends ModelGroup {
        @Override
        public String getName() {
            return "all";
        }

        @Override
        public Map validSubElementTypeMap() {
            return allValidSubElementTypeMap;
        }

        @Override
        protected ModelGroup newInstance() {
            return new All();
        }
    }

    public class Choice
    extends ModelGroup {
        @Override
        public String getName() {
            return "choice";
        }

        @Override
        public Map validSubElementTypeMap() {
            return choiceValidSubElementTypeMap;
        }

        @Override
        protected ModelGroup newInstance() {
            return new Choice();
        }
    }

    public class Sequence
    extends ModelGroup {
        @Override
        public String getName() {
            return "sequence";
        }

        @Override
        public Map validSubElementTypeMap() {
            return sequenceValidSubElementTypeMap;
        }

        @Override
        protected ModelGroup newInstance() {
            return new Sequence();
        }
    }

    public abstract class ModelGroup
    extends ContainsSubElements
    implements MinMaxOccurs {
        private String minOccurs;
        private String maxOccurs;

        public ModelGroup() {
            this.minOccurs = "1";
            this.maxOccurs = "1";
        }

        @Override
        public String getContentName() {
            return null;
        }

        public void setMinOccurs(String mino) {
            if (mino == null) {
                mino = "1";
            }
            this.minOccurs = mino.intern();
        }

        public void setMaxOccurs(String maxo) {
            if (maxo == null) {
                maxo = "1";
            }
            this.maxOccurs = maxo.intern();
        }

        @Override
        public String getMinOccurs() {
            return this.minOccurs;
        }

        @Override
        public String getMaxOccurs() {
            return this.maxOccurs;
        }

        @Override
        public ElementExpr optimize() {
            super.optimize();
            if (this.subElements.size() == 0) {
                return null;
            }
            return this;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            boolean many = "unbounded" == this.maxOccurs;
            boolean hasNamedSubElements = this.writeDTDSubElementNames(out, true);
            if (many) {
                out.append("*");
            }
            return hasNamedSubElements;
        }

        @Override
        public String getAttributeString() {
            StringBuffer sb = new StringBuffer();
            if (this.minOccurs != "1") {
                sb.append(" minOccurs='" + this.minOccurs + "'");
            }
            if (this.maxOccurs != "1") {
                sb.append(" maxOccurs='" + this.maxOccurs + "'");
            }
            return sb.toString();
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String minOccurs = node.getAttribute("minOccurs");
            String maxOccurs = node.getAttribute("maxOccurs");
            ModelGroup el = this.newInstance();
            SchemaRep.this.pushCurrent(el);
            if (minOccurs != null && !minOccurs.equals("")) {
                el.setMinOccurs(minOccurs);
            }
            if (maxOccurs != null && !maxOccurs.equals("")) {
                el.setMaxOccurs(maxOccurs);
            }
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        protected abstract ModelGroup newInstance();

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ModelGroup)) {
                return false;
            }
            ModelGroup el = (ModelGroup)o;
            if (this.minOccurs != el.minOccurs) {
                return false;
            }
            if (this.maxOccurs != el.maxOccurs) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.minOccurs == null ? 0 : this.minOccurs.hashCode());
            result = 37 * result + (this.maxOccurs == null ? 0 : this.maxOccurs.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class Import
    extends ElementExpr {
        private String theNamespace;
        private String schemaLocation;

        @Override
        public String getContentName() {
            return null;
        }

        public String getNamespace() {
            return this.theNamespace;
        }

        public void setNamespace(String namespace) {
            this.theNamespace = namespace;
        }

        public String getSchemaLocation() {
            return this.schemaLocation;
        }

        public void setSchemaLocation(String schemaLocation) {
            this.schemaLocation = schemaLocation;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String namespace = node.getAttribute("namespace");
            String schemaLocation = node.getAttribute("schemaLocation");
            ParserSchemaState oldState = new ParserSchemaState();
            if (namespace != null && !namespace.equals("")) {
                SchemaRep.this.targetNamespace = namespace;
            }
            try {
                SchemaRep.this.readSchemaFromLocation(schemaLocation, false);
            }
            catch (SAXException e) {
                throw new Schema2BeansRuntimeException(Common.getMessage("MSG_FailedToParse", schemaLocation), e);
            }
            catch (IOException e) {
                throw new Schema2BeansRuntimeException(Common.getMessage("MSG_FailedToParse", schemaLocation), e);
            }
            finally {
                oldState.reload();
            }
        }

        @Override
        public ElementExpr optimize() {
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public String getName() {
            return "import";
        }

        @Override
        public void writeDTD(StringBuffer out) {
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public void writeXMLSchema(XMLWriter out) throws IOException {
            out.startTag(SchemaRep.this.getXSDNamespace(), this.getName(), false);
            if (this.theNamespace != null) {
                out.write(" theNamespace='");
                out.write(this.theNamespace);
                out.write("'");
            }
            if (this.schemaLocation != null) {
                out.write(" schemaLocation='");
                out.write(this.schemaLocation);
                out.write("'");
            }
            out.finishStartTag(false, true);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Import)) {
                return false;
            }
            Import el = (Import)o;
            if (this.theNamespace == null ? el.theNamespace != null : !this.theNamespace.equals(el.theNamespace)) {
                return false;
            }
            if (this.schemaLocation == null ? el.schemaLocation != null : !this.schemaLocation.equals(el.schemaLocation)) {
                return false;
            }
            return super.equals(el);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.theNamespace == null ? 0 : this.theNamespace.hashCode());
            result = 37 * result + (this.schemaLocation == null ? 0 : this.schemaLocation.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class Include
    extends ElementExpr {
        private String schemaLocation;

        public Include(String schemaLocation) {
            this.schemaLocation = schemaLocation;
        }

        @Override
        public String getContentName() {
            return null;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String schemaLocation = node.getAttribute("schemaLocation");
            if (SchemaRep.this.includedAlready.containsKey(schemaLocation)) {
                return;
            }
            SchemaRep.this.includedAlready.put(schemaLocation, null);
            ParserSchemaState oldState = new ParserSchemaState();
            try {
                SchemaRep.this.readSchemaFromLocation(schemaLocation, true);
            }
            catch (SAXException e) {
                throw new Schema2BeansRuntimeException(Common.getMessage("MSG_FailedToParse", schemaLocation), e);
            }
            catch (IOException e) {
                throw new Schema2BeansRuntimeException(Common.getMessage("MSG_FailedToParse", schemaLocation), e);
            }
            finally {
                oldState.reload();
            }
        }

        @Override
        public ElementExpr optimize() {
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public String getName() {
            return "include";
        }

        @Override
        public void writeDTD(StringBuffer out) {
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public void writeXMLSchema(XMLWriter out) throws IOException {
            out.startTag(SchemaRep.this.getXSDNamespace(), this.getName(), false);
            if (this.schemaLocation != null) {
                out.write(" schemaLocation='");
                out.write(this.schemaLocation);
                out.write("'");
            }
            out.finishStartTag(false, true);
        }

        public String toString() {
            if (this.schemaLocation == null) {
                return this.getName();
            }
            return this.getName() + " schemaLocation=" + this.schemaLocation;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Include)) {
                return false;
            }
            Include el = (Include)o;
            if (this.schemaLocation == null ? el.schemaLocation != null : !this.schemaLocation.equals(el.schemaLocation)) {
                return false;
            }
            return super.equals(el);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.schemaLocation == null ? 0 : this.schemaLocation.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class Field
    extends SelectorOrField {
        @Override
        public String getName() {
            return "field";
        }

        @Override
        public Map validSubElementTypeMap() {
            return fieldValidSubElementTypeMap;
        }

        @Override
        protected SelectorOrField newInstance() {
            return new Field();
        }
    }

    public class Selector
    extends SelectorOrField {
        @Override
        public String getName() {
            return "selector";
        }

        @Override
        public Map validSubElementTypeMap() {
            return selectorValidSubElementTypeMap;
        }

        @Override
        protected SelectorOrField newInstance() {
            return new Selector();
        }
    }

    public abstract class SelectorOrField
    extends ContainsSubElements {
        private String id;
        private String xpath;

        @Override
        public String getContentName() {
            return null;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getXPath() {
            return this.xpath;
        }

        public void setXPath(String xpath) {
            this.xpath = xpath;
        }

        @Override
        public String getAttributeString() {
            StringBuffer sb = new StringBuffer();
            if (this.xpath != null) {
                sb.append(" xpath='" + this.xpath + "'");
            }
            if (this.id != null) {
                sb.append(" id='" + this.id + "'");
            }
            return sb.toString();
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String id = node.getAttribute("id");
            String xpath = node.getAttribute("xpath");
            SelectorOrField el = this.newInstance();
            SchemaRep.this.pushCurrent(el);
            if (id != null && !id.equals("")) {
                el.setId(id);
            }
            if (xpath != null && !xpath.equals("")) {
                el.setXPath(xpath);
            }
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        protected abstract SelectorOrField newInstance();

        @Override
        public void writeDTD(StringBuffer out) {
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SelectorOrField)) {
                return false;
            }
            SelectorOrField el = (SelectorOrField)o;
            if (this.id == null ? el.id != null : this.id != el.id) {
                return false;
            }
            if (this.xpath == null ? el.xpath != null : this.xpath != el.xpath) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 37 * result + (this.xpath == null ? 0 : this.xpath.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class KeyRef
    extends ElementInformationItem {
        private String refer;

        @Override
        public String getName() {
            return "keyref";
        }

        public void setRefer(String refer) {
            this.refer = refer;
        }

        public String getRefer() {
            return this.refer;
        }

        @Override
        public String getAttributeString() {
            StringBuffer sb = new StringBuffer(super.getAttributeString());
            if (this.refer != null) {
                sb.append(" refer='" + this.refer + "'");
            }
            return sb.toString();
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String id = node.getAttribute("id");
            String name = node.getAttribute("name");
            String refer = node.getAttribute("refer");
            KeyRef el = new KeyRef();
            SchemaRep.this.pushCurrent(el);
            if (id != null && !id.equals("")) {
                el.setId(id);
            }
            if (name != null && !name.equals("")) {
                el.setElementName(name);
            }
            if (refer != null && !refer.equals("")) {
                el.setRefer(refer);
            }
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public Map validSubElementTypeMap() {
            return keyrefValidSubElementTypeMap;
        }

        @Override
        protected ElementInformationItem newInstance() {
            return new KeyRef();
        }
    }

    public class Unique
    extends ElementInformationItem {
        @Override
        public String getName() {
            return "unique";
        }

        @Override
        public Map validSubElementTypeMap() {
            return uniqueValidSubElementTypeMap;
        }

        @Override
        protected ElementInformationItem newInstance() {
            return new Unique();
        }
    }

    public class Key
    extends ElementInformationItem {
        @Override
        public String getName() {
            return "key";
        }

        @Override
        public Map validSubElementTypeMap() {
            return keyValidSubElementTypeMap;
        }

        @Override
        protected ElementInformationItem newInstance() {
            return new Key();
        }
    }

    public abstract class ElementInformationItem
    extends ContainsSubElements {
        private String id;
        private String name;

        public ElementInformationItem() {
        }

        public ElementInformationItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public String getContentName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getElementName() {
            return this.name;
        }

        public void setElementName(String name) {
            this.name = name;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            boolean hasNamedSubElements = this.writeDTDSubElementNames(out, true);
            return hasNamedSubElements;
        }

        @Override
        public String getAttributeString() {
            StringBuffer sb = new StringBuffer();
            if (this.name != null) {
                sb.append(" name='" + this.name + "'");
            }
            if (this.id != null) {
                sb.append(" id='" + this.id + "'");
            }
            return sb.toString();
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String id = node.getAttribute("id");
            String name = node.getAttribute("name");
            ElementInformationItem el = this.newInstance();
            SchemaRep.this.pushCurrent(el);
            if (id != null && !id.equals("")) {
                el.setId(id);
            }
            if (name != null && !name.equals("")) {
                el.setElementName(name);
            }
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        protected abstract ElementInformationItem newInstance();

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ElementInformationItem)) {
                return false;
            }
            ElementInformationItem el = (ElementInformationItem)o;
            if (this.id != el.id) {
                return false;
            }
            if (this.name != el.name) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class WhiteSpace
    extends RestrictionType
    implements DataTypeRestriction {
        public WhiteSpace(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "whiteSpace";
        }

        public boolean isPreserve() {
            return "preserve" == this.value;
        }

        public boolean isReplace() {
            return "replace" == this.value;
        }

        public boolean isCollapse() {
            return "collapse" == this.value;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.value == null || this.value.equals("")) {
                throw new IllegalStateException(Common.getMessage("MSG_InvalidWhiteSpaceValue", this.value));
            }
            if (this.value != "preserve" && this.value != "replace" && this.value != "collapse") {
                throw new IllegalStateException(Common.getMessage("MSG_InvalidWhiteSpaceValue", this.value));
            }
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new WhiteSpace(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            out.write("// has whitespace restriction\n");
        }
    }

    public class Length
    extends RestrictionType
    implements DataTypeRestriction {
        public Length(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "length";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new Length(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("if (" + JavaUtil.typeToString(type2, var) + ".length() != " + this.value + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            } else {
                out.write("if (" + JavaUtil.typeToString(type2, var) + ".length() == " + this.value + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }
    }

    public class FractionDigits
    extends RestrictionType
    implements DataTypeRestriction {
        public FractionDigits(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "fractionDigits";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new FractionDigits(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("{\n");
                out.write("String _tmp = " + JavaUtil.typeToString(type2, var) + ";\n");
                out.write("int dotPos = _tmp.indexOf('.');\n");
                out.write("if (dotPos >= 0) {\n");
                out.write("_tmp = _tmp.substring(dotPos+1, _tmp.length());\n");
                out.write("int digitCount = 0;\n");
                out.write("for (int _index1 = 0; _index1 < _tmp.length(); ++_index1) {\n");
                out.write("if (Character.isDigit(_tmp.charAt(_index1))) {\n");
                out.write("++digitCount;\n");
                out.write("if (digitCount > " + this.value + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("break;\n");
                out.write("}\n");
                out.write("}\n");
                out.write("}\n");
                out.write("}\n");
                out.write("}\n");
            } else {
                out.write("{\n");
                out.write("String _tmp = " + JavaUtil.typeToString(type2, var) + ";\n");
                out.write("int dotPos = _tmp.indexOf('.');\n");
                out.write("if (dotPos >= 0) {\n");
                out.write("_tmp = _tmp.substring(dotPos+1, _tmp.length());\n");
                out.write("int digitCount = 0;\n");
                out.write("for (int _index1 = 0; _index1 < _tmp.length(); ++_index1) {\n");
                out.write("if (Character.isDigit(_tmp.charAt(_index1))) {\n");
                out.write("++digitCount;\n");
                out.write("}\n");
                out.write("}\n");
                out.write("if (digitCount <= " + this.value + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
                out.write("}\n");
                out.write("else\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }
    }

    public class MaxInclusive
    extends RestrictionType
    implements DataTypeRestriction {
        public MaxInclusive(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "maxInclusive";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new MaxInclusive(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("if (" + JavaUtil.compareToText(var, type2, this.value) + " > 0) {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            } else {
                out.write("if (" + JavaUtil.compareToText(var, type2, this.value) + " <= 0) {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }
    }

    public class MinInclusive
    extends RestrictionType
    implements DataTypeRestriction {
        public MinInclusive(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "minInclusive";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new MinInclusive(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("if (" + JavaUtil.compareToText(var, type2, this.value) + " < 0) {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            } else {
                out.write("if (" + JavaUtil.compareToText(var, type2, this.value) + " >= 0) {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }
    }

    public class TotalDigits
    extends RestrictionType
    implements DataTypeRestriction {
        public TotalDigits(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "totalDigits";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new TotalDigits(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("{\n");
                out.write("String _tmp = " + JavaUtil.typeToString(type2, var) + ";\n");
                out.write("int digitCount = 0;\n");
                out.write("for (int _index1 = 0; _index1 < _tmp.length(); ++_index1) {\n");
                out.write("if (Character.isDigit(_tmp.charAt(_index1))) {\n");
                out.write("++digitCount;\n");
                out.write("if (digitCount > " + this.value + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("break;\n");
                out.write("}\n");
                out.write("}\n");
                out.write("}\n");
                out.write("}\n");
            } else {
                out.write("{\n");
                out.write("String _tmp = " + JavaUtil.typeToString(type2, var) + ";\n");
                out.write("int digitCount = 0;\n");
                out.write("for (int _index1 = 0; _index1 < _tmp.length(); ++_index1) {\n");
                out.write("if (Character.isDigit(_tmp.charAt(_index1))) {\n");
                out.write("++digitCount;\n");
                out.write("}\n");
                out.write("}\n");
                out.write("if (digitCount <= " + this.value + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
                out.write("}\n");
            }
        }
    }

    public class MaxLength
    extends RestrictionType
    implements DataTypeRestriction {
        public MaxLength(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "maxLength";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new MaxLength(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("if ((" + JavaUtil.typeToString(type2, var) + ").length() > " + this.value + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            } else {
                out.write("if ((" + JavaUtil.typeToString(type2, var) + ").length() <= " + this.value + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }
    }

    public class MinLength
    extends RestrictionType
    implements DataTypeRestriction {
        public MinLength(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "minLength";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new MinLength(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("if ((" + JavaUtil.typeToString(type2, var) + ").length() < " + this.value + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            } else {
                out.write("if ((" + JavaUtil.typeToString(type2, var) + ").length() >= " + this.value + ") {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }
    }

    public class Pattern
    extends RestrictionType
    implements DataTypeRestriction {
        public Pattern(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "pattern";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new Pattern(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("if (!(" + JavaUtil.typeToString(type2, var) + ").matches(" + this.xsdRegExpToJava(JavaUtil.instanceFrom("java.lang.String", this.value)) + ")) {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            } else {
                out.write("if ((" + JavaUtil.typeToString(type2, var) + ").matches(" + this.xsdRegExpToJava(JavaUtil.instanceFrom("java.lang.String", this.value)) + ")) {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }

        private String xsdRegExpToJava(String xsd) {
            String fixed = xsd;
            fixed = fixed.replaceAll(java.util.regex.Pattern.quote("\\\\i-[:]"), Matcher.quoteReplacement("[_A-Za-z]"));
            fixed = fixed.replaceAll(java.util.regex.Pattern.quote("\\\\i"), Matcher.quoteReplacement("[_:A-Za-z]"));
            fixed = fixed.replaceAll(java.util.regex.Pattern.quote("\\\\c-[:]"), Matcher.quoteReplacement("[-._A-Za-z0-9]"));
            fixed = fixed.replaceAll(java.util.regex.Pattern.quote("\\\\c"), Matcher.quoteReplacement("[-._:A-Za-z0-9]"));
            fixed = fixed.replaceAll(java.util.regex.Pattern.quote("\\\\I"), Matcher.quoteReplacement("[^_:A-Za-z]"));
            fixed = fixed.replaceAll(java.util.regex.Pattern.quote("\\\\C"), Matcher.quoteReplacement("[^-._:A-Za-z0-9]"));
            return fixed;
        }
    }

    public class Enumeration
    extends RestrictionType
    implements DataEnumRestriction {
        public Enumeration(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "enumeration";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new Enumeration(value);
        }

        @Override
        public void genRestriction(Writer out, String type2) throws IOException {
            out.write(JavaUtil.instanceFrom(type2, this.value));
        }
    }

    public class MinExclusive
    extends RestrictionType
    implements DataTypeRestriction {
        public MinExclusive(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "minExclusive";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new MinExclusive(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("if (" + JavaUtil.compareToText(var, type2, this.value) + " <= 0) {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            } else {
                out.write("if (" + JavaUtil.compareToText(var, type2, this.value) + " > 0) {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }
    }

    public class MaxExclusive
    extends RestrictionType
    implements DataTypeRestriction {
        public MaxExclusive(String value) {
            super(value);
        }

        @Override
        public String getName() {
            return "maxExclusive";
        }

        @Override
        protected RestrictionType newInstance(String value) {
            return new MaxExclusive(value);
        }

        @Override
        public void genRestriction(Writer out, String var, String type2, String failVar, boolean passCheck) throws IOException {
            if (!passCheck) {
                out.write("if (" + JavaUtil.compareToText(var, type2, this.value) + " >= 0) {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            } else {
                out.write("if (" + JavaUtil.compareToText(var, type2, this.value) + " < 0) {\n");
                out.write(failVar + " = true;\n");
                out.write("}\n");
            }
        }
    }

    public abstract class RestrictionType
    extends ContainsSubElements {
        protected String value;

        public RestrictionType(String value) {
            this.value = value == null ? null : value.intern();
        }

        @Override
        public String getContentName() {
            return null;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public void writeDTD(StringBuffer out) {
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return false;
        }

        @Override
        public void validate() {
        }

        @Override
        public ElementExpr optimize() {
            return this;
        }

        @Override
        public Map validSubElementTypeMap() {
            return restrictionTypeValidSubElementTypeMap;
        }

        @Override
        public void writeXMLSchema(XMLWriter out) throws IOException {
            out.startTag(SchemaRep.this.getXSDNamespace(), this.getName(), false);
            out.write(" value='");
            XMLUtil.printXML(out, this.value);
            out.write("'");
            out.finishStartTag(false, true);
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String myValue = node.getAttribute("value");
            RestrictionType el = this.newInstance(myValue);
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        protected abstract RestrictionType newInstance(String var1);

        @Override
        public String toString() {
            return this.getName() + " (" + this.value + ")";
        }
    }

    public class ListElement
    extends ContainsSubElements {
        protected String itemType;

        public ListElement() {
        }

        public ListElement(String itemType) {
            this.itemType = itemType;
        }

        @Override
        public String getContentName() {
            return null;
        }

        @Override
        public String getName() {
            return "list";
        }

        public void setItemType(String b) {
            this.itemType = b;
        }

        public String getItemType() {
            return this.itemType;
        }

        @Override
        public String getJavaTypeName() {
            return SchemaRep.this.schemaTypeToJavaType(this.itemType);
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return this.writeDTDSubElementNames(out, false);
        }

        @Override
        public String getAttributeString() {
            if (this.itemType == null) {
                return null;
            }
            return " itemType='" + this.getItemType() + "'";
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String itemType = node.getAttribute("itemType");
            ListElement el = new ListElement(itemType);
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public Map validSubElementTypeMap() {
            return listValidSubElementTypeMap;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ListElement)) {
                return false;
            }
            ListElement el = (ListElement)o;
            if (this.itemType == null ? el.itemType != null : !this.itemType.equals(el.itemType)) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class Extension
    extends ContainsSubElements
    implements HasJavaTypeName {
        protected String base;

        public Extension() {
        }

        public Extension(String base) {
            this.setBase(base);
        }

        @Override
        public String getContentName() {
            return null;
        }

        @Override
        public String getName() {
            return "extension";
        }

        public void setBase(String b) {
            this.base = SchemaRep.this.normalizeDocumentNamespace(b);
        }

        public String getBase() {
            return this.base;
        }

        @Override
        public String getJavaTypeName() {
            return SchemaRep.this.schemaTypeToJavaType(this.base);
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return this.writeDTDSubElementNames(out, false);
        }

        @Override
        public String getAttributeString() {
            if (this.base == null) {
                return null;
            }
            return " base='" + this.getBase() + "'";
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String base = node.getAttribute("base");
            Extension el = new Extension(base);
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public Map validSubElementTypeMap() {
            return extensionValidSubElementTypeMap;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Extension)) {
                return false;
            }
            Extension el = (Extension)o;
            if (this.base == null ? el.base != null : !this.base.equals(el.base)) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.base == null ? 0 : this.base.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class Restriction
    extends ContainsSubElements
    implements HasJavaTypeName {
        protected String base;

        public Restriction() {
        }

        public Restriction(String base) {
            this.setBase(base);
        }

        @Override
        public String getName() {
            return "restriction";
        }

        @Override
        public String getContentName() {
            return null;
        }

        public void setBase(String b) {
            if (b == null) {
                this.base = null;
                return;
            }
            this.base = SchemaRep.this.normalizeDocumentNamespace(b).intern();
        }

        public String getBase() {
            return this.base;
        }

        @Override
        public String getJavaTypeName() {
            return SchemaRep.this.schemaTypeToJavaType(this.base);
        }

        @Override
        public boolean compressWhiteSpaceOuter() {
            return this.subElements.size() == 0;
        }

        @Override
        public boolean compressWhiteSpaceInner() {
            return this.subElements.size() == 0;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return this.writeDTDSubElementNames(out, false);
        }

        @Override
        public String getAttributeString() {
            if (this.base == null) {
                return null;
            }
            return " base='" + this.getBase() + "'";
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String base = node.getAttribute("base");
            Restriction el = new Restriction(base);
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public Map validSubElementTypeMap() {
            return restrictionValidSubElementTypeMap;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Restriction)) {
                return false;
            }
            Restriction el = (Restriction)o;
            if (this.base == null ? el.base != null : !this.base.equals(el.base)) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public String toString() {
            Iterator subElements = this.subElementsIterator();
            StringBuffer sb = null;
            while (subElements.hasNext()) {
                ElementExpr ee = (ElementExpr)subElements.next();
                if (!(ee instanceof RestrictionType)) continue;
                if (sb == null) {
                    sb = new StringBuffer();
                } else {
                    sb.append(", ");
                }
                RestrictionType restrictionType = (RestrictionType)ee;
                sb.append(restrictionType.toString());
            }
            if (sb != null) {
                return sb.toString();
            }
            return "";
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.base == null ? 0 : this.base.hashCode());
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class Base64Binary
    extends SimpleType
    implements EncodingStyle {
        public Base64Binary() {
            super(SchemaRep.this.getXSDNamespace() + ":base64Binary", "byte[]");
        }

        @Override
        public String toString() {
            return "base64Binary";
        }
    }

    public class HexBinary
    extends SimpleType
    implements EncodingStyle {
        public HexBinary() {
            super(SchemaRep.this.getXSDNamespace() + ":hexBinary", "byte[]");
        }

        @Override
        public String toString() {
            return "hexBinary";
        }
    }

    public static interface EncodingStyle {
    }

    public class UnionType
    extends ContainsSubElements {
        private String typeName;
        private String memberTypes;

        public UnionType(String tn, String memberTypes) {
            this.typeName = null;
            this.memberTypes = null;
            if (tn != null && !tn.equals("")) {
                this.typeName = SchemaRep.this.normalizeTargetNamespace(tn).intern();
            }
            this.memberTypes = memberTypes;
        }

        public String getMemberTypes() {
            return this.memberTypes;
        }

        public ElementExpr[] getMemberTypeElements() {
            if (this.memberTypes == null || this.memberTypes.trim().length() == 0) {
                return null;
            }
            ArrayList<ElementExpr> mlist = new ArrayList<ElementExpr>();
            String[] members = this.memberTypes.trim().split(" ");
            for (int i = 0; i < members.length; ++i) {
                ElementExpr ee;
                if (members[i].length() == 0 || (ee = SchemaRep.this.getSchemaTypeDef(members[i])) == null) continue;
                mlist.add(ee);
            }
            ElementExpr[] memberList = new ElementExpr[mlist.size()];
            memberList = mlist.toArray(memberList);
            return memberList;
        }

        @Override
        public String getName() {
            return "union";
        }

        @Override
        public String getContentName() {
            return this.typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public String getAttributeString() {
            if (this.memberTypes == null) {
                return null;
            }
            return " memberTypes='" + this.memberTypes + "'";
        }

        @Override
        public boolean compressWhiteSpaceInner() {
            if (this.subElements.size() == 0) {
                return true;
            }
            ElementExpr subElement = (ElementExpr)this.subElementsIterator().next();
            if (subElement instanceof ContainsSubElements) {
                return ((ContainsSubElements)subElement).compressWhiteSpaceOuter();
            }
            return true;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return this.writeDTDSubElementNames(out, false);
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String memberTypes = node.getAttribute("memberTypes");
            String typeName = "_union";
            Node parent = node.getParentNode();
            if (parent instanceof org.w3c.dom.Element) {
                do {
                    org.w3c.dom.Element parentEl = (org.w3c.dom.Element)parent;
                    if (parent == null) break;
                    String name = parentEl.getAttribute("name");
                    if (name != null) {
                        typeName = name + typeName;
                        break;
                    }
                    typeName = "_simpleType" + typeName;
                } while ((parent = parent.getParentNode()) != null);
            }
            UnionType el = new UnionType(typeName, memberTypes);
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public Map validSubElementTypeMap() {
            return unionTypeValidSubElementTypeMap;
        }

        @Override
        public String toString() {
            if (this.typeName == null) {
                return "unionType (not named)";
            }
            return "unionType " + this.typeName;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof UnionType)) {
                return false;
            }
            UnionType el = (UnionType)o;
            if (this.typeName != el.typeName) {
                return false;
            }
            if (this.memberTypes != el.memberTypes) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + this.memberTypes.hashCode();
            result = 37 * result + this.typeName.hashCode();
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class SimpleType
    extends HasTypeName
    implements HasJavaTypeName {
        private String javaTypeName;

        public SimpleType(String tn) {
            this.javaTypeName = null;
            if (tn != null && !tn.equals("")) {
                String typeName = SchemaRep.this.normalizeTargetNamespace(tn).intern();
                ElementExpr previousDef = SchemaRep.this.getSchemaTypeDef(typeName);
                if (previousDef instanceof SimpleType && (((SimpleType)previousDef).javaTypeName != null || ((SimpleType)previousDef).subElements.size() > 0)) {
                    System.out.println("Keeping schemaTypeDefs1 for " + previousDef);
                } else {
                    if (previousDef != null) {
                        System.out.println("!!! Overwriting schemaTypeDefs1 (" + previousDef + ") for " + this);
                    }
                    typeName = this.setTypeName(typeName);
                    SchemaRep.this.putSchemaTypeDef(typeName, this);
                }
            }
        }

        public SimpleType(String tn, String javaTypeName) {
            this.javaTypeName = null;
            String typeName = this.setTypeName(tn);
            this.javaTypeName = javaTypeName == null ? null : javaTypeName.intern();
            SchemaRep.this.putSchemaTypeDef(typeName, this);
        }

        public SimpleType(String tn, Restriction restrict) {
            this.javaTypeName = null;
            String typeName = this.setTypeName(tn);
            this.addSubElement(restrict);
            SchemaRep.this.putSchemaTypeDef(typeName, this);
        }

        @Override
        public String getName() {
            return "simpleType";
        }

        @Override
        public String getContentName() {
            return this.getTypeName();
        }

        @Override
        public String getJavaTypeName() {
            if (this.javaTypeName != null) {
                return this.javaTypeName;
            }
            return super.getJavaTypeName();
        }

        @Override
        public String getAttributeString() {
            if (this.getTypeName() == null) {
                return null;
            }
            return " name='" + this.getTypeName() + "'";
        }

        @Override
        public boolean compressWhiteSpaceInner() {
            if (this.subElements.size() == 0) {
                return true;
            }
            ElementExpr subElement = (ElementExpr)this.subElementsIterator().next();
            if (subElement instanceof ContainsSubElements) {
                return ((ContainsSubElements)subElement).compressWhiteSpaceOuter();
            }
            return true;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return this.writeDTDSubElementNames(out, false);
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String elementType = node.getAttribute("name");
            SimpleType el = new SimpleType(elementType);
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public Map validSubElementTypeMap() {
            return simpleTypeValidSubElementTypeMap;
        }

        @Override
        public String toString() {
            if (this.javaTypeName == null) {
                if (this.getTypeName() == null) {
                    return "simpleType (not named)";
                }
                return "simpleType " + this.getTypeName();
            }
            return "simpleType " + this.getTypeName() + " " + this.javaTypeName;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SimpleType)) {
                return false;
            }
            SimpleType el = (SimpleType)o;
            if (this.getTypeName() == null ? el.getTypeName() == null : this.getTypeName().equals(el.getTypeName())) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            if (this.getTypeName() != null) {
                result = 37 * result + this.getTypeName().hashCode();
            }
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class ComplexContent
    extends ContainsSubElements
    implements HasJavaTypeName {
        private boolean mixed;

        @Override
        public String getName() {
            return "complexContent";
        }

        @Override
        public String getContentName() {
            return null;
        }

        @Override
        public void validate() {
        }

        @Override
        public ElementExpr optimize() {
            return this;
        }

        public boolean isMixed() {
            return this.mixed;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            ComplexContent el = new ComplexContent();
            String myMixed = node.getAttribute("mixed");
            if (myMixed != null && (myMixed.equals("true") || myMixed.equals("yes") || myMixed.equals("on"))) {
                el.mixed = true;
            }
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return this.writeDTDSubElementNames(out, false);
        }

        @Override
        public Map validSubElementTypeMap() {
            return complexContentValidSubElementTypeMap;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ComplexContent)) {
                return false;
            }
            ComplexContent el = (ComplexContent)o;
            if (this.mixed != el.mixed) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.mixed ? 0 : 1);
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class SimpleContent
    extends ContainsSubElements
    implements HasJavaTypeName {
        @Override
        public String getName() {
            return "simpleContent";
        }

        @Override
        public String getContentName() {
            return null;
        }

        @Override
        public void validate() {
        }

        @Override
        public ElementExpr optimize() {
            return this;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            SimpleContent el = new SimpleContent();
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return this.writeDTDSubElementNames(out, false);
        }

        @Override
        public Map validSubElementTypeMap() {
            return simpleContentValidSubElementTypeMap;
        }
    }

    public class ComplexType
    extends HasTypeName
    implements HasJavaTypeName {
        private boolean mixed;
        private boolean abstractType;

        public ComplexType() {
            this.mixed = false;
            this.abstractType = false;
        }

        public ComplexType(String typeName) {
            this.mixed = false;
            this.abstractType = false;
            if (typeName != null && !typeName.equals("")) {
                typeName = this.setTypeName(typeName);
                SchemaRep.this.putSchemaTypeDef(typeName, this);
            }
        }

        @Override
        public String getName() {
            return "complexType";
        }

        @Override
        public String getContentName() {
            return this.getTypeName();
        }

        public boolean isMixed() {
            return this.mixed;
        }

        public boolean isAbstract() {
            return this.abstractType;
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return this.writeDTDSubElementNames(out, false);
        }

        @Override
        public String getAttributeString() {
            String result = "";
            if (this.getTypeName() != null) {
                result = result + " name='" + this.getTypeName() + "'";
            }
            if (this.mixed) {
                result = result + " mixed='true'";
            }
            if (this.abstractType) {
                result = result + " abstract='true'";
            }
            return result;
        }

        @Override
        public Map validSubElementTypeMap() {
            return complexTypeValidSubElementTypeMap;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String elementType = node.getAttribute("name");
            String myMixed = node.getAttribute("mixed");
            String myAbstract = node.getAttribute("abstract");
            ComplexType el = new ComplexType(elementType);
            if (myMixed != null && (myMixed.equals("true") || myMixed.equals("yes") || myMixed.equals("on"))) {
                el.mixed = true;
            }
            if (myAbstract != null && (myAbstract.equals("true") || myAbstract.equals("yes") || myAbstract.equals("on"))) {
                el.abstractType = true;
            }
            if (debug) {
                System.out.println("Created complexType " + elementType);
            }
            SchemaRep.this.pushCurrent(el);
            SchemaRep.this.read(node);
            SchemaRep.this.popCurrent();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ComplexType)) {
                return false;
            }
            ComplexType el = (ComplexType)o;
            if (this.getTypeName() == null ? el.getTypeName() == null : this.getTypeName().equals(el.getTypeName())) {
                return false;
            }
            if (this.mixed != el.mixed) {
                return false;
            }
            if (this.abstractType != el.abstractType) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.getTypeName() == null ? 0 : this.getTypeName().hashCode());
            result = 37 * result + (this.mixed ? 1 : 0);
            result = 37 * result + (this.abstractType ? 1 : 0);
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public class SchemaNode
    extends ContainsSubElements {
        protected String targetNamespace;
        private Boolean elementFormQualifiedDefault;
        private Boolean attributeFormQualifiedDefault;

        public SchemaNode() {
            this.elementFormQualifiedDefault = null;
            this.attributeFormQualifiedDefault = null;
        }

        @Override
        public String getName() {
            return "schema";
        }

        @Override
        public String getContentName() {
            return null;
        }

        public void setTargetNamespace(String tn) {
            this.targetNamespace = tn;
        }

        public String getTargetNamespace() {
            return this.targetNamespace;
        }

        public boolean isElementFormQualified() {
            if (this.elementFormQualifiedDefault == null) {
                return false;
            }
            return this.elementFormQualifiedDefault;
        }

        public boolean isAttributeFormQualified() {
            if (this.attributeFormQualifiedDefault == null) {
                return false;
            }
            return this.attributeFormQualifiedDefault;
        }

        @Override
        public void readSchema(org.w3c.dom.Element node) {
            String tns = node.getAttribute("targetNamespace");
            String efd = node.getAttribute("elementFormDefault");
            String afd = node.getAttribute("attributeFormDefault");
            if (tns != null && !"".equals(tns)) {
                this.targetNamespace = tns;
            }
            if (efd != null) {
                this.elementFormQualifiedDefault = "qualified".equals(efd);
            }
            SchemaRep.this.elementFormQualifiedDefault = this.isElementFormQualified();
            if (afd != null) {
                this.attributeFormQualifiedDefault = "qualified".equals(afd);
            }
            SchemaRep.this.attributeFormQualifiedDefault = this.isAttributeFormQualified();
        }

        void merge(org.w3c.dom.Element node) {
            String tns = node.getAttribute("targetNamespace");
            String efd = node.getAttribute("elementFormDefault");
            String afd = node.getAttribute("attributeFormDefault");
            if (this.targetNamespace == null) {
                this.targetNamespace = tns;
            }
            boolean value = "qualified".equals(efd);
            if (efd != null && (this.elementFormQualifiedDefault == null || this.elementFormQualifiedDefault.booleanValue())) {
                this.elementFormQualifiedDefault = value;
            }
            SchemaRep.this.elementFormQualifiedDefault = value;
            value = "qualified".equals(afd);
            if (afd != null && (this.attributeFormQualifiedDefault == null || this.attributeFormQualifiedDefault.booleanValue())) {
                this.attributeFormQualifiedDefault = value;
            }
            SchemaRep.this.attributeFormQualifiedDefault = value;
        }

        @Override
        public void addSubElement(ElementExpr subElement) {
            Attribute attr;
            Element el;
            if (subElement instanceof Element && (el = (Element)subElement).isDefiningNewType()) {
                if (debug) {
                    System.out.println("SchemaNode new element type: name=" + el.getElementName());
                }
                SchemaRep.this.definedTypes.put(el.getElementName(), el);
                SchemaRep.this.definedTypesFull.put(SchemaRep.canonicalQName(el.getElementNamespace(), el.getElementName()), el);
            }
            if (subElement instanceof Attribute && (attr = (Attribute)subElement).isDefiningNewType()) {
                if (debug) {
                    System.out.println("SchemaNode new element type: attr=" + attr);
                }
                SchemaRep.this.definedAttributes.put(attr.getAttributeName(), attr);
            }
            super.addSubElement(subElement);
        }

        @Override
        public String getAttributeString() {
            StringBuffer sb = new StringBuffer(" xmlns:" + SchemaRep.this.getXSDNamespace() + "='" + SchemaRep.this.getNamespaceURI(SchemaRep.this.getXSDNamespace()) + "'");
            if (this.targetNamespace != null) {
                sb.append(" targetNamespace='" + this.getTargetNamespace() + "'");
            }
            if (SchemaRep.this.documentNamespace != null) {
                sb.append(" xmlns='" + SchemaRep.this.documentNamespace + "'");
            }
            if (this.isElementFormQualified()) {
                sb.append(" elementFormDefault='qualified'");
            }
            if (this.isAttributeFormQualified()) {
                sb.append(" attributeFormDefault='qualified'");
            }
            return sb.toString();
        }

        @Override
        public void writeXMLSchema(XMLWriter out) throws IOException {
            out.startTag(SchemaRep.this.getXSDNamespace(), this.getName(), this.getAttributeString());
            out.cr();
            for (String type2 : SchemaRep.this.requiredPredefinedTypes.keySet()) {
                ElementExpr el = (ElementExpr)SchemaRep.this.optionallyDefinedTypes.get(type2);
                el.writeXMLSchema(out);
            }
            super.writeXMLSchema(out, false);
            out.endTag();
        }

        @Override
        public boolean writeDTDName(StringBuffer out) {
            return this.writeDTDSubElementNames(out, false);
        }

        @Override
        public Map validSubElementTypeMap() {
            return schemaValidSubElementTypeMap;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SchemaNode)) {
                return false;
            }
            SchemaNode el = (SchemaNode)o;
            if (this.targetNamespace == null ? el.targetNamespace != null : !this.targetNamespace.equals(el.targetNamespace)) {
                return false;
            }
            if (this.elementFormQualifiedDefault != el.elementFormQualifiedDefault) {
                return false;
            }
            if (this.attributeFormQualifiedDefault != el.attributeFormQualifiedDefault) {
                return false;
            }
            return super.equals(el);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.targetNamespace == null ? 0 : this.targetNamespace.hashCode());
            result = 37 * result + (this.elementFormQualifiedDefault != false ? 1 : 0);
            result = 37 * result + (this.attributeFormQualifiedDefault != false ? 1 : 0);
            result = 37 * result + super.hashCode();
            return result;
        }
    }

    public abstract class HasTypeName
    extends ContainsSubElements {
        private String typeNameLocalPart;
        private String typeNameNamespace;

        public HasTypeName() {
            this.typeNameLocalPart = null;
            this.typeNameNamespace = null;
        }

        protected String setTypeName(String typeName) {
            if (typeName == null) {
                this.typeNameLocalPart = null;
                this.typeNameNamespace = null;
                return null;
            }
            typeName = SchemaRep.this.normalizeTargetNamespace(typeName).intern();
            this.typeNameLocalPart = SchemaRep.removePrefix(typeName).intern();
            String prefix = SchemaRep.prefixOf(typeName);
            this.typeNameNamespace = SchemaRep.this.getNamespaceURI(prefix);
            if (this.typeNameNamespace != null) {
                this.typeNameNamespace = this.typeNameNamespace.intern();
            }
            return typeName;
        }

        public String getTypeNameLocalPart() {
            return this.typeNameLocalPart;
        }

        public String getTypeNameNamespace() {
            return this.typeNameNamespace;
        }

        public String getTypeName() {
            if (this.typeNameLocalPart == null) {
                return null;
            }
            String result = SchemaRep.this.normalizeNamespace(this.typeNameNamespace, this.typeNameLocalPart);
            return result;
        }
    }

    public static interface CanRef {
        public boolean hasRef();

        public String getRef();

        public ElementExpr getRefElementExpr();
    }

    public static interface MinMaxOccurs {
        public String getMinOccurs();

        public String getMaxOccurs();
    }

    public static interface HasJavaTypeName {
        public String getJavaTypeName();
    }

    public abstract class ContainsSubElements
    extends ElementExpr {
        protected List subElements;

        public ContainsSubElements() {
            this.subElements = new LinkedList();
        }

        public void addSubElement(ElementExpr subElement) {
            subElement.setParentExpr(this);
            if (subElement instanceof Element) {
                boolean checkAgain;
                do {
                    checkAgain = false;
                    String subElementFullContentName = subElement.getFullContentName();
                    for (ElementExpr otherElement : this.subElements) {
                        String otherElementFullContentName = otherElement.getFullContentName();
                        if (subElementFullContentName != otherElementFullContentName) continue;
                        if (debug) {
                            System.out.println("Found duplicate fullContentName for " + otherElement.getName() + " : " + subElementFullContentName);
                        }
                        subElement.uniquifyFullContentName();
                        checkAgain = true;
                    }
                } while (checkAgain);
            }
            this.subElements.add(subElement);
        }

        public void addSubElement(List se) {
            Iterator it = se.iterator();
            while (it.hasNext()) {
                this.addSubElement((ElementExpr)it.next());
            }
        }

        public Iterator subElementsIterator() {
            return this.subElements.iterator();
        }

        public ElementExpr findSubElement(String nodeName) {
            for (ElementExpr el : this.subElements) {
                if (!el.getName().equals(nodeName)) continue;
                return el;
            }
            return null;
        }

        public ElementExpr findSubElement(Class type2) {
            for (ElementExpr el : this.subElements) {
                if (!type2.isAssignableFrom(el.getClass())) continue;
                return el;
            }
            return null;
        }

        public ElementExpr findSubElement(String[] nodeNames) {
            ContainsSubElements current = this;
            for (int i = 0; i < nodeNames.length; ++i) {
                ElementExpr ee = current.findSubElement(nodeNames[i]);
                if (ee == null) {
                    return null;
                }
                if (ee instanceof ContainsSubElements) {
                    current = (ContainsSubElements)ee;
                    continue;
                }
                if (i + 1 == nodeNames.length) continue;
                return null;
            }
            return current;
        }

        public void findAllSubElements(String name, List lst) {
            for (ElementExpr el : this.subElements) {
                if (el.getName().equals(name)) {
                    lst.add(el);
                }
                if (!(el instanceof ContainsSubElements)) continue;
                ((ContainsSubElements)el).findAllSubElements(name, lst);
            }
        }

        public void findAllSubElements(Class type2, List lst) {
            for (ElementExpr el : this.subElements) {
                if (type2.isAssignableFrom(el.getClass())) {
                    lst.add(el);
                }
                if (!(el instanceof ContainsSubElements)) continue;
                ((ContainsSubElements)el).findAllSubElements(type2, lst);
            }
        }

        @Override
        public void validate() {
            Map possibleSubElements = this.validSubElementTypeMap();
            for (ElementExpr ee : this.subElements) {
                if (!possibleSubElements.containsKey(ee.getClass())) {
                    throw new IllegalStateException(Common.getMessage("MSG_InvalidContents", this.toString(), ee.getName(), this.getFullContentName()));
                }
                ee.validate();
            }
        }

        public abstract Map validSubElementTypeMap();

        @Override
        public void writeDTD(StringBuffer out) {
            for (ElementExpr el : this.subElements) {
                el.writeDTD(out);
            }
        }

        public String getAttributeString() {
            return null;
        }

        public boolean compressWhiteSpaceOuter() {
            return false;
        }

        public boolean compressWhiteSpaceInner() {
            return false;
        }

        @Override
        public void writeXMLSchema(XMLWriter out) throws IOException {
            this.writeXMLSchema(out, true);
        }

        public void writeXMLSchema(XMLWriter out, boolean printMyElement) throws IOException {
            if (printMyElement) {
                out.startTag(SchemaRep.this.getXSDNamespace(), this.getName(), false);
                String attrs = this.getAttributeString();
                if (attrs != null) {
                    out.write(attrs);
                }
                out.finishStartTag(this.subElements.size() > 0, !this.compressWhiteSpaceInner());
                if (this.subElements.size() == 0) {
                    return;
                }
            }
            for (ElementExpr el : this.subElements) {
                el.writeXMLSchema(out);
            }
            if (printMyElement) {
                out.endTag(!this.compressWhiteSpaceOuter());
            }
        }

        protected boolean writeDTDSubElementNames(StringBuffer out) {
            return this.writeDTDSubElementNames(out, true);
        }

        protected boolean writeDTDSubElementNames(StringBuffer out, boolean writeParens) {
            if (this.subElements.size() == 0) {
                return false;
            }
            boolean first = true;
            Iterator it = this.subElements.iterator();
            boolean hasNamedSubElements = false;
            StringBuffer subOut = new StringBuffer();
            StringBuffer freshOut = new StringBuffer();
            while (it.hasNext()) {
                ElementExpr el = (ElementExpr)it.next();
                boolean anyNamed = el.writeDTDName(freshOut);
                if (!anyNamed) continue;
                hasNamedSubElements = true;
                if (first) {
                    first = false;
                } else {
                    subOut.append(", ");
                }
                subOut.append(freshOut.toString());
                freshOut = new StringBuffer();
            }
            if (!hasNamedSubElements) {
                return false;
            }
            if (writeParens && this.subElements.size() >= 2) {
                out.append("(");
            }
            out.append(subOut);
            if (writeParens && this.subElements.size() >= 2) {
                out.append(")");
            }
            return hasNamedSubElements;
        }

        public void findSubElementNames(List list) {
            Iterator it = this.subElements.iterator();
            StringBuffer freshOut = new StringBuffer();
            while (it.hasNext()) {
                ElementExpr el = (ElementExpr)it.next();
                boolean bl = el.writeDTDName(freshOut);
            }
        }

        public String toString() {
            String attributeString = this.getAttributeString();
            if (attributeString == null) {
                return this.getName();
            }
            return this.getName() + attributeString;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ContainsSubElements)) {
                return false;
            }
            ContainsSubElements e = (ContainsSubElements)o;
            if (this.subElements.size() != e.subElements.size()) {
                return false;
            }
            Iterator it = this.subElements.iterator();
            Iterator ite = e.subElements.iterator();
            while (it.hasNext()) {
                ElementExpr ele;
                ElementExpr el = (ElementExpr)it.next();
                if (el.equals(ele = (ElementExpr)ite.next())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 17;
            for (ElementExpr el : this.subElements) {
                result = 37 * result + el.hashCode();
            }
            return result;
        }

        @Override
        public ElementExpr optimize() {
            ListIterator<ElementExpr> it = this.subElements.listIterator();
            while (it.hasNext()) {
                ElementExpr el = (ElementExpr)it.next();
                ElementExpr result = el.optimize();
                if (result == null) {
                    el.setParentExpr(null);
                    it.remove();
                    continue;
                }
                if (el == result) continue;
                it.set(result);
            }
            return this;
        }

        public String getJavaTypeName() {
            for (Object o : this.subElements) {
                if (!(o instanceof HasJavaTypeName)) continue;
                return ((HasJavaTypeName)o).getJavaTypeName();
            }
            return null;
        }
    }

    public abstract class ElementExpr {
        protected ElementExpr parentExpr;
        private String fullContentName = null;

        public abstract String getName();

        public abstract void writeDTD(StringBuffer var1);

        public abstract boolean writeDTDName(StringBuffer var1);

        public abstract void writeXMLSchema(XMLWriter var1) throws IOException;

        public abstract void validate();

        public abstract ElementExpr optimize();

        public abstract void readSchema(org.w3c.dom.Element var1);

        public abstract String getContentName();

        protected void setParentExpr(ElementExpr ee) {
            this.parentExpr = ee;
            this.fullContentName = null;
        }

        public ElementExpr getParentExpr() {
            return this.parentExpr;
        }

        public String getFullContentName() {
            if (this.fullContentName == null) {
                String contentName = this.getContentName();
                if (this.parentExpr == null) {
                    this.fullContentName = contentName == null ? "/" : ("/" + contentName).intern();
                } else {
                    String parentFullContentName = this.parentExpr.getFullContentName();
                    this.fullContentName = contentName == null ? parentFullContentName : (parentFullContentName == "/" ? (parentFullContentName + contentName).intern() : (parentFullContentName + "/" + contentName).intern());
                }
            }
            return this.fullContentName;
        }

        protected String uniquifyFullContentName() {
            this.fullContentName = (this.getFullContentName() + "/#").intern();
            return this.fullContentName;
        }
    }
}

