/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.provider.internal;

import jakarta.inject.Singleton;
import java.util.Map;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InstanceLifecycleEvent;
import org.glassfish.hk2.api.InstanceLifecycleEventType;
import org.glassfish.hk2.api.InstanceLifecycleListener;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.ObservableBean;

@Service
@Singleton
public class ConfigInstanceListener
implements InstanceLifecycleListener {
    private final Filter filter = BuilderHelper.createContractFilter(ConfigListener.class.getName());

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void lifecycleEvent(InstanceLifecycleEvent lifecycleEvent) {
        if (!lifecycleEvent.getEventType().equals((Object)InstanceLifecycleEventType.POST_PRODUCTION)) {
            return;
        }
        Map<Injectee, Object> injectees = lifecycleEvent.getKnownInjectees();
        if (injectees == null) {
            return;
        }
        ConfigListener listener = (ConfigListener)lifecycleEvent.getLifecycleObject();
        for (Object injectee : injectees.values()) {
            ConfigBeanProxy configBeanProxy;
            ConfigView impl;
            if (!(injectee instanceof ConfigBeanProxy) || !((impl = ConfigSupport.getImpl(configBeanProxy = (ConfigBeanProxy)injectee)) instanceof ObservableBean)) continue;
            ObservableBean ob = (ObservableBean)((Object)impl);
            ob.addListener(listener);
        }
    }
}

