/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.InstanceLifecycleListener;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.DescriptorImpl;

public class HK2DomConfigUtilities {
    private static final String CONFIG_SUPPORT_IMPL = "org.jvnet.hk2.config.ConfigSupport";
    private static final String CONFIGURATION_UTILITIES = "org.jvnet.hk2.config.api.ConfigurationUtilities";
    private static final String CONFIGURATION_POPULATOR_IMPL = "org.jvnet.hk2.config.ConfigurationPopulator";
    private static final String CONFIG_POPULATOR = "org.glassfish.hk2.bootstrap.ConfigPopulator";
    private static final String TRANSACTIONS_IMPL = "org.jvnet.hk2.config.Transactions";
    private static final String CONFIG_INSTANCE_LISTENER_IMPL = "org.jvnet.hk2.config.provider.internal.ConfigInstanceListener";

    public static void enableHK2DomConfiguration(ServiceLocator locator, HK2Loader loader) {
        DynamicConfigurationService dcs = locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        boolean dirty = false;
        boolean operationDirty = HK2DomConfigUtilities.addIfNotThere(locator, config, HK2DomConfigUtilities.getConfigSupport(), loader);
        dirty = dirty || operationDirty;
        operationDirty = HK2DomConfigUtilities.addIfNotThere(locator, config, HK2DomConfigUtilities.getConfigurationPopulator(), loader);
        dirty = dirty || operationDirty;
        operationDirty = HK2DomConfigUtilities.addIfNotThere(locator, config, HK2DomConfigUtilities.getTransactions(), loader);
        dirty = dirty || operationDirty;
        operationDirty = HK2DomConfigUtilities.addIfNotThere(locator, config, HK2DomConfigUtilities.getConfigInstanceListener(), loader);
        boolean bl = dirty = dirty || operationDirty;
        if (dirty) {
            config.commit();
        }
    }

    public static void enableHK2DomConfiguration(ServiceLocator locator) {
        HK2DomConfigUtilities.enableHK2DomConfiguration(locator, null);
    }

    private static DescriptorImpl getConfigSupport() {
        return BuilderHelper.link(CONFIG_SUPPORT_IMPL).to(CONFIGURATION_UTILITIES).in(Singleton.class.getName()).build();
    }

    private static DescriptorImpl getConfigurationPopulator() {
        return BuilderHelper.link(CONFIGURATION_POPULATOR_IMPL).to(CONFIG_POPULATOR).in(Singleton.class.getName()).build();
    }

    private static DescriptorImpl getTransactions() {
        return BuilderHelper.link(TRANSACTIONS_IMPL).in(Singleton.class.getName()).build();
    }

    private static DescriptorImpl getConfigInstanceListener() {
        return BuilderHelper.link(CONFIG_INSTANCE_LISTENER_IMPL).to(InstanceLifecycleListener.class.getName()).in(Singleton.class.getName()).build();
    }

    private static boolean addIfNotThere(ServiceLocator locator, DynamicConfiguration config, DescriptorImpl desc, HK2Loader loader) {
        IndexedFilter filter = BuilderHelper.createContractFilter(desc.getImplementation());
        if (locator.getBestDescriptor(filter) != null) {
            return false;
        }
        if (loader != null) {
            desc.setLoader(loader);
        }
        config.bind(desc);
        return true;
    }
}

